/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.migration;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;

public class RetargetMessageEndFromExecutionSpecificationToLifelineDiagramReconciler_1_4_0
extends DiagramReconciler {
    public ICommand getReconcileCommand(Diagram diagram) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
        Assert.isNotNull((Object)domain);
        CompositeCommand cc = new CompositeCommand("Retarget Message from ExecutionSpecification to Lifeline");
        for (Object current : diagram.getEdges()) {
            ICommand tmp;
            if (!this.isAMessageConnector(current)) continue;
            Connector connector = (Connector)current;
            if (this.migrateSource(connector) && (tmp = this.getRetargetCommand(domain, connector, true)) != null && tmp.canExecute()) {
                cc.add((IUndoableOperation)tmp);
            }
            if (!this.migrateTarget(connector) || (tmp = this.getRetargetCommand(domain, connector, false)) == null || !tmp.canExecute()) continue;
            cc.add((IUndoableOperation)tmp);
        }
        return cc.canExecute() ? cc : null;
    }

    private ICommand getRetargetCommand(TransactionalEditingDomain domain, Connector editedConnector, boolean updateSource) {
        CompositeCommand cc = new CompositeCommand(NLS.bind((String)"Update Graphical {0} for Message {1}.", (Object)(updateSource ? "source" : "target"), (Object)((NamedElement)editedConnector.getElement()).getName()));
        Shape lifeline = updateSource ? this.getNewSource(editedConnector) : this.getNewTarget(editedConnector);
        IdentityAnchor oldAnchor = updateSource ? (IdentityAnchor)editedConnector.getSourceAnchor() : (IdentityAnchor)editedConnector.getTargetAnchor();
        Shape oldEndShape = updateSource ? (Shape)editedConnector.getSource() : (Shape)editedConnector.getTarget();
        Bounds oldEnd_Size = (Bounds)oldEndShape.getLayoutConstraint();
        PrecisionPoint currentPercentageOnOldEndShape = BaseSlidableAnchor.parseTerminalString((String)oldAnchor.getId());
        double yOnOldEndShape = currentPercentageOnOldEndShape.preciseY() * (double)oldEnd_Size.getHeight();
        double yOnLifeline = yOnOldEndShape + (double)oldEnd_Size.getY();
        Bounds lifelineBounds = (Bounds)lifeline.getLayoutConstraint();
        double yPercentage = yOnLifeline / new Double(lifelineBounds.getHeight());
        String newTerminal = "(0.5," + yPercentage + ")";
        SetConnectionAnchorsCommand anchorCommand = new SetConnectionAnchorsCommand(domain, NLS.bind((String)"Update anchors for {0}.", (Object)((NamedElement)editedConnector.getElement()).getName()));
        anchorCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)editedConnector));
        if (updateSource) {
            anchorCommand.setNewSourceTerminal(newTerminal);
        } else {
            anchorCommand.setNewTargetTerminal(newTerminal);
        }
        cc.add((IUndoableOperation)anchorCommand);
        EReference editedFeature = updateSource ? NotationPackage.eINSTANCE.getEdge_Source() : NotationPackage.eINSTANCE.getEdge_Target();
        cc.add((IUndoableOperation)new EMFtoGMFCommandWrapper(SetCommand.create((EditingDomain)domain, (Object)editedConnector, (Object)editedFeature, (Object)lifeline)));
        return cc;
    }

    private boolean isLifelineShape(View view) {
        return view instanceof Shape && view.getElement() instanceof Lifeline && "Lifeline_Shape".equals(view.getType());
    }

    private boolean isAMessageConnector(Object object) {
        return object instanceof Connector && ((Connector)object).getElement() instanceof Message;
    }

    private boolean migrateSource(Connector messageConnector) {
        return this.isAnExecutionSpecification(messageConnector.getSource());
    }

    private boolean migrateTarget(Connector messageConnector) {
        return this.isAnExecutionSpecification(messageConnector.getTarget());
    }

    private Shape getNewSource(Connector messageConnector) {
        View parentSource;
        View source = messageConnector.getSource();
        if (this.isAnExecutionSpecification(source) && this.isLifelineShape(parentSource = (View)source.eContainer())) {
            return (Shape)parentSource;
        }
        return null;
    }

    private Shape getNewTarget(Connector messageConnector) {
        View parentSource;
        View target = messageConnector.getTarget();
        if (this.isAnExecutionSpecification(target) && this.isLifelineShape(parentSource = (View)target.eContainer())) {
            return (Shape)parentSource;
        }
        return null;
    }

    private boolean isAnExecutionSpecification(View view) {
        return view instanceof Shape && ("ActionExecutionSpecification_Shape".equals(view.getType()) || "BehaviorExecutionSpecification_Shape".equals(view.getType()));
    }
}

