/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.releng.tools.internal.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cbi.p2repo.aggregator.Aggregation;
import org.eclipse.cbi.p2repo.aggregator.AggregatorPackage;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.MappedRepository;
import org.eclipse.cbi.p2repo.aggregator.transformer.TransformationManager;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.papyrus.releng.tools.internal.Activator;
import org.eclipse.papyrus.releng.tools.internal.popup.actions.UpdateDependencies;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddSetupRepositoryUpdateAnnotationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Collection<Repository> repositories = this.getSelectedRepositories(event);
        if (!repositories.isEmpty()) {
            Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            try {
                IFile aggrFile = UpdateDependencies.chooseAggregationBuildFile(UpdateDependencies.findAggregationBuildFiles(), activeShell);
                if (aggrFile != null) {
                    ResourceSetImpl rset = new ResourceSetImpl();
                    List<IAggregationElementProxy> elements = this.loadContributionsAndRepositories((ResourceSet)rset, URI.createPlatformResourceURI((String)aggrFile.getFullPath().toString(), (boolean)true));
                    HashMap<Repository, IAggregationElementProxy> updates = new HashMap<Repository, IAggregationElementProxy>();
                    for (Repository repo : repositories) {
                        IAggregationElementProxy selected;
                        FilteredItemsSelectionDialog dlg = this.createSelectionDialog(activeShell, repo, elements);
                        if (dlg.open() != 0 || (selected = (IAggregationElementProxy)dlg.getFirstResult()) == null) continue;
                        updates.put(repo, selected);
                    }
                    if (!updates.isEmpty()) {
                        this.createOrUpdateAnnotations(updates);
                    }
                }
            }
            catch (CoreException e) {
                throw new ExecutionException("Failed to set the repository update annotation.", (Throwable)e);
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(!this.getSelectedRepositories(evaluationContext).isEmpty());
    }

    private Collection<Repository> getSelectedRepositories(Object context) {
        ArrayList<Repository> result = new ArrayList<Repository>();
        Object variable = null;
        variable = context instanceof ExecutionEvent ? HandlerUtil.getCurrentSelection((ExecutionEvent)((ExecutionEvent)context)) : HandlerUtil.getVariable((Object)context, (String)"selection");
        if (variable instanceof IStructuredSelection) {
            for (Object selected : (IStructuredSelection)variable) {
                Repository repo;
                if (!(selected instanceof Repository) || !((repo = (Repository)selected).eContainer() instanceof RepositoryList) || !(repo.eContainer().eContainer() instanceof Targlet)) continue;
                result.add(repo);
            }
        }
        return result;
    }

    protected List<IAggregationElementProxy> loadContributionsAndRepositories(ResourceSet rset, URI uri) throws CoreException {
        Resource resource;
        AggregatorPackage.eINSTANCE.eClass();
        ArrayList<IAggregationElementProxy> result = new ArrayList<IAggregationElementProxy>();
        try {
            resource = rset.getResource(uri, true);
        }
        catch (Exception e) {
            try {
                TransformationManager transformationManager = new TransformationManager(uri);
                resource = transformationManager.transformResource(true);
            }
            catch (Exception e1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "Error loading b3aggr. Make sure you have the latest version of B3 installed: " + e.getLocalizedMessage(), (Throwable)e1));
            }
        }
        if (resource.getContents().size() == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "The b3aggr resource is empty"));
        }
        Aggregation aggregation = (Aggregation)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)AggregatorPackage.Literals.AGGREGATION);
        if (aggregation != null) {
            EList contributions = aggregation.getAllContributions(true);
            block8: for (Contribution next : contributions) {
                EList repositories = next.getRepositories(true);
                switch (repositories.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        result.add(new ContributionProxy(next));
                        break;
                    }
                    default: {
                        int index = 0;
                        for (MappedRepository repo : repositories) {
                            result.add(new RepositoryProxy(next, repo, index++));
                        }
                        continue block8;
                    }
                }
            }
        }
        return result;
    }

    protected void createOrUpdateAnnotations(final Map<Repository, IAggregationElementProxy> selection) {
        EObject context = EcoreUtil.getRootContainer((EObject)((EObject)selection.keySet().iterator().next()));
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)context);
        if (domain == null) {
            this.doCreateOrUpdateAnnotation(selection);
        } else {
            domain.getCommandStack().execute((Command)new ChangeCommand((Notifier)context){
                {
                    super($anonymous0);
                    this.setLabel("Set Update Annotation");
                }

                protected void doExecute() {
                    AddSetupRepositoryUpdateAnnotationHandler.this.doCreateOrUpdateAnnotation(selection);
                }
            });
        }
    }

    protected void doCreateOrUpdateAnnotation(Map<Repository, IAggregationElementProxy> selection) {
        for (Map.Entry<Repository, IAggregationElementProxy> next : selection.entrySet()) {
            Repository repo = next.getKey();
            IAggregationElementProxy aggr = next.getValue();
            Annotation annotation = repo.getAnnotation("http://www.eclipse.org/Papyrus/2014/releng/dependencytools");
            if (annotation == null) {
                annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/Papyrus/2014/releng/dependencytools");
                repo.getAnnotations().add((Object)annotation);
            }
            annotation.getDetails().put((Object)"updateFrom", (Object)aggr.getUpdateSpec());
            repo.setURL(aggr.getRepositoryURL());
        }
    }

    protected FilteredItemsSelectionDialog createSelectionDialog(Shell parentShell, Repository repo, final Collection<? extends IAggregationElementProxy> contents) {
        FilteredItemsSelectionDialog result = new FilteredItemsSelectionDialog(parentShell){

            protected IStatus validateItem(Object item) {
                return Status.OK_STATUS;
            }

            protected Comparator getItemsComparator() {
                return new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1.getClass() != o2.getClass() || o1 instanceof ContributionProxy) {
                            String label1 = ((IAggregationElementProxy)o1).getLabel();
                            String label2 = ((IAggregationElementProxy)o2).getLabel();
                            return label1.compareTo(label2);
                        }
                        RepositoryProxy repo1 = (RepositoryProxy)o1;
                        RepositoryProxy repo2 = (RepositoryProxy)o2;
                        if (repo1.getContribution() == repo2.getContribution()) {
                            return repo1.getIndex() - repo2.getIndex();
                        }
                        String label1 = repo1.getContribution().getLabel();
                        String label2 = repo2.getContribution().getLabel();
                        return label1.compareTo(label2);
                    }
                };
            }

            public String getElementName(Object item) {
                return ((IAggregationElementProxy)item).getContribution().getLabel();
            }

            protected IDialogSettings getDialogSettings() {
                return DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"AddSetupRepositoryUpdateAnnotation");
            }

            protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
                for (Object next : contents) {
                    contentProvider.add(next, itemsFilter);
                }
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }

            protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
                return new FilteredItemsSelectionDialog.ItemsFilter(this){

                    public boolean matchItem(Object item) {
                        return this.matches(((IAggregationElementProxy)item).getLabel());
                    }

                    public boolean isConsistentItem(Object item) {
                        return true;
                    }
                };
            }

            protected Control createExtendedContentArea(Composite parent) {
                return null;
            }
        };
        result.setTitle("Select Aggregation Component");
        result.setMessage(String.format("Select an aggregation component or repository for \"%s\".", repo.getURL()));
        result.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == null ? "" : ((IAggregationElementProxy)element).getLabel();
            }
        });
        result.setDetailsLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IAggregationElementProxy)element).getDetails();
            }
        });
        result.setInitialPattern("**", 2);
        return result;
    }

    protected static final class ContributionProxy
    implements IAggregationElementProxy {
        private final Contribution contribution;

        public ContributionProxy(Contribution contribution) {
            this.contribution = contribution;
        }

        @Override
        public Contribution getContribution() {
            return this.contribution;
        }

        @Override
        public String getLabel() {
            String result = this.contribution.getLabel();
            return result == null ? "" : result;
        }

        @Override
        public String getDetails() {
            if (this.contribution.getDescription() != null && this.contribution.getDescription().length() > 0) {
                return String.format("%s - %s", this.contribution.getLabel(), this.contribution.getDescription());
            }
            return this.contribution.getLabel();
        }

        @Override
        public String getUpdateSpec() {
            return this.contribution.getLabel();
        }

        @Override
        public String getRepositoryURL() {
            return ((MappedRepository)this.contribution.getRepositories(true).get(0)).getLocation();
        }
    }

    protected static interface IAggregationElementProxy {
        public Contribution getContribution();

        public String getLabel();

        public String getDetails();

        public String getUpdateSpec();

        public String getRepositoryURL();
    }

    protected static final class RepositoryProxy
    implements IAggregationElementProxy {
        private final Contribution contribution;
        private final MappedRepository repository;
        private final int index;

        public RepositoryProxy(Contribution contribution, MappedRepository repository, int index) {
            this.contribution = contribution;
            this.repository = repository;
            this.index = index;
        }

        @Override
        public Contribution getContribution() {
            return this.contribution;
        }

        public MappedRepository getRepository() {
            return this.repository;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public String getLabel() {
            return String.format("%s - %s", this.contribution.getLabel(), this.repository.getLocation());
        }

        @Override
        public String getDetails() {
            if (this.contribution.getDescription() != null && this.contribution.getDescription().length() > 0) {
                return String.format("%s (%s) - %s", this.contribution.getLabel(), this.contribution.getDescription(), this.repository.getLocation());
            }
            return this.getLabel();
        }

        @Override
        public String getUpdateSpec() {
            return String.format("%s:%s", this.contribution.getLabel(), this.index);
        }

        @Override
        public String getRepositoryURL() {
            return this.repository.getLocation();
        }
    }
}

