/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;

public interface IPluginChecker2 {
    public static final String MARKER_ATTRIBUTE_DIAGNOSTIC_SOURCE = "source";

    public void check(DiagnosticChain var1, IProgressMonitor var2);

    public static Optional<IProject> getProject(Diagnostic diagnostic) {
        return diagnostic.getData().stream().filter(IProject.class::isInstance).map(IProject.class::cast).findFirst().or(() -> IPluginChecker2.getFile(diagnostic).map(IResource::getProject));
    }

    public static Optional<IFile> getFile(Diagnostic diagnostic) {
        return diagnostic.getData().stream().filter(IFile.class::isInstance).map(IFile.class::cast).findFirst().or(() -> IPluginChecker2.getResource(diagnostic).map(ResourceUtils::getFile));
    }

    public static Optional<Resource> getResource(Diagnostic diagnostic) {
        return diagnostic.getData().stream().filter(EObject.class::isInstance).map(EObject.class::cast).map(EObject::eResource).findFirst();
    }

    public static Optional<String> getMarkerType(Diagnostic diagnostic) {
        List data = diagnostic.getData();
        if (data == null) {
            return Optional.empty();
        }
        return data.stream().filter(MarkerType.class::isInstance).map(MarkerType.class::cast).map(MarkerType::getType).findFirst();
    }

    public static void setAttributes(Diagnostic diagnostic, IMarker marker) {
        diagnostic.getData().stream().filter(MarkerAttribute.class::isInstance).map(MarkerAttribute.class::cast).forEach(attribute -> attribute.applyTo(marker));
    }

    public static MarkerType markerType(String type) {
        return new MarkerType(type);
    }

    public static MarkerAttribute lineNumber(int line) {
        return new MarkerAttribute("lineNumber", line);
    }

    public static MarkerAttribute missingDependency(String missingDependency) {
        return new MarkerAttribute("Missing Dependencies", missingDependency);
    }

    public static MarkerAttribute missingBinInclude(String missingEntry) {
        return new MarkerAttribute("binaryBuildPath", missingEntry);
    }

    public static MarkerAttribute problem(int problemID) {
        return new MarkerAttribute("problemId", problemID);
    }

    public static MarkerAttribute charStart(int index) {
        return new MarkerAttribute("charStart", index);
    }

    public static MarkerAttribute charEnd(int index) {
        return new MarkerAttribute("charEnd", index);
    }

    public static MarkerAttribute location(String location) {
        return new MarkerAttribute("location", location);
    }

    public static CollatedMessageArgument collatedMessageArgument(int index, Object value) {
        return new CollatedMessageArgument(index, value);
    }

    public static MessageArgument messageArgument(int index, Object value) {
        return new MessageArgument(index, value);
    }

    public static boolean hasDynamicMessage(Diagnostic diagnostic) {
        List data = diagnostic.getData();
        if (data != null) {
            if (data.stream().anyMatch(MessageArgument.class::isInstance)) {
                return true;
            }
        }
        return false;
    }

    public static String getDynamicMessage(Diagnostic diagnostic) {
        Object[] args = MessageArgument.stream(diagnostic).map(MessageArgument::getValueAsString).toArray();
        return NLS.bind((String)diagnostic.getMessage(), (Object[])args);
    }

    public static String getMessage(Diagnostic diagnostic) {
        return IPluginChecker2.hasDynamicMessage(diagnostic) ? IPluginChecker2.getDynamicMessage(diagnostic) : diagnostic.getMessage();
    }

    public static final class CollatedMessageArgument
    extends MessageArgument {
        public CollatedMessageArgument(int index, Object value) {
            super(index, value);
        }

        @Override
        public final boolean isCollated() {
            return true;
        }

        @Override
        public final void merge(MessageArgument argument) {
            if (argument.getIndex() != this.getIndex()) {
                throw new IllegalArgumentException("attempt to merge arguments at different positions");
            }
            if (this.getValue() == null) {
                this.setValue(this.safeCopy(argument.getValue()));
            } else if (this.getValue() instanceof Collection) {
                Collection collection = (Collection)this.getValue();
                this.merge(collection, this.safeCopy(argument.getValue()));
            } else {
                ArrayList<Object> collection = new ArrayList<Object>();
                collection.add(this.getValue());
                this.merge(collection, this.safeCopy(argument.getValue()));
                this.setValue(collection);
            }
        }

        private Object safeCopy(Object value) {
            if (value instanceof Collection) {
                return List.copyOf((Collection)value);
            }
            return value;
        }

        private void merge(Collection<Object> collection, Object value) {
            if (value != null) {
                if (value instanceof Collection) {
                    collection.addAll((Collection)value);
                } else {
                    collection.add(value);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public IPluginChecker2 createChecker(IProject var1, IFile var2, Resource var3);

        default public Factory or(Factory factory) {
            return (project, modelFile, resource) -> {
                IPluginChecker2 result = this.createChecker(project, modelFile, resource);
                if (result == null) {
                    result = factory.createChecker(project, modelFile, resource);
                }
                return result;
            };
        }

        public static Factory forProject(Function<? super IProject, ? extends IPluginChecker2> factory) {
            return (project, modelFile, resource) -> modelFile == null || resource == null ? (IPluginChecker2)factory.apply(project) : null;
        }

        public static Factory forEMFResource(Factory factory) {
            return (project, modelFile, resource) -> modelFile == null || resource == null ? null : factory.createChecker(project, modelFile, resource);
        }
    }

    public static final class MarkerAttribute {
        private final String name;
        private final Object value;

        public MarkerAttribute(String name, boolean value) {
            this.name = name;
            this.value = value;
        }

        public MarkerAttribute(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public MarkerAttribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public void applyTo(IMarker marker) {
            try {
                if (this.value instanceof Boolean) {
                    marker.setAttribute(this.name, ((Boolean)this.value).booleanValue());
                } else if (this.value instanceof Integer) {
                    marker.setAttribute(this.name, ((Integer)this.value).intValue());
                } else if (this.value != null) {
                    marker.setAttribute(this.name, (Object)String.valueOf(this.value));
                }
            }
            catch (CoreException e) {
                Activator.log.error("Could not set marker attribute.", (Throwable)e);
            }
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MarkerAttribute)) {
                return false;
            }
            MarkerAttribute other = (MarkerAttribute)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }

        public String toString() {
            return String.format("%s=%s", this.name, this.value);
        }
    }

    public static final class MarkerType {
        private final String type;

        public MarkerType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MarkerType)) {
                return false;
            }
            MarkerType other = (MarkerType)obj;
            return Objects.equals(this.type, other.type);
        }

        public String toString() {
            return String.format("@type=%s", this.type);
        }
    }

    public static class MessageArgument
    implements Comparable<MessageArgument> {
        private final int index;
        private Object value;

        public MessageArgument(int index, Object value) {
            if (this.getClass() != MessageArgument.class && this.getClass() != CollatedMessageArgument.class) {
                throw new AssertionError((Object)"Illegal subclass of MessageClass");
            }
            this.index = index;
            this.value = value;
        }

        public boolean isCollated() {
            return false;
        }

        public final int getIndex() {
            return this.index;
        }

        public final Object getValue() {
            return this.value;
        }

        final void setValue(Object value) {
            this.value = value;
        }

        public void merge(MessageArgument argument) {
        }

        public final String getValueAsString() {
            if (this.value == null) {
                return "";
            }
            if (this.value instanceof Collection) {
                return ((Collection)this.value).stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", "));
            }
            return String.valueOf(this.value);
        }

        @Override
        public final int compareTo(MessageArgument o) {
            return Integer.compare(this.getIndex(), o.getIndex());
        }

        public final int hashCode() {
            int result = Boolean.hashCode(this.isCollated());
            result += 31 * this.getIndex();
            if (!this.isCollated()) {
                result += 37 * (this.getValue() == null ? 0 : this.getValue().hashCode());
            }
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MessageArgument)) {
                return false;
            }
            MessageArgument other = (MessageArgument)obj;
            return other.isCollated() == this.isCollated() && other.getIndex() == this.getIndex() && (this.isCollated() || Objects.equals(this.getValue(), other.getValue()));
        }

        public String toString() {
            return String.format("{%d}=\"%s\"", this.index, this.value);
        }

        public static Stream<MessageArgument> stream(Diagnostic diagnostic) {
            return diagnostic.getData().stream().filter(MessageArgument.class::isInstance).map(MessageArgument.class::cast).sorted();
        }
    }
}

