/**
 * Copyright (c) 2007-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.diagram.Utils_qvto;
import xpt.providers.ElementInitializers;

@Singleton
@SuppressWarnings("all")
public class CreateLinkCommand {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private CreateLinkUtils xptCreateLinkUtils;
  
  @Inject
  private MetaModel xptMetaModel;
  
  @Inject
  private ElementInitializers xptElementInitializers;
  
  public CharSequence className(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    String _createCommandClassName = it.getCreateCommandClassName();
    _builder.append(_createCommandClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editCommandsPackageName = it.getDiagram().getEditCommandsPackageName();
    _builder.append(_editCommandsPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  private GenFeature sourceOrContainmentFeature(final TypeLinkModelFacet it) {
    GenFeature _xifexpression = null;
    GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
    boolean _tripleEquals = (_sourceMetaFeature == null);
    if (_tripleEquals) {
      _xifexpression = it.getContainmentMetaFeature();
    } else {
      _xifexpression = it.getSourceMetaFeature();
    }
    return _xifexpression;
  }
  
  public CharSequence CreateLinkCommand(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _Main = this.Main(it);
    _builder.append(_Main);
    return _builder;
  }
  
  public CharSequence Main(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _fields = this.xptCreateLinkUtils.fields(it.getModelFacet());
    _builder.append(_fields, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("(org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest request, org.eclipse.emf.ecore.EObject source, org.eclipse.emf.ecore.EObject target) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(request.getLabel(), null, request);");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _initAndDeduceContainerIfNeeded = this.xptCreateLinkUtils.initAndDeduceContainerIfNeeded(it.getModelFacet());
    _builder.append(_initAndDeduceContainerIfNeeded, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _canCreate = this.xptCreateLinkUtils.canCreate(it.getModelFacet(), it);
    _builder.append(_canCreate, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _doExecuteWithResultMethod = this.doExecuteWithResultMethod(it);
    _builder.append(_doExecuteWithResultMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _doConfigure = this.doConfigure(it.getModelFacet(), it);
    _builder.append(_doConfigure, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected void setElementToEdit(org.eclipse.emf.ecore.EObject element) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("throw new UnsupportedOperationException();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _accessors = this.xptCreateLinkUtils.accessors(it.getModelFacet());
    _builder.append(_accessors, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence doExecuteWithResultMethod(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (!canExecute()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("throw new org.eclipse.core.commands.ExecutionException(\"Invalid arguments in create link command\"); ");
    CharSequence _nonNLS = this._common.nonNLS();
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _execute = this.execute(it.getModelFacet(), it);
    _builder.append(_execute, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _execute(final LinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _execute(final TypeLinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((this.sourceOrContainmentFeature(it).getEcoreFeature().isChangeable() && it.getTargetMetaFeature().getEcoreFeature().isChangeable())) {
        CharSequence _NewInstance = this.xptMetaModel.NewInstance(it.getMetaClass(), "newElement");
        _builder.append(_NewInstance);
        _builder.newLineIfNotEmpty();
        GenFeature _containmentMetaFeature = it.getContainmentMetaFeature();
        String _xifexpression = null;
        boolean _hasContainerOtherThanSource = this._utils_qvto.hasContainerOtherThanSource(it);
        if (_hasContainerOtherThanSource) {
          _xifexpression = "getContainer()";
        } else {
          _xifexpression = "getSource()";
        }
        CharSequence _modifyFeature = this.xptMetaModel.modifyFeature(_containmentMetaFeature, _xifexpression, it.getContainmentMetaFeature().getGenClass(), 
          "newElement");
        _builder.append(_modifyFeature);
        _builder.newLineIfNotEmpty();
        {
          GenFeature _sourceMetaFeature = it.getSourceMetaFeature();
          boolean _tripleNotEquals = (_sourceMetaFeature != null);
          if (_tripleNotEquals) {
            CharSequence _modifyFeature_1 = this.xptMetaModel.modifyFeature(it.getSourceMetaFeature(), "newElement", it.getMetaClass(), "getSource()");
            _builder.append(_modifyFeature_1);
            _builder.newLineIfNotEmpty();
          }
        }
        CharSequence _modifyFeature_2 = this.xptMetaModel.modifyFeature(it.getTargetMetaFeature(), "newElement", it.getMetaClass(), "getTarget()");
        _builder.append(_modifyFeature_2);
        _builder.newLineIfNotEmpty();
        {
          boolean _hasExplicitChildFeature = this._utils_qvto.hasExplicitChildFeature(it);
          if (_hasExplicitChildFeature) {
            {
              GenFeature _sourceMetaFeature_1 = it.getSourceMetaFeature();
              boolean _tripleNotEquals_1 = (_sourceMetaFeature_1 != null);
              if (_tripleNotEquals_1) {
                CharSequence _modifyFeature_3 = this.xptMetaModel.modifyFeature(it.getChildMetaFeature(), "getContainer()", it.getContainmentMetaFeature().getGenClass(), "newElement");
                _builder.append(_modifyFeature_3);
                _builder.newLineIfNotEmpty();
              } else {
                CharSequence _modifyFeature_4 = this.xptMetaModel.modifyFeature(it.getChildMetaFeature(), "getSource()", it.getSourceType(), "newElement");
                _builder.append(_modifyFeature_4);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        CharSequence _initialize = this.initialize(it, link, "newElement");
        _builder.append(_initialize);
        _builder.newLineIfNotEmpty();
        _builder.append("doConfigure(newElement, monitor, info);");
        _builder.newLine();
        _builder.append("((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) getRequest()).setNewElement(");
        CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getMetaClass(), "newElement");
        _builder.append(_DowncastToEObject);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult(newElement);");
        _builder.newLine();
      } else {
        _builder.append("throw new UnsupportedOperationException();");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  protected CharSequence _execute(final FeatureLinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isChangeable = it.getMetaFeature().getEcoreFeature().isChangeable();
      if (_isChangeable) {
        _builder.append("if (getSource() != null && getTarget() != null) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _modifyFeature = this.xptMetaModel.modifyFeature(it.getMetaFeature(), "getSource()", it.getSourceType(), "getTarget()");
        _builder.append(_modifyFeature, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
        _builder.newLine();
      } else {
        _builder.append("throw new UnsupportedOperationException();");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public CharSequence initialize(final TypeModelFacet it, final GenLink link, final String newElementVar) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _initMethodCall = this.xptElementInitializers.initMethodCall(link, it, newElementVar);
    _builder.append(_initMethodCall);
    return _builder;
  }
  
  protected CharSequence _doConfigure(final LinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  /**
   * TODO invocation of configure command should be optional, and better yet,
   * configuration should rather happen from EditPolicy then from within creation command
   */
  protected CharSequence _doConfigure(final TypeLinkModelFacet it, final GenLink link) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void doConfigure(");
    CharSequence _QualifiedClassName = this.xptMetaModel.QualifiedClassName(it.getMetaClass());
    _builder.append(_QualifiedClassName);
    _builder.append(" newElement, org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType elementType = ((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) getRequest()).getElementType();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest configureRequest = new org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest(getEditingDomain(), ");
    CharSequence _DowncastToEObject = this.xptMetaModel.DowncastToEObject(it.getMetaClass(), "newElement");
    _builder.append(_DowncastToEObject, "\t");
    _builder.append(", elementType);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("configureRequest.setClientContext(((org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest) getRequest()).getClientContext());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("configureRequest.addParameters(getRequest().getParameters());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("configureRequest.setParameter(org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest.SOURCE, getSource());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("configureRequest.setParameter(org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest.TARGET, getTarget());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.common.core.command.ICommand configureCommand = elementType.getEditCommand(configureRequest);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (configureCommand != null && configureCommand.canExecute()) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("configureCommand.execute(monitor, info);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence execute(final LinkModelFacet it, final GenLink link) {
    if (it instanceof FeatureLinkModelFacet) {
      return _execute((FeatureLinkModelFacet)it, link);
    } else if (it instanceof TypeLinkModelFacet) {
      return _execute((TypeLinkModelFacet)it, link);
    } else if (it != null) {
      return _execute(it, link);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, link).toString());
    }
  }
  
  public CharSequence doConfigure(final LinkModelFacet it, final GenLink link) {
    if (it instanceof TypeLinkModelFacet) {
      return _doConfigure((TypeLinkModelFacet)it, link);
    } else if (it != null) {
      return _doConfigure(it, link);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, link).toString());
    }
  }
}
