/**
 * Copyright (c) 2007, 2009, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Artem Tikhomirov (Borland) - [257119] Create views directly, not through ViewFactories
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package xpt.diagram.views;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Behaviour;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ColorAttributes;
import org.eclipse.papyrus.gmf.codegen.gmfgen.DesignLabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.OpenDiagramBehaviour;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common;
import xpt.diagram.Utils_qvto;
import xpt.diagram.ViewmapAttributesUtils_qvto;

/**
 * Renamed from xpt::diagram::views::Utils.xpt
 * in order to have consistent naming between Xtend files migrated from _qvto helpers and xpt templates
 */
@Singleton
@SuppressWarnings("all")
public class ViewStyles {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private ViewmapAttributesUtils_qvto _viewmapAttributesUtils_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private MetaModel xptMetaModel;
  
  /**
   * @deprecated FIXME: ColorAttributes class is deprecated
   */
  protected CharSequence _foregroundColour(final Viewmap it, final String viewVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<ColorAttributes> _filter = Iterables.<ColorAttributes>filter(it.getAttributes(), ColorAttributes.class);
      for(final ColorAttributes attr : _filter) {
        CharSequence _foregroundColour = this.foregroundColour(attr, viewVar);
        _builder.append(_foregroundColour);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _foregroundColour(final ColorAttributes it, final String viewVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.setStructuralFeatureValue(");
    _builder.append(viewVar);
    _builder.append(", org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getLineStyle_LineColor(), org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities.colorToInteger(org.eclipse.draw2d.ColorConstants.");
    String _foregroundColor = it.getForegroundColor();
    _builder.append(_foregroundColor);
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * @deprecated FIXME: ColorAttributes class is deprecated
   */
  protected CharSequence _backgroundColour(final Viewmap it, final String viewVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<ColorAttributes> _filter = Iterables.<ColorAttributes>filter(it.getAttributes(), ColorAttributes.class);
      for(final ColorAttributes attr : _filter) {
        CharSequence _backgroundColour = this.backgroundColour(attr, viewVar);
        _builder.append(_backgroundColour);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _backgroundColour(final ColorAttributes it, final String viewVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.diagram.core.util.ViewUtil.setStructuralFeatureValue(");
    _builder.append(viewVar);
    _builder.append(", org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getFillStyle_FillColor(), org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities.colorToInteger(org.eclipse.draw2d.ColorConstants.");
    String _backgroundColor = it.getBackgroundColor();
    _builder.append(_backgroundColor);
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence addFontLineFillStylesConditionally(final Viewmap it, final String stylesVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isFixedFont = this._viewmapAttributesUtils_qvto.isFixedFont(it);
      boolean _not = (!_isFixedFont);
      if (_not) {
        _builder.append(stylesVar);
        _builder.append(".add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createFontStyle());");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      boolean _isFixedForeground = this._viewmapAttributesUtils_qvto.isFixedForeground(it);
      boolean _not_1 = (!_isFixedForeground);
      if (_not_1) {
        _builder.append(stylesVar);
        _builder.append(".add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createLineStyle());");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      boolean _isFixedBackground = this._viewmapAttributesUtils_qvto.isFixedBackground(it);
      boolean _not_2 = (!_isFixedBackground);
      if (_not_2) {
        _builder.append(stylesVar);
        _builder.append(".add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createFillStyle());");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _addTextStyle(final LabelModelFacet it, final String stylesVar) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _addTextStyle(final DesignLabelModelFacet it, final String stylesVar) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(stylesVar);
    _builder.append(".add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createDescriptionStyle());");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _addLinkedDiagramStyle(final GenCommonBase it, final String stylesVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Behaviour> _behaviour = it.getBehaviour();
      for(final Behaviour b : _behaviour) {
        CharSequence _addLinkedDiagramStyle = this.addLinkedDiagramStyle(b, stylesVar);
        _builder.append(_addLinkedDiagramStyle);
      }
    }
    return _builder;
  }
  
  protected CharSequence _addLinkedDiagramStyle(final Behaviour it, final String stylesVar) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _addLinkedDiagramStyle(final OpenDiagramBehaviour it, final String stylesVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _diagramKind = it.getDiagramKind();
      boolean _tripleNotEquals = (_diagramKind != null);
      if (_tripleNotEquals) {
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle diagramFacet = org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createHintedDiagramLinkStyle();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("diagramFacet.setHint(\"");
        String _diagramKind_1 = it.getDiagramKind();
        _builder.append(_diagramKind_1, "\t");
        _builder.append("\"); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(stylesVar, "\t");
        _builder.append(".add(diagramFacet);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      } else {
        _builder.append(stylesVar);
        _builder.append(".add(org.eclipse.gmf.runtime.notation.NotationFactory.eINSTANCE.createHintedDiagramLinkStyle());");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence addCustomStyles(final GenCommonBase it, final String stylesVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenClass> _styles = it.getStyles();
      for(final GenClass style : _styles) {
        _builder.append(stylesVar);
        _builder.append(".add(");
        CharSequence _NewInstance = this.xptMetaModel.NewInstance(style);
        _builder.append(_NewInstance);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _offset(final GenLabel it, final String viewVar) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _offset(final GenLinkLabel it, final String viewVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((this._viewmapAttributesUtils_qvto.labelOffsetX(it.getViewmap(), 0) != 0) || (this._viewmapAttributesUtils_qvto.labelOffsetY(it.getViewmap(), 0) != 0))) {
        CharSequence _offset = this.offset(it, viewVar, this._viewmapAttributesUtils_qvto.labelOffsetX(it.getViewmap(), 0), this._viewmapAttributesUtils_qvto.labelOffsetY(it.getViewmap(), 0));
        _builder.append(_offset);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _offset(final GenExternalNodeLabel it, final String viewVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((this._viewmapAttributesUtils_qvto.labelOffsetX(it.getViewmap(), 0) != 0) || (this._viewmapAttributesUtils_qvto.labelOffsetY(it.getViewmap(), 0) != 0))) {
        CharSequence _offset = this.offset(it, viewVar, this._viewmapAttributesUtils_qvto.labelOffsetX(it.getViewmap(), 0), this._viewmapAttributesUtils_qvto.labelOffsetY(it.getViewmap(), 0));
        _builder.append(_offset);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _offset_1 = this.offset(it, viewVar, 0, 15);
        _builder.append(_offset_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  /**
   * viewVar must be already inserted into a diagram (view.getDiagram() should be meaningful)
   */
  public CharSequence offset(final GenLabel it, final String viewVar, final int x, final int y) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstLower = StringExtensions.toFirstLower(this._common.stringUniqueIdentifier(it));
    final String location = (_firstLower + "_Location");
    _builder.newLineIfNotEmpty();
    _builder.append("org.eclipse.gmf.runtime.notation.Location ");
    _builder.append(location);
    _builder.append(" = (org.eclipse.gmf.runtime.notation.Location) ");
    _builder.append(viewVar);
    _builder.append(".getLayoutConstraint();");
    _builder.newLineIfNotEmpty();
    {
      boolean _isPixelMapMode = this._utils_qvto.isPixelMapMode(it.getDiagram());
      if (_isPixelMapMode) {
        _builder.append(location);
        _builder.append(".setX(");
        _builder.append(x);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append(location);
        _builder.append(".setY(");
        _builder.append(y);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append(location);
        _builder.append(".setX(org.eclipse.gmf.runtime.diagram.ui.util.MeasurementUnitHelper.getMapMode(");
        _builder.append(viewVar);
        _builder.append(".getDiagram().getMeasurementUnit()).DPtoLP(");
        _builder.append(x);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append(location);
        _builder.append(".setY(org.eclipse.gmf.runtime.diagram.ui.util.MeasurementUnitHelper.getMapMode(");
        _builder.append(viewVar);
        _builder.append(".getDiagram().getMeasurementUnit()).DPtoLP(");
        _builder.append(y);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence foregroundColour(final EObject it, final String viewVar) {
    if (it instanceof ColorAttributes) {
      return _foregroundColour((ColorAttributes)it, viewVar);
    } else if (it instanceof Viewmap) {
      return _foregroundColour((Viewmap)it, viewVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, viewVar).toString());
    }
  }
  
  public CharSequence backgroundColour(final EObject it, final String viewVar) {
    if (it instanceof ColorAttributes) {
      return _backgroundColour((ColorAttributes)it, viewVar);
    } else if (it instanceof Viewmap) {
      return _backgroundColour((Viewmap)it, viewVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, viewVar).toString());
    }
  }
  
  public CharSequence addTextStyle(final LabelModelFacet it, final String stylesVar) {
    if (it instanceof DesignLabelModelFacet) {
      return _addTextStyle((DesignLabelModelFacet)it, stylesVar);
    } else if (it != null) {
      return _addTextStyle(it, stylesVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, stylesVar).toString());
    }
  }
  
  public CharSequence addLinkedDiagramStyle(final EObject it, final String stylesVar) {
    if (it instanceof OpenDiagramBehaviour) {
      return _addLinkedDiagramStyle((OpenDiagramBehaviour)it, stylesVar);
    } else if (it instanceof Behaviour) {
      return _addLinkedDiagramStyle((Behaviour)it, stylesVar);
    } else if (it instanceof GenCommonBase) {
      return _addLinkedDiagramStyle((GenCommonBase)it, stylesVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, stylesVar).toString());
    }
  }
  
  public CharSequence offset(final GenLabel it, final String viewVar) {
    if (it instanceof GenExternalNodeLabel) {
      return _offset((GenExternalNodeLabel)it, viewVar);
    } else if (it instanceof GenLinkLabel) {
      return _offset((GenLinkLabel)it, viewVar);
    } else if (it != null) {
      return _offset(it, viewVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, viewVar).toString());
    }
  }
}
