/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.ContextElement;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.FieldSelection;
import org.eclipse.papyrus.customization.properties.generation.fieldselection.PropertyDefinition;
import org.eclipse.papyrus.customization.properties.generation.generators.GeneratorHelper;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.layout.ILayoutGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.CreateContextMainPage;
import org.eclipse.papyrus.customization.properties.generation.wizard.GeneratorPage;
import org.eclipse.papyrus.customization.properties.generation.wizard.SelectFieldsPage;
import org.eclipse.papyrus.customization.properties.generation.wizard.SelectOutputPage;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.TernaryButton;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.ContextsFactory;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class CreateContextWizard
extends Wizard
implements INewWizard {
    protected CreateContextMainPage mainPage;
    protected GeneratorPage generatorPage;
    protected SelectOutputPage selectOutputPage;
    protected SelectFieldsPage selectFieldsPage;
    protected List<Context> contexts;
    protected IGenerator generator;
    protected ILayoutGenerator layoutGenerator;
    private IWorkbenchPage workbenchPage;
    private Optional<IFile> currentlySelectedFile;

    public CreateContextWizard() {
        this.setDefaultPageImageDescriptor(Activator.getDefault().getImageDescriptor("/icons/wizban-custom.png"));
    }

    public boolean performFinish() {
        URI uriToOpen;
        boolean result = false;
        if (this.generator == null || this.contexts == null || this.contexts.isEmpty() || this.layoutGenerator == null) {
            return result;
        }
        for (Context context : this.contexts) {
            Tab defaultTab = ContextsFactory.eINSTANCE.createTab();
            defaultTab.setId(context.getName().toLowerCase());
            defaultTab.setLabel(context.getUserLabel());
            defaultTab.setPriority(100);
            context.getTabs().add((Object)defaultTab);
            FieldSelection fieldSelection = this.selectFieldsPage.getFieldSelection();
            GeneratorHelper helper = new GeneratorHelper(this.generator, this.layoutGenerator);
            BiPredicate<Property, Integer> propertySelectionPredicate = (property, multiplicity) -> this.isSelected(fieldSelection, (Property)property, multiplicity != 1);
            for (View view : context.getViews()) {
                if (view.getConstraints().size() == 0) continue;
                helper.generateLayout(context, defaultTab, view, propertySelectionPredicate);
            }
            int i = 1;
            for (Tab tab : context.getTabs()) {
                i += tab.getSections().size();
            }
            final int numberOfSections = i;
            try {
                this.setNeedsProgressMonitor(true);
                final Context currentContext = context;
                final HashMap<String, String> saveOptions = new HashMap<String, String>();
                saveOptions.put("PROCESS_DANGLING_HREF", "RECORD");
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(String.valueOf(Messages.CreateContextWizard_propertyViewGenerationJobName) + currentContext.getUserLabel(), numberOfSections + 1);
                        monitor.worked(1);
                        try {
                            currentContext.eResource().save(saveOptions);
                            monitor.worked(1);
                            for (Tab tab : currentContext.getTabs()) {
                                for (Section section : tab.getSections()) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    section.getWidget().eResource().save(saveOptions);
                                    monitor.worked(1);
                                }
                            }
                        }
                        catch (IOException ex) {
                            Activator.log.error((Throwable)ex);
                            return;
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException ex) {
                Activator.log.error((Throwable)ex);
            }
            catch (InterruptedException ex) {
                Activator.log.error((Throwable)ex);
            }
            result = true;
        }
        if (result && (uriToOpen = this.contexts.get(0).eResource().getURI()).isPlatformResource()) {
            IFile file = ResourceUtils.getFile((Resource)this.contexts.get(0).eResource());
            try {
                IDE.openEditor((IWorkbenchPage)this.workbenchPage, (IFile)file);
            }
            catch (PartInitException e) {
                Policy.getStatusHandler().show(e.getStatus(), this.getWindowTitle());
            }
        }
        return result;
    }

    private boolean isSelected(FieldSelection fieldSelection, Property property, boolean multiple) {
        PropertyDefinition definition = this.getPropertyDefinition(fieldSelection, property);
        if (definition == null) {
            return false;
        }
        TernaryButton.State value = multiple ? definition.getValueMultiple() : definition.getValueSingle();
        switch (value) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case DEFAULT: {
                return multiple ? this.generator.isSelectedMultiple(property) : this.generator.isSelectedSingle(property);
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected PropertyDefinition getPropertyDefinition(FieldSelection fieldSelection, Property property) {
        propertyPath = this.getPropertyPath(property.getContextElement());
        if (propertyPath.isEmpty()) {
            return null;
        }
        currentElement = null;
        for (ContextElement contextRoot : fieldSelection.getContextElements()) {
            if (!contextRoot.getName().equals(propertyPath.get(0))) continue;
            currentElement = contextRoot;
        }
        propertyPath.remove(0);
        if (currentElement != null) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            name = propertyPath.get(0);
            propertyPath.remove(0);
            currentElement = this.findByName(currentElement, name);
lbl17:
            // 2 sources

            ** while (propertyPath.size() > 0)
        }
lbl18:
        // 1 sources

        if (currentElement == null) {
            return null;
        }
        for (PropertyDefinition definition : currentElement.getProperties()) {
            if (!definition.getName().equals(property.getName())) continue;
            return definition;
        }
        return null;
    }

    protected ContextElement findByName(ContextElement source, String name) {
        for (ContextElement element : source.getElements()) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    protected List<String> getPropertyPath(DataContextElement element) {
        List<Object> result = element.getPackage() == null ? new LinkedList() : this.getPropertyPath((DataContextElement)element.getPackage());
        result.add(element.getName());
        return result;
    }

    private Set<DataContextElement> getAllContextElements(Collection<DataContextElement> source) {
        HashSet<DataContextElement> result = new HashSet<DataContextElement>();
        for (DataContextElement element : source) {
            this.getAllContextElements(element, result);
        }
        return result;
    }

    private void getAllContextElements(DataContextElement source, Set<DataContextElement> result) {
        if (result.contains(source)) {
            return;
        }
        result.add(source);
        for (DataContextElement element : source.getSupertypes()) {
            this.getAllContextElements(element, result);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mainPage = new CreateContextMainPage();
        this.addPage((IWizardPage)this.mainPage);
        this.generatorPage = new GeneratorPage();
        this.addPage((IWizardPage)this.generatorPage);
        this.selectOutputPage = new SelectOutputPage();
        this.addPage((IWizardPage)this.selectOutputPage);
        this.selectFieldsPage = new SelectFieldsPage();
        this.addPage((IWizardPage)this.selectFieldsPage);
        this.setWindowTitle(Messages.CreateContextWizard_pageTitle);
        this.workbenchPage = EditorHelper.getInstance((IWorkbench)workbench).getActivePage();
        this.currentlySelectedFile = StreamSupport.stream(selection.spliterator(), false).filter(IFile.class::isInstance).map(IFile.class::cast).findFirst();
    }

    Optional<IFile> getCurrentlySelectedFile() {
        return this.currentlySelectedFile;
    }

    protected void setGenerator(IGenerator generator) {
        if (!Objects.equals(this.generator, generator)) {
            this.generator = generator;
            this.generatorPage.setGenerator(generator);
            this.generatorPage.doBinding();
        }
    }

    protected void setContexts(List<Context> contexts) {
        if (!contexts.isEmpty()) {
            this.contexts = contexts;
        }
    }
}

