/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.filter.configuration;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxCellEditor;
import org.eclipse.papyrus.infra.emf.nattable.filter.configuration.EnumeratorMatcherEditor;
import org.eclipse.papyrus.infra.nattable.converter.GenericDisplayConverter;
import org.eclipse.papyrus.infra.nattable.dataprovider.ListComboBoxDataProvider;
import org.eclipse.papyrus.infra.nattable.filter.IFilterValueToMatchManager;
import org.eclipse.papyrus.infra.nattable.filter.IPapyrusMatcherEditorFactory;
import org.eclipse.papyrus.infra.nattable.filter.configuration.AbstractFilterValueToMatchManager;
import org.eclipse.papyrus.infra.nattable.filter.configuration.IFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.filter.validator.EnumFilterDataValidator;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NamedStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringValueStyle;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;

public class EEnumFilterCellEditorFilterConfiguration
implements IFilterConfiguration {
    private static final String ID = "org.eclipse.papyrus.infra.emf.nattable.eenum.checkboxcombo.with.NA";

    public boolean handles(IConfigRegistry registry, Object columnElement) {
        Object representedElement = AxisUtils.getRepresentedElement((Object)columnElement);
        if (representedElement instanceof EStructuralFeature) {
            EClassifier eType = ((EStructuralFeature)representedElement).getEType();
            return eType instanceof EEnum;
        }
        return false;
    }

    protected List<Enumerator> getLiteral(IConfigRegistry configRegistry, Object axis) {
        Object representedElement = AxisUtils.getRepresentedElement((Object)axis);
        ArrayList<Enumerator> literals = new ArrayList<Enumerator>();
        if (representedElement instanceof EStructuralFeature) {
            EClassifier eType = ((EStructuralFeature)representedElement).getEType();
            Assert.isTrue((boolean)(eType instanceof EEnum));
            EEnum eenum = (EEnum)eType;
            for (EEnumLiteral current : eenum.getELiterals()) {
                literals.add(current.getInstance());
            }
        }
        return literals;
    }

    public void configureFilter(IConfigRegistry configRegistry, Object columnElement, String configLabel) {
        List<Enumerator> literals = this.getLiteral(configRegistry, columnElement);
        ArrayList<Enumerator> valuesToProposed = new ArrayList<Enumerator>(literals);
        valuesToProposed.add(0, (Enumerator)CellHelper.getUnsupportedCellContentsText());
        FilterRowComboBoxCellEditor editor = new FilterRowComboBoxCellEditor((IComboBoxDataProvider)new ListComboBoxDataProvider(valuesToProposed));
        IPapyrusMatcherEditorFactory<Object> factory = this.createPapyrusMatcherFactory();
        configRegistry.registerConfigAttribute(NattableConfigAttributes.MATCHER_EDITOR_FACTORY, factory, "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)editor, "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(NattableConfigAttributes.FILTER_VALUE_TO_MATCH_MANAGER, (Object)this.createFilterValueToMatchManager(this.getConfigurationId(), literals), "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new GenericDisplayConverter(), "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)this.getDataValidator(configRegistry, literals), "NORMAL", configLabel);
    }

    protected IPapyrusMatcherEditorFactory<Object> createPapyrusMatcherFactory() {
        return new IPapyrusMatcherEditorFactory<Object>(){

            public EventList<MatcherEditor<Object>> instantiateMatcherEditors(IColumnAccessor<Object> columnAccessor, Integer columnIndex, Object wantedValue, IConfigRegistry configRegistry) {
                BasicEventList list = new BasicEventList();
                list.add((Object)new EnumeratorMatcherEditor(columnAccessor, columnIndex, wantedValue, configRegistry));
                return list;
            }
        };
    }

    protected IFilterValueToMatchManager createFilterValueToMatchManager(String filterConfiguration, List<Enumerator> literals) {
        return new EnumeratorFilterValueToMatchManager(filterConfiguration, literals);
    }

    protected IDataValidator getDataValidator(IConfigRegistry configRegistry, List<Enumerator> literals) {
        return new EnumFilterDataValidator(literals);
    }

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a combo with checkbox to filter EEnum, with N/A value";
    }

    public static class EnumeratorFilterValueToMatchManager
    extends AbstractFilterValueToMatchManager {
        protected final List<Enumerator> literals;

        public EnumeratorFilterValueToMatchManager(String filterConfigurationId, List<Enumerator> literals) {
            super(filterConfigurationId);
            this.literals = literals;
        }

        public Object getValueToMatch(IConfigRegistry configRegistry, Object axis) {
            if (!(axis instanceof IAxis)) {
                return null;
            }
            IAxis iaxis = (IAxis)axis;
            NamedStyle style = this.getValueToMatchStyle(iaxis);
            if (style != null) {
                String unsupportedColumnCellText = CellHelper.getUnsupportedCellContentsText();
                if (style instanceof StringListValueStyle) {
                    ArrayList<String> returnedValues = new ArrayList<String>();
                    EList coll = ((StringListValueStyle)style).getStringListValue();
                    for (String string : coll) {
                        if (string.equals(unsupportedColumnCellText)) {
                            returnedValues.add(unsupportedColumnCellText);
                            continue;
                        }
                        for (Enumerator tmp : this.literals) {
                            if (!tmp.getName().equals(string)) continue;
                            returnedValues.add((String)tmp);
                        }
                    }
                    return returnedValues;
                }
                if (style instanceof StringValueStyle) {
                    String val = ((StringValueStyle)style).getStringValue();
                    if (val.equals(unsupportedColumnCellText)) {
                        return unsupportedColumnCellText;
                    }
                    for (Enumerator tmp : this.literals) {
                        if (!tmp.getName().equals(val)) continue;
                        return tmp;
                    }
                }
            }
            return null;
        }

        protected Command getSaveValueToMatchCommand(TransactionalEditingDomain domain, IConfigRegistry configRegistry, Object axis, Object newValue) {
            if (!(axis instanceof IAxis)) {
                return null;
            }
            IAxis iaxis = (IAxis)axis;
            CompoundCommand cc = new CompoundCommand("Save Value To Match Command");
            NamedStyle keyStyle = this.getValueToMatchStyle(iaxis);
            String unsupportedColumnCellText = CellHelper.getUnsupportedCellContentsText();
            if (newValue instanceof Collection) {
                Command cmd;
                Collection coll = (Collection)newValue;
                if (keyStyle != null && !(keyStyle instanceof StringListValueStyle) && (cmd = this.getDestroyFilterValueToMatchCommand(domain, configRegistry, axis)) != null && cmd.canExecute()) {
                    cc.append(cmd);
                }
                if (keyStyle == null) {
                    keyStyle = NattablestyleFactory.eINSTANCE.createStringListValueStyle();
                    keyStyle.setName("filterValueToMatch");
                    cc.append(AddCommand.create((EditingDomain)domain, (Object)iaxis, (Object)NattablestylePackage.eINSTANCE.getNamedStyle(), (Object)keyStyle));
                }
                ArrayList<String> values = new ArrayList<String>();
                for (Object tmp : coll) {
                    Assert.isTrue((tmp instanceof Enumerator || unsupportedColumnCellText.equals(tmp) ? 1 : 0) != 0);
                    if (tmp instanceof Enumerator) {
                        values.add(((Enumerator)tmp).getName());
                        continue;
                    }
                    values.add(unsupportedColumnCellText);
                }
                cc.append(SetCommand.create((EditingDomain)domain, (Object)keyStyle, (Object)NattablestylePackage.eINSTANCE.getStringListValueStyle_StringListValue(), values));
            } else {
                Command cmd;
                if (keyStyle != null && !(keyStyle instanceof StringValueStyle) && (cmd = this.getDestroyFilterValueToMatchCommand(domain, configRegistry, axis)) != null && cmd.canExecute()) {
                    cc.append(cmd);
                }
                if (keyStyle == null) {
                    keyStyle = NattablestyleFactory.eINSTANCE.createEObjectValueStyle();
                    keyStyle.setName("filterValueToMatch");
                    cc.append(AddCommand.create((EditingDomain)domain, (Object)iaxis, (Object)NattablestylePackage.eINSTANCE.getNamedStyle(), (Object)keyStyle));
                }
                Assert.isTrue((newValue instanceof Enumerator || unsupportedColumnCellText.equals(newValue) ? 1 : 0) != 0);
                String name = newValue instanceof Enumerator ? ((Enumerator)newValue).getName() : unsupportedColumnCellText;
                cc.append(SetCommand.create((EditingDomain)domain, (Object)keyStyle, (Object)NattablestylePackage.eINSTANCE.getStringValueStyle_StringValue(), (Object)name));
            }
            return cc;
        }
    }
}

