/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.dialog;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerValueProperty;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.AccessibleTypeCatalog;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.ITypeCatalog;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.MemberKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.PropertyModel;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StateKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.providers.TypeLabelProvider;
import org.eclipse.papyrus.uml.profile.drafter.utils.UMLPrimitiveTypesModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class PropertiesEditorWidget {
    private DataBindingContext m_bindingContext;
    private Composite contentArea;
    private WritableList properties;
    private NamedElement selectedElement;
    private TableViewer treeViewer;
    private TableViewerColumn nameViewerColumn;
    private TableViewerColumn typeViewerColumn;
    private TableViewerColumn statusViewerColumn;
    private TableViewerColumn valueViewerColumn;
    private TableViewerColumn memberViewerColumn;
    private TableViewerColumn deletedViewerColumn;
    private ILabelProvider typeLabelProvider;
    private ITypeCatalog typeCatalog;
    private UMLPrimitiveTypesModel umlPrimitiveTypesLibrary;

    public PropertiesEditorWidget(Composite parent, List<PropertyModel> properties, NamedElement selectedElement) {
        this.properties = properties instanceof WritableList ? (WritableList)properties : new WritableList(properties, PropertyModel.class);
        this.selectedElement = selectedElement;
        this.createContent(parent);
    }

    public void setProperties(List<PropertyModel> properties) {
        this.properties = properties instanceof WritableList ? (WritableList)properties : new WritableList(properties, PropertyModel.class);
    }

    protected void createContent(Composite parent) {
        this.contentArea = this.createContentArea(parent);
    }

    protected Composite createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite tableTitle = new Composite(composite, 0);
        tableTitle.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        tableTitle.setLayout((Layout)new FillLayout(256));
        Label label = new Label(tableTitle, 0);
        label.setText("Properties");
        Button addPropertyButton = new Button(tableTitle, 0);
        addPropertyButton.setText("+");
        addPropertyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditorWidget.this.addPropertyPressed(e);
            }
        });
        Button removePropertyButton = new Button(tableTitle, 0);
        removePropertyButton.setText("-");
        removePropertyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditorWidget.this.removePropertyPressed(e);
            }
        });
        this.treeViewer = new TableViewer(composite, 67584);
        Table tree = this.treeViewer.getTable();
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.minimumHeight = 100;
        tree.setLayoutData((Object)gd_tree);
        this.nameViewerColumn = new TableViewerColumn(this.treeViewer, 0);
        TableColumn NameTableColumn = this.nameViewerColumn.getColumn();
        NameTableColumn.setWidth(100);
        NameTableColumn.setText("name");
        this.typeViewerColumn = new TableViewerColumn(this.treeViewer, 0);
        TableColumn typeTableColumn = this.typeViewerColumn.getColumn();
        typeTableColumn.setWidth(100);
        typeTableColumn.setText("type");
        this.statusViewerColumn = new TableViewerColumn(this.treeViewer, 0);
        TableColumn statusTableColumn = this.statusViewerColumn.getColumn();
        statusTableColumn.setWidth(67);
        statusTableColumn.setText("status");
        this.memberViewerColumn = new TableViewerColumn(this.treeViewer, 0);
        TableColumn memberTableColumn = this.memberViewerColumn.getColumn();
        memberTableColumn.setWidth(64);
        memberTableColumn.setText("member");
        this.deletedViewerColumn = new TableViewerColumn(this.treeViewer, 0);
        TableColumn deletedTableColumn = this.deletedViewerColumn.getColumn();
        deletedTableColumn.setWidth(37);
        deletedTableColumn.setText("deleted");
        this.valueViewerColumn = new TableViewerColumn(this.treeViewer, 0);
        TableColumn valueTableColumn = this.valueViewerColumn.getColumn();
        valueTableColumn.setWidth(100);
        valueTableColumn.setText("value");
        tree.setHeaderVisible(true);
        this.m_bindingContext = this.initDataBindings();
        return composite;
    }

    private void addPropertyPressed(SelectionEvent e) {
        PropertyModel model;
        try {
            model = new PropertyModel(MemberKind.owned, "newProperty", this.getUMLPrimitiveTypeLibrary().getDefaultType());
        }
        catch (NullPointerException e1) {
            model = new PropertyModel(MemberKind.owned, "newProperty");
        }
        this.properties.add((Object)model);
    }

    private void removePropertyPressed(SelectionEvent e) {
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            this.removeProperty((PropertyModel)structSelection.getFirstElement());
        }
    }

    private void removeProperty(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return;
        }
        if (propertyModel.getStateKind() == StateKind.created) {
            this.properties.remove((Object)propertyModel);
        } else if (propertyModel.getMemberKind() == MemberKind.owned) {
            propertyModel.deleteModelEvent();
        }
    }

    private void createDialogContents() {
    }

    private void fillContentArea() {
    }

    protected static EditingSupport create(ColumnViewer viewer, DataBindingContext dbc, final CellEditor cellEditor, final IValueProperty cellEditorProperty, final IValueProperty elementProperty) {
        return new ObservableValueEditingSupport(viewer, dbc){

            protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor2) {
                if (cellEditor2 instanceof ComboBoxViewerCellEditor) {
                    return cellEditorProperty.observe((Object)((ComboBoxViewerCellEditor)cellEditor2).getViewer());
                }
                return cellEditorProperty.observe((Object)cellEditor2.getControl());
            }

            protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
                return elementProperty.observe(element);
            }

            protected CellEditor getCellEditor(Object element) {
                return cellEditor;
            }
        };
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        String[] propertyNames = new String[]{"proposedName", "type", "stateKind", "memberKind", "lifeStatusKind", "value"};
        IObservableMap[] observeMaps = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            observeMaps[i] = BeanProperties.value(PropertyModel.class, (String)propertyNames[i]).observeDetail(listContentProvider.getKnownElements());
            ++i;
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps){

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex < this.attributeMaps.length) {
                    Object result = this.attributeMaps[columnIndex].get(element);
                    if (result instanceof Type) {
                        return PropertiesEditorWidget.this.getTypeLabelProvider().getText(result);
                    }
                    return result == null ? "" : result.toString();
                }
                return null;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)listContentProvider);
        this.treeViewer.setInput((Object)this.properties);
        TextCellEditor cellEditor_0 = new TextCellEditor((Composite)this.treeViewer.getTable());
        IWidgetValueProperty cellEditorProperty_0 = WidgetProperties.text((int)24);
        IBeanValueProperty valueProperty_0 = BeanProperties.value((String)"proposedName");
        this.nameViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)cellEditor_0, (IValueProperty)cellEditorProperty_0, (IValueProperty)valueProperty_0));
        ComboBoxViewerCellEditor typeCellEditor = new ComboBoxViewerCellEditor((Composite)this.treeViewer.getTable());
        typeCellEditor.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        typeCellEditor.setLabelProvider((IBaseLabelProvider)this.getTypeLabelProvider());
        typeCellEditor.setInput(this.getTypeCatalog().getTypes());
        IViewerValueProperty typeCellEditorBindAnchor = ViewerProperties.singleSelection();
        WidgetProperties.text((int)24);
        IBeanValueProperty typeModelPropertyBindAnchor = BeanProperties.value((String)"type");
        this.typeViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)typeCellEditor, (IValueProperty)typeCellEditorBindAnchor, (IValueProperty)typeModelPropertyBindAnchor));
        TextCellEditor cellEditor_2 = new TextCellEditor((Composite)this.treeViewer.getTable());
        IWidgetValueProperty cellEditorProperty_1 = WidgetProperties.text((int)24);
        IBeanValueProperty valueProperty_2 = BeanProperties.value((String)"stateKind");
        this.statusViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)cellEditor_2, (IValueProperty)cellEditorProperty_1, (IValueProperty)valueProperty_2));
        TextCellEditor cellEditor_3 = new TextCellEditor((Composite)this.treeViewer.getTable());
        IWidgetValueProperty cellEditorProperty_2 = WidgetProperties.text((int)24);
        IBeanValueProperty valueProperty_3 = BeanProperties.value((String)"value");
        this.valueViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)cellEditor_3, (IValueProperty)cellEditorProperty_2, (IValueProperty)valueProperty_3));
        TextCellEditor cellEditor_member = new TextCellEditor((Composite)this.treeViewer.getTable());
        IWidgetValueProperty cellEditorPropertyMember = WidgetProperties.text((int)24);
        IBeanValueProperty valuePropertyMember = BeanProperties.value((String)"memberKind");
        this.memberViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)cellEditor_member, (IValueProperty)cellEditorPropertyMember, (IValueProperty)valuePropertyMember));
        TextCellEditor cellEditor_del = new TextCellEditor((Composite)this.treeViewer.getTable());
        IWidgetValueProperty cellEditorPropertyDel = WidgetProperties.text((int)24);
        IBeanValueProperty valuePropertyDel = BeanProperties.value((String)"lifeStatusKind");
        this.memberViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)cellEditor_del, (IValueProperty)cellEditorPropertyDel, (IValueProperty)valuePropertyDel));
        return bindingContext;
    }

    private ILabelProvider getTypeLabelProvider() {
        if (this.typeLabelProvider == null) {
            this.typeLabelProvider = new TypeLabelProvider();
        }
        return this.typeLabelProvider;
    }

    private ITypeCatalog getTypeCatalog() {
        if (this.typeCatalog == null) {
            this.typeCatalog = new AccessibleTypeCatalog((Element)this.selectedElement, this.getUMLPrimitiveTypeLibrary());
        }
        return this.typeCatalog;
    }

    private UMLPrimitiveTypesModel getUMLPrimitiveTypeLibrary() {
        if (this.umlPrimitiveTypesLibrary == null) {
            try {
                this.umlPrimitiveTypesLibrary = new UMLPrimitiveTypesModel(this.selectedElement.eResource().getResourceSet());
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
        }
        return this.umlPrimitiveTypesLibrary;
    }

    protected DataBindingContext initManualDataBindings(DataBindingContext bindingContext) {
        TextCellEditor cellEditor_0 = new TextCellEditor((Composite)this.treeViewer.getTable());
        IWidgetValueProperty cellEditorProperty_0 = WidgetProperties.text((int)24);
        IBeanValueProperty valueProperty_0 = BeanProperties.value((String)"proposedName");
        this.nameViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)cellEditor_0, (IValueProperty)cellEditorProperty_0, (IValueProperty)valueProperty_0));
        TextCellEditor cellEditor_1 = new TextCellEditor((Composite)this.treeViewer.getTable());
        IWidgetValueProperty cellEditorProperty = WidgetProperties.text((int)24);
        IBeanValueProperty valueProperty_1 = BeanProperties.value((String)"type");
        this.typeViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)cellEditor_1, (IValueProperty)cellEditorProperty, (IValueProperty)valueProperty_1));
        TextCellEditor cellEditor_2 = new TextCellEditor((Composite)this.treeViewer.getTable());
        IWidgetValueProperty cellEditorProperty_1 = WidgetProperties.text((int)24);
        IBeanValueProperty valueProperty_2 = BeanProperties.value((String)"modelStatus");
        this.statusViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)cellEditor_2, (IValueProperty)cellEditorProperty_1, (IValueProperty)valueProperty_2));
        TextCellEditor cellEditor_3 = new TextCellEditor((Composite)this.treeViewer.getTable());
        IWidgetValueProperty cellEditorProperty_2 = WidgetProperties.text((int)24);
        IBeanValueProperty valueProperty_3 = BeanProperties.value((String)"value");
        this.valueViewerColumn.setEditingSupport(PropertiesEditorWidget.create((ColumnViewer)this.treeViewer, bindingContext, (CellEditor)cellEditor_3, (IValueProperty)cellEditorProperty_2, (IValueProperty)valueProperty_3));
        return bindingContext;
    }

    private class MyContentProvider
    implements ITreeContentProvider {
        private Object[] EMPTY_ARRAY = new Object[0];

        private MyContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Stereotype stereotype = (Stereotype)inputElement;
            return stereotype.getAllAttributes().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return this.EMPTY_ARRAY;
        }

        public Object getParent(Object element) {
            Property property = (Property)element;
            return property.getOwner();
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    public class TaggedValueNameColumnLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            Property property = (Property)element;
            return UMLLabelInternationalization.getInstance().getLabel((NamedElement)property);
        }
    }

    public class TaggedValueValueColumnLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            Property property = (Property)element;
            Object value = PropertiesEditorWidget.this.selectedElement.getValue((Stereotype)property.getOwner(), property.getName());
            if (value instanceof NamedElement) {
                return UMLLabelInternationalization.getInstance().getLabel((NamedElement)value);
            }
            return value.toString();
        }
    }
}

