/*
 * Decompiled with CFR 0.152.
 */
package xpt.diagram.editparts;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildSideAffixedNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

@Singleton
public class Utils_qvto {
    @Inject
    @Extension
    private Common_qvto _common_qvto;

    public boolean isStoringChildPositions(GenNode node) {
        ViewmapLayoutType _layoutType = node.getLayoutType();
        return Objects.equal((Object)_layoutType, (Object)1);
    }

    public Iterable<GenExternalNodeLabel> getExternalLabels(GenNode node) {
        return Iterables.filter((Iterable)node.getLabels(), GenExternalNodeLabel.class);
    }

    public Iterable<GenChildSideAffixedNode> getSideAffixedChildren(GenNode node) {
        return Iterables.filter((Iterable)node.getChildNodes(), GenChildSideAffixedNode.class);
    }

    private Iterable<? extends GenLabel> getInnerLabels(GenNode node) {
        Functions.Function1<GenNodeLabel, Boolean> _function = new Functions.Function1<GenNodeLabel, Boolean>(){

            public Boolean apply(GenNodeLabel i) {
                boolean _oclIsKindOf = Utils_qvto.this._common_qvto.oclIsKindOf(i, GenExternalNodeLabel.class);
                return !_oclIsKindOf;
            }
        };
        return IterableExtensions.filter((Iterable)node.getLabels(), (Functions.Function1)_function);
    }

    public Iterable<? extends GenLabel> getInnerFixedLabels(GenNode node) {
        Iterable<? extends GenLabel> innerLabels = this.getInnerLabels(node);
        Functions.Function1<GenLabel, Boolean> _function = new Functions.Function1<GenLabel, Boolean>(){

            public Boolean apply(GenLabel e) {
                return Utils_qvto.this._common_qvto.oclIsKindOf(e.getViewmap(), ParentAssignedViewmap.class);
            }
        };
        return IterableExtensions.filter(innerLabels, (Functions.Function1)_function);
    }

    public Iterable<GenCompartment> getPinnedCompartments(GenNode node) {
        Functions.Function1<GenCompartment, Boolean> _function = new Functions.Function1<GenCompartment, Boolean>(){

            public Boolean apply(GenCompartment e) {
                return Utils_qvto.this._common_qvto.oclIsKindOf(e.getViewmap(), ParentAssignedViewmap.class);
            }
        };
        return IterableExtensions.filter((Iterable)node.getCompartments(), (Functions.Function1)_function);
    }

    public boolean hasFixedChildren(GenNode node) {
        return IterableExtensions.size(this.getInnerFixedLabels(node)) > 0 || IterableExtensions.size(this.getPinnedCompartments(node)) > 0;
    }

    public boolean listCompartmentHasChildren(GenCompartment compartment) {
        return compartment.isListLayout() && compartment.getChildNodes().size() > 0;
    }

    public boolean hasChildrenInListCompartments(GenNode node) {
        Functions.Function1<GenCompartment, Boolean> _function = new Functions.Function1<GenCompartment, Boolean>(){

            public Boolean apply(GenCompartment e) {
                return Utils_qvto.this.listCompartmentHasChildren(e);
            }
        };
        return IterableExtensions.exists((Iterable)node.getCompartments(), (Functions.Function1)_function);
    }

    public boolean hasBorderItems(GenNode node) {
        return IterableExtensions.size(this.getSideAffixedChildren(node)) > 0 || IterableExtensions.size(this.getExternalLabels(node)) > 0;
    }

    public boolean needsGraphicalNodeEditPolicy(GenNode node) {
        return node.getModelFacet() != null && node.getReorientedIncomingLinks().size() > 0;
    }

    public boolean shouldGenerateDiagramViewmap(GenDiagram genDiagram) {
        HashSet typesWithoutViewmaps = CollectionLiterals.newHashSet((Object[])new ViewmapLayoutType[]{ViewmapLayoutType.UNKNOWN_LITERAL, ViewmapLayoutType.XY_LAYOUT_LITERAL});
        boolean _contains = typesWithoutViewmaps.contains(genDiagram.getViewmap().getLayoutType());
        return !_contains;
    }

    public Iterable<GenLink> getAssistantOutgoingLinks(GenNode node) {
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                Functions.Function1<GenLinkEnd, Boolean> _function = new Functions.Function1<GenLinkEnd, Boolean>(){

                    public Boolean apply(GenLinkEnd t) {
                        return (this).Utils_qvto.this._common_qvto.oclIsKindOf(t, GenNode.class);
                    }
                };
                return IterableExtensions.exists((Iterable)link.getTargets(), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.filter((Iterable)node.getGenOutgoingLinks(), (Functions.Function1)_function);
    }

    public Iterable<GenLink> getAssistantIncomingLinks(GenNode node) {
        Functions.Function1<GenLink, Boolean> _function = new Functions.Function1<GenLink, Boolean>(){

            public Boolean apply(GenLink link) {
                Functions.Function1<GenLinkEnd, Boolean> _function = new Functions.Function1<GenLinkEnd, Boolean>(){

                    public Boolean apply(GenLinkEnd s) {
                        return (this).Utils_qvto.this._common_qvto.oclIsKindOf(s, GenNode.class);
                    }
                };
                return IterableExtensions.exists((Iterable)link.getSources(), (Functions.Function1)_function);
            }
        };
        return IterableExtensions.filter((Iterable)node.getGenIncomingLinks(), (Functions.Function1)_function);
    }

    public Iterable<GenNode> selectGenNodes(Iterable<GenLinkEnd> ends) {
        return Iterables.filter(ends, GenNode.class);
    }

    public boolean haveOneOfChildNodesIncomimgLinks(GenCompartment it) {
        Functions.Function1<GenChildNode, Boolean> _function = new Functions.Function1<GenChildNode, Boolean>(){

            public Boolean apply(GenChildNode n) {
                return Utils_qvto.this._common_qvto.notEmpty(Utils_qvto.this.getAssistantIncomingLinks((GenNode)n));
            }
        };
        return IterableExtensions.exists((Iterable)it.getChildNodes(), (Functions.Function1)_function);
    }

    public List<GenLink> collectIncomingLinks(GenCompartment it) {
        HashSet incomingLinks = new HashSet();
        EList _childNodes = it.getChildNodes();
        for (GenChildNode childNode : _childNodes) {
            boolean _notEmpty = this._common_qvto.notEmpty(this.getAssistantIncomingLinks((GenNode)childNode));
            if (!_notEmpty) continue;
            Iterables.addAll(incomingLinks, this.getAssistantIncomingLinks((GenNode)childNode));
        }
        Functions.Function1<GenLink, Integer> _function = new Functions.Function1<GenLink, Integer>(){

            public Integer apply(GenLink l) {
                return l.getVisualID();
            }
        };
        return IterableExtensions.sortBy(incomingLinks, (Functions.Function1)_function);
    }
}

