/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.configuration;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.papyrus.infra.nattable.filter.IFilterValueToMatchManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NamedStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringValueStyle;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;

public abstract class AbstractFilterValueToMatchManager
implements IFilterValueToMatchManager {
    private final String filterConfigurationId;

    public AbstractFilterValueToMatchManager(String filterConfigurationId) {
        Assert.isNotNull((Object)filterConfigurationId);
        this.filterConfigurationId = filterConfigurationId;
    }

    protected final StringValueStyle getFilterConfigurationIdStyle(IAxis axis) {
        StringValueStyle style = (StringValueStyle)axis.getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "filterForcedByUserId");
        if (style == null) {
            style = (StringValueStyle)axis.getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "filterId");
        }
        return style;
    }

    protected final NamedStyle getValueToMatchStyle(IAxis axis) {
        return axis.getNamedStyle(NattablestylePackage.eINSTANCE.getNamedStyle(), "filterValueToMatch");
    }

    protected boolean isFilterUserStyle(StringValueStyle valueStyle) {
        return "filterForcedByUserId".equals(valueStyle.getName());
    }

    protected final INattableModelManager getINattableModelManager(IConfigRegistry configRegistry) {
        return (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
    }

    @Override
    public final void saveValueToMatch(IConfigRegistry configRegistry, Object axis, Object newValue) {
        CompoundCommand cc = new CompoundCommand("Update Set Value To Match Command");
        INattableModelManager manager = this.getINattableModelManager(configRegistry);
        TransactionalEditingDomain domain = TableEditingDomainUtils.getTableEditingDomain(manager.getTable());
        if (newValue != null) {
            Command saveValueCommand;
            Command saveFilterIdCmd = this.getSaveFilterIdCommand(domain, configRegistry, axis);
            if (saveFilterIdCmd != null && saveFilterIdCmd.canExecute()) {
                cc.append(saveFilterIdCmd);
            }
            if ((saveValueCommand = this.getSaveValueToMatchCommand(domain, configRegistry, axis, newValue)) != null && saveValueCommand.canExecute()) {
                cc.append(saveValueCommand);
            }
        } else {
            Command deleteKeyStyleCommand;
            Command deleteIdCmd = this.getDestroyFilterId(domain, configRegistry, axis);
            if (deleteIdCmd != null && deleteIdCmd.canExecute()) {
                cc.append(deleteIdCmd);
            }
            if ((deleteKeyStyleCommand = this.getDestroyFilterValueToMatchCommand(domain, configRegistry, axis)) != null && deleteKeyStyleCommand.canExecute()) {
                cc.append(deleteKeyStyleCommand);
            }
        }
        if (!cc.isEmpty() && cc.canExecute()) {
            domain.getCommandStack().execute((Command)cc);
        }
    }

    protected final Command getDestroyFilterValueToMatchCommand(TransactionalEditingDomain domain, IConfigRegistry configRegistry, Object axis) {
        if (!(axis instanceof IAxis)) {
            return null;
        }
        IAxis iaxis = (IAxis)axis;
        NamedStyle keyStyle = this.getValueToMatchStyle(iaxis);
        if (keyStyle != null) {
            return RemoveCommand.create((EditingDomain)domain, (Object)iaxis, (Object)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)keyStyle);
        }
        return null;
    }

    protected final Command getDestroyFilterId(TransactionalEditingDomain domain, IConfigRegistry configRegistry, Object axis) {
        if (!(axis instanceof IAxis)) {
            return null;
        }
        IAxis iaxis = (IAxis)axis;
        StringValueStyle idStyle = this.getFilterConfigurationIdStyle(iaxis);
        if (idStyle != null && !this.isFilterUserStyle(idStyle)) {
            return RemoveCommand.create((EditingDomain)domain, (Object)iaxis, (Object)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)idStyle);
        }
        return null;
    }

    protected abstract Command getSaveValueToMatchCommand(TransactionalEditingDomain var1, IConfigRegistry var2, Object var3, Object var4);

    protected final Command getSaveFilterIdCommand(TransactionalEditingDomain domain, IConfigRegistry configRegistry, Object axis) {
        if (!(axis instanceof IAxis)) {
            return null;
        }
        IAxis iaxis = (IAxis)axis;
        StringValueStyle idStyle = this.getFilterConfigurationIdStyle(iaxis);
        if (idStyle != null) {
            Assert.isTrue((boolean)this.filterConfigurationId.equals(idStyle.getStringValue()), (String)"These is a bug, the filter configuration is not the configuration saved in the model");
            return null;
        }
        idStyle = NattablestyleFactory.eINSTANCE.createStringValueStyle();
        idStyle.setName("filterId");
        idStyle.setStringValue(this.filterConfigurationId);
        return AddCommand.create((EditingDomain)domain, (Object)axis, (Object)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)idStyle);
    }
}

