/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.assistants.codegen.generator;

import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.dev.assistants.codegen.generator.ModelingAssistantProviderRule;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ConnectionAssistant;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ElementTypeFilter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.PopupAssistant;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.uml.profile.assistants.generator.FiltersUtil;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ElementTypeToAssistantRule {
    @Extension
    private static AssistantFactory assistantFactory = AssistantFactory.eINSTANCE;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private FiltersUtil _filtersUtil;
    @Inject
    @Extension
    private ModelingAssistantProviderRule _modelingAssistantProviderRule;
    private final HashMap<ArrayList<?>, PopupAssistant> _createCache_toPopupAssistant = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ConnectionAssistant> _createCache_toConnectionAssistant = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ElementTypeFilter> _createCache_toFilter = CollectionLiterals.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PopupAssistant toPopupAssistant(ElementTypeConfiguration type) {
        PopupAssistant _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ElementTypeConfiguration[]{type});
        HashMap<ArrayList<?>, PopupAssistant> hashMap = this._createCache_toPopupAssistant;
        synchronized (hashMap) {
            PopupAssistant _createPopupAssistant;
            if (this._createCache_toPopupAssistant.containsKey(_cacheKey)) {
                return this._createCache_toPopupAssistant.get(_cacheKey);
            }
            _result = _createPopupAssistant = assistantFactory.createPopupAssistant();
            this._createCache_toPopupAssistant.put(_cacheKey, _result);
        }
        this._init_toPopupAssistant(_result, type);
        return _result;
    }

    private void _init_toPopupAssistant(PopupAssistant it, ElementTypeConfiguration type) {
        it.setElementTypeID(type.getIdentifier());
        it.setOwnedFilter(this._filtersUtil.reduce(this.createPossibleOwnersFilter(type)));
    }

    private Filter createPossibleOwnersFilter(ElementTypeConfiguration type) {
        Functions.Function2 _function = (filter, elementType) -> {
            Filter _xifexpression = null;
            boolean _canContainType = this._uMLElementTypes.canContainType(elementType, type);
            if (_canContainType) {
                ElementTypeFilter _filter = this.toFilter((ElementTypeConfiguration)elementType);
                _xifexpression = this._filtersUtil.operator_or(filter, (Filter)_filter);
            } else {
                _xifexpression = filter;
            }
            return _xifexpression;
        };
        return (Filter)IterableExtensions.fold((Iterable)this._uMLElementTypes.getBaseElementTypes(), null, (Functions.Function2)_function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionAssistant toConnectionAssistant(ElementTypeConfiguration type) {
        ConnectionAssistant _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ElementTypeConfiguration[]{type});
        HashMap<ArrayList<?>, ConnectionAssistant> hashMap = this._createCache_toConnectionAssistant;
        synchronized (hashMap) {
            ConnectionAssistant _createConnectionAssistant;
            if (this._createCache_toConnectionAssistant.containsKey(_cacheKey)) {
                return this._createCache_toConnectionAssistant.get(_cacheKey);
            }
            _result = _createConnectionAssistant = assistantFactory.createConnectionAssistant();
            this._createCache_toConnectionAssistant.put(_cacheKey, _result);
        }
        this._init_toConnectionAssistant(_result, type);
        return _result;
    }

    private void _init_toConnectionAssistant(ConnectionAssistant it, ElementTypeConfiguration type) {
        it.setElementTypeID(type.getIdentifier());
        it.setOwnedSourceFilter(this._filtersUtil.reduce(this.createPossibleSourcesFilter(type)));
        it.setOwnedTargetFilter(this._filtersUtil.reduce(this.createPossibleTargetsFilter(type)));
    }

    public ElementTypeSetConfiguration owningSet(ElementTypeConfiguration elementType) {
        EObject _eContainer = elementType.eContainer();
        return (ElementTypeSetConfiguration)_eContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementTypeFilter toFilter(ElementTypeConfiguration elementType) {
        ElementTypeFilter _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ElementTypeConfiguration[]{elementType});
        HashMap<ArrayList<?>, ElementTypeFilter> hashMap = this._createCache_toFilter;
        synchronized (hashMap) {
            ElementTypeFilter _createElementTypeFilter;
            if (this._createCache_toFilter.containsKey(_cacheKey)) {
                return this._createCache_toFilter.get(_cacheKey);
            }
            _result = _createElementTypeFilter = assistantFactory.createElementTypeFilter();
            this._createCache_toFilter.put(_cacheKey, _result);
        }
        this._init_toFilter(_result, elementType);
        return _result;
    }

    private void _init_toFilter(ElementTypeFilter it, ElementTypeConfiguration elementType) {
        it.setElementTypeID(elementType.getIdentifier());
        it.setName(elementType.getName());
        this._modelingAssistantProviderRule.toModelingAssistantProvider(elementType.getOwningSet()).getOwnedFilters().add((Object)it);
    }

    private Filter createPossibleSourcesFilter(ElementTypeConfiguration type) {
        Functions.Function1 _function = it -> {
            boolean _isRelationship = this._uMLElementTypes.isRelationship(it);
            return !_isRelationship;
        };
        Functions.Function2 _function_1 = (filter, elementType) -> {
            Filter _xifexpression = null;
            boolean _canSourceToType = this._uMLElementTypes.canSourceToType(elementType, type);
            if (_canSourceToType) {
                ElementTypeFilter _filter = this.toFilter((ElementTypeConfiguration)elementType);
                _xifexpression = this._filtersUtil.operator_or(filter, (Filter)_filter);
            } else {
                _xifexpression = filter;
            }
            return _xifexpression;
        };
        return (Filter)IterableExtensions.fold((Iterable)IterableExtensions.filter((Iterable)this._uMLElementTypes.getBaseElementTypes(), (Functions.Function1)_function), null, (Functions.Function2)_function_1);
    }

    private Filter createPossibleTargetsFilter(ElementTypeConfiguration type) {
        Functions.Function1 _function = it -> {
            boolean _isRelationship = this._uMLElementTypes.isRelationship(it);
            return !_isRelationship;
        };
        Functions.Function2 _function_1 = (filter, elementType) -> {
            Filter _xifexpression = null;
            boolean _canTargetFromType = this._uMLElementTypes.canTargetFromType(elementType, type);
            if (_canTargetFromType) {
                ElementTypeFilter _filter = this.toFilter((ElementTypeConfiguration)elementType);
                _xifexpression = this._filtersUtil.operator_or(filter, (Filter)_filter);
            } else {
                _xifexpression = filter;
            }
            return _xifexpression;
        };
        return (Filter)IterableExtensions.fold((Iterable)IterableExtensions.filter((Iterable)this._uMLElementTypes.getBaseElementTypes(), (Functions.Function1)_function), null, (Functions.Function2)_function_1);
    }
}

