/**
 * Copyright (c) 2008, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean
 */
package metamodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenPackageImpl;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.GenModelUtils_qvto;

/**
 * package local
 */
@Singleton
@SuppressWarnings("all")
public class MetaModel_qvto {
  @Inject
  @Extension
  private GenModelUtils_qvto _genModelUtils_qvto;

  public String getQualifiedPackageInterfaceName(final GenPackage gp) {
    return gp.getQualifiedPackageInterfaceName();
  }

  public String getQualifiedFactoryInterfaceName(final GenPackage gp) {
    return ((GenPackageImpl) gp).getQualifiedFactoryInterfaceName();
  }

  public String getFactoryInstanceName(final GenPackage gp) {
    return gp.getFactoryInstanceName();
  }

  public String getQualifiedItemProviderAdapterFactoryClassName(final GenPackage gp) {
    return ((GenPackageImpl) gp).getQualifiedItemProviderAdapterFactoryClassName();
  }

  public String getQualifiedInterfaceName(final GenClass gc) {
    return gc.getQualifiedInterfaceName();
  }

  protected String _getQualifiedClassName(final GenClassifier xptSelf) {
    return this.getQualifiedClassName(xptSelf);
  }

  protected String _getQualifiedClassName(final GenDataType xptSelf) {
    return this._genModelUtils_qvto.getObjectCompatibleClassName(xptSelf.getEcoreDataType());
  }

  protected String _getQualifiedClassName(final GenEnum xptSelf) {
    GenPackage _genPackage = xptSelf.getGenPackage();
    String _qualifiedName = xptSelf.getQualifiedName();
    return (_genPackage + _qualifiedName);
  }

  public String getClassifierAccessorName(final GenClassifier gc) {
    return gc.getClassifierAccessorName();
  }

  public String getFeatureAccessorName(final GenFeature gf) {
    return gf.getFeatureAccessorName();
  }

  /**
   * Casts the argument (which is assumed to be of the given source class) to the given target class.
   * A null value may be used for both source and target class to specify the EObject class.
   * If the cast is required, it will be parenthesized as a whole, producing, e.g., ((EObject) o).
   * If the parentheses are not required, use unparenthesizedCast() extension.
   */
  public String parenthesizedCast(final String what, final GenClass source, final GenClass target) {
    boolean _needsCast = this.needsCast(source, target);
    if (_needsCast) {
      String _unparenthesizedCast = this.unparenthesizedCast(what, source, target);
      String _plus = ("(" + _unparenthesizedCast);
      return (_plus + ")");
    } else {
      return what;
    }
  }

  /**
   * Casts the argument (which is assumed to be of the given source class) to the given target class.
   * A null value may be used for both source and target class to specify the EObject class.
   * If the cast is required, it will NOT be parenthesized as a whole, producing, e.g., (EObject) o.
   * If the parentheses are required, use parenthesizedCast() extension.
   */
  public String unparenthesizedCast(final String what, final GenClass source, final GenClass target) {
    String _xifexpression = null;
    boolean _needsCast = this.needsCast(source, target);
    if (_needsCast) {
      String _xifexpression_1 = null;
      if ((target == null)) {
        _xifexpression_1 = ("(org.eclipse.emf.ecore.EObject)" + what);
      } else {
        String _qualifiedInterfaceName = this.getQualifiedInterfaceName(target);
        String _plus = ("(" + _qualifiedInterfaceName);
        String _plus_1 = (_plus + ")");
        _xifexpression_1 = (_plus_1 + what);
      }
      _xifexpression = _xifexpression_1;
    } else {
      _xifexpression = what;
    }
    return _xifexpression;
  }

  private boolean needsCast(final GenClass source, final GenClass target) {
    boolean _equals = Objects.equal(source, target);
    if (_equals) {
      return false;
    }
    if ((target == null)) {
      return ((source != null) && source.isExternalInterface());
    }
    return ((((source == null) || source.isExternalInterface()) || target.isExternalInterface()) || (!this._genModelUtils_qvto.isSuperTypeOf(target, source)));
  }

  public String getQualifiedClassName(final GenClassifier xptSelf) {
    if (xptSelf instanceof GenEnum) {
      return _getQualifiedClassName((GenEnum)xptSelf);
    } else if (xptSelf instanceof GenDataType) {
      return _getQualifiedClassName((GenDataType)xptSelf);
    } else if (xptSelf != null) {
      return _getQualifiedClassName(xptSelf);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(xptSelf).toString());
    }
  }
}
