/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.presentation;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.ExtendedPluginPaletteProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.LocalExtendedPaletteProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PapyrusPaletteService;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.WorkspaceExtendedPaletteProvider;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.Activator;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.PaletteconfigurationPackage;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.editor.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.presentation.CustomPaletteconfigurationModelWizard;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.presentation.PaletteConfigurationEditorPlugin;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.presentation.PaletteconfigurationModelWizard;
import org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.utils.CreatePaletteItemUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CustomPaletteCreationPage
extends PaletteconfigurationModelWizard.PaletteconfigurationModelWizardInitialObjectCreationPage
implements Listener {
    private Text paletteIDField;
    private Text paletteNameField;
    private Text paletteDescriptionField;
    private Text paletteRequiredProfilesField;
    private String paletteID;
    private String paletteName;
    private String paletteDescription;
    private String paletteRequiredProfiles;
    private boolean readOnlyIdentifier;
    private EditingDomain editingDomain;

    public CustomPaletteCreationPage(PaletteconfigurationModelWizard paletteconfigurationModelWizard, String pageId, EditingDomain editingDomain) {
        PaletteconfigurationModelWizard paletteconfigurationModelWizard2 = paletteconfigurationModelWizard;
        ((Object)((Object)paletteconfigurationModelWizard2)).getClass();
        super(pageId);
        this.readOnlyIdentifier = false;
        this.editingDomain = editingDomain;
        this.intializeValues();
    }

    public CustomPaletteCreationPage(CustomPaletteconfigurationModelWizard customPaletteconfigurationModelWizard, String pageId) {
        this(customPaletteconfigurationModelWizard, pageId, null);
    }

    public String getPaletteID() {
        return this.paletteIDField.getText();
    }

    public String getPaletteName() {
        return this.paletteNameField.getText();
    }

    public String getPaletteDescription() {
        return this.paletteDescriptionField.getText();
    }

    public String getPaletteRequiredProfiles() {
        return this.paletteRequiredProfilesField.getText();
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createNameControl(composite);
        this.createDescriptionControl(composite);
        this.createIdentifierControl(composite);
        this.createRequiredProfilesControl(composite);
        this.initialObjectField = new Combo(composite, 2048);
        this.initialObjectField.setVisible(false);
        Label encodingLabel = new Label(composite, 16384);
        encodingLabel.setText(PaletteConfigurationEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
        data = new GridData();
        data.horizontalAlignment = 4;
        encodingLabel.setLayoutData((Object)data);
        this.encodingField = new Combo(composite, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.encodingField.setLayoutData((Object)data);
        for (String encoding : this.getEncodings()) {
            this.encodingField.add(encoding);
        }
        this.encodingField.select(0);
        this.encodingField.addModifyListener(this.validator);
        encodingLabel.setVisible(false);
        this.encodingField.setVisible(false);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    @Override
    protected boolean validatePage() {
        return !this.getPaletteName().isEmpty() && !this.getPaletteID().isEmpty() && this.getEncodings().contains(this.encodingField.getText());
    }

    protected void createIdentifierControl(Composite control) {
        Label indentifierLabel = new Label(control, 0);
        indentifierLabel.setText(PaletteConfigurationEditorPlugin.INSTANCE.getString("_UI_ModelIdentifier"));
        indentifierLabel.setToolTipText(Messages.CustomPaletteCreationPage_Palette_Identifier_Tooltip);
        this.paletteIDField = new Text(control, 2048);
        this.paletteIDField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.paletteIDField.setText(this.paletteID != null ? this.paletteID : "");
        this.paletteIDField.setEnabled(!this.readOnlyIdentifier);
        this.paletteIDField.addListener(24, (Listener)this);
    }

    private String getInitPaletteIDValue() {
        return CreatePaletteItemUtil.generateInitPaletteIDValue();
    }

    protected void createNameControl(Composite control) {
        Label indentifierLabel = new Label(control, 0);
        indentifierLabel.setText(PaletteConfigurationEditorPlugin.INSTANCE.getString("_UI_ModelLabel"));
        this.paletteNameField = new Text(control, 2048);
        this.paletteNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.paletteNameField.setText(this.paletteName != null ? this.paletteName : "");
        this.paletteNameField.addListener(24, (Listener)this);
    }

    protected String getInitPaletteNameValue() {
        return "";
    }

    protected void createDescriptionControl(Composite control) {
        Label indentifierLabel = new Label(control, 0);
        indentifierLabel.setText(PaletteConfigurationEditorPlugin.INSTANCE.getString("_UI_ModelDescription"));
        this.paletteDescriptionField = new Text(control, 2048);
        this.paletteDescriptionField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.paletteDescriptionField.setText(this.paletteDescription != null ? this.paletteDescription : "");
        this.paletteDescriptionField.addListener(24, (Listener)this);
    }

    protected String getInitPaletteDescValue() {
        return "";
    }

    protected void createRequiredProfilesControl(Composite control) {
        Label indentifierLabel = new Label(control, 0);
        indentifierLabel.setText(PaletteConfigurationEditorPlugin.INSTANCE.getString("_UI_ModelRequiredProfiles"));
        this.paletteRequiredProfilesField = new Text(control, 2048);
        this.paletteRequiredProfilesField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.paletteRequiredProfilesField.setText(this.paletteRequiredProfiles != null ? this.paletteRequiredProfiles : "");
        this.paletteRequiredProfilesField.addListener(24, (Listener)this);
    }

    private String getInitRequiredProfilesValue() {
        return "";
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    public void intializeValues() {
        this.paletteID = this.getInitPaletteIDValue();
        this.paletteName = this.getInitPaletteNameValue();
        this.paletteDescription = this.getInitPaletteDescValue();
        this.paletteRequiredProfiles = this.getInitPaletteNameValue();
    }

    public void intializeValues(PapyrusPaletteService.ProviderDescriptor descriptor, Resource resource) {
        this.intializeValues();
        PaletteConfiguration paletteConfiguration = null;
        if (resource != null && !resource.getContents().isEmpty()) {
            paletteConfiguration = (PaletteConfiguration)resource.getContents().get(0);
        } else {
            try {
                paletteConfiguration = (PaletteConfiguration)((ExtendedPluginPaletteProvider)descriptor.getProvider()).loadConfigurationModel(resource).get(0);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        if (descriptor != null && descriptor.getProvider() instanceof ExtendedPluginPaletteProvider) {
            this.paletteID = descriptor.getContributionID();
            this.readOnlyIdentifier = !(descriptor.getProvider() instanceof LocalExtendedPaletteProvider) && !(descriptor.getProvider() instanceof WorkspaceExtendedPaletteProvider);
        } else {
            this.paletteID = paletteConfiguration.getId();
            this.readOnlyIdentifier = false;
        }
        this.paletteName = paletteConfiguration.getLabel();
        this.paletteDescription = paletteConfiguration.getDescription();
        this.paletteRequiredProfiles = paletteConfiguration.getRequiredProfiles().stream().collect(Collectors.joining(", "));
        paletteConfiguration.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getNotifier() instanceof PaletteConfiguration) {
                    String profiles = ((PaletteConfiguration)notification.getNotifier()).getRequiredProfiles().stream().collect(Collectors.joining(", "));
                    CustomPaletteCreationPage.this.paletteRequiredProfilesField.setText(profiles);
                }
            }
        });
    }

    public EObject updateModel(PaletteConfiguration palette) {
        if (this.editingDomain != null) {
            CompoundCommand command = new CompoundCommand("update Model");
            command.append((Command)new SetCommand(this.editingDomain, (EObject)palette, (EStructuralFeature)PaletteconfigurationPackage.eINSTANCE.getConfiguration_Id(), (Object)this.getPaletteID()));
            command.append((Command)new SetCommand(this.editingDomain, (EObject)palette, (EStructuralFeature)PaletteconfigurationPackage.eINSTANCE.getConfiguration_Label(), (Object)this.getPaletteName()));
            command.append((Command)new SetCommand(this.editingDomain, (EObject)palette, (EStructuralFeature)PaletteconfigurationPackage.eINSTANCE.getConfiguration_Description(), (Object)this.getPaletteDescription()));
            String requiredProfiles = this.getRequiredProfiles();
            requiredProfiles = requiredProfiles.replace("\\s+", "");
            if (!requiredProfiles.isEmpty()) {
                command.append((Command)new SetCommand(this.editingDomain, (EObject)palette, (EStructuralFeature)PaletteconfigurationPackage.eINSTANCE.getPaletteConfiguration_RequiredProfiles(), Arrays.asList(requiredProfiles.split(","))));
            }
            if (command.canExecute()) {
                this.editingDomain.getCommandStack().execute((Command)command);
            }
        }
        return palette;
    }

    private String getRequiredProfiles() {
        return this.paletteRequiredProfilesField.getText();
    }
}

