/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.legacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cbi.p2repo.aggregator.legacy.TreePath;
import org.eclipse.cbi.p2repo.aggregator.transformer.ITransformer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceTransformer
implements ITransformer {
    protected Resource srcResource;
    protected Resource trgtResource;
    protected EPackage trgtPackage;
    protected EFactory trgtPackageFactory;
    protected Map<EObject, EObject> transformationMapping = new HashMap<EObject, EObject>();
    protected Map<String, Object> context;
    protected boolean resolveProxies = true;
    private Set<Resource> checkedResources = new HashSet<Resource>();
    private List<Resource.Diagnostic> resourceErrors = new ArrayList<Resource.Diagnostic>();

    public static boolean equalsOneOf(String str, String ... candidates) {
        String[] stringArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            if (str.equals(candidate)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static Object getFeatureValue(EObject eobject, String featureName) {
        EStructuralFeature feature = eobject.eClass().getEStructuralFeature(featureName);
        if (feature == null) {
            throw new IllegalArgumentException(featureName + " is not a valid feature name of " + eobject.eClass().getName() + " EClass");
        }
        return eobject.eGet(feature);
    }

    private void checkResource(EObject srcEObject) {
        Resource res = srcEObject.eResource();
        if (this.checkedResources.add(res)) {
            this.resourceErrors.addAll((Collection<Resource.Diagnostic>)res.getErrors());
        }
    }

    protected void copyAttributes(EObject srcEObject, EObject trgtEObject) {
        for (EAttribute srcEAttr : srcEObject.eClass().getEAllAttributes()) {
            EAttribute trgtEAttr;
            Object srcEAttrValue = srcEObject.eGet((EStructuralFeature)srcEAttr);
            if (srcEAttrValue == null || (trgtEAttr = (EAttribute)trgtEObject.eClass().getEStructuralFeature(srcEAttr.getName())) == null) continue;
            Object trgtEAttrValue = null;
            trgtEAttrValue = srcEAttrValue instanceof EEnumLiteral ? this.createTrgtEEnumLiteral(((EEnumLiteral)srcEAttrValue).getEEnum().getName(), ((EEnumLiteral)srcEAttrValue).getLiteral()) : srcEAttrValue;
            trgtEObject.eSet((EStructuralFeature)trgtEAttr, trgtEAttrValue);
        }
    }

    protected void copyReferences(EObject srcEObject, EObject trgtEObject, TreePath trgtParentTreePath) {
        for (EReference srcERef : srcEObject.eClass().getEAllContainments()) {
            EReference trgtERef;
            Object srcERefValue = srcEObject.eGet((EStructuralFeature)srcERef);
            if (srcERefValue == null || (trgtERef = (EReference)trgtEObject.eClass().getEStructuralFeature(srcERef.getName())) == null) continue;
            TreePath trgtTreePath = trgtParentTreePath.createChildTreePath(trgtEObject, trgtERef);
            if (!srcERef.isMany()) {
                this.transform((EObject)srcERefValue, trgtTreePath);
                continue;
            }
            for (EObject srcChild : (List)srcERefValue) {
                this.transform(srcChild, trgtTreePath);
            }
        }
    }

    protected Object createTrgtEEnumLiteral(String enumName, String literal) {
        if (enumName == null) {
            throw new IllegalArgumentException(enumName + " is not a valid EEnum in the target model");
        }
        EDataType trgtEDataType = (EDataType)this.trgtPackage.getEClassifier(enumName);
        Object enumerator = this.trgtPackageFactory.createFromString(trgtEDataType, literal);
        if (enumerator == null) {
            throw new IllegalArgumentException(literal + " is not a valid literal for EEnum " + enumName + " in the target model");
        }
        return enumerator;
    }

    protected EObject createTrgtEObject(String className, EObject mappedFromSrcEObject) {
        EClass trgtEClass = (EClass)this.trgtPackage.getEClassifier(className);
        if (trgtEClass == null) {
            throw new IllegalArgumentException(className + " is not a valid EClass in the target model");
        }
        EObject trgtEObject = this.trgtPackageFactory.create(trgtEClass);
        if (mappedFromSrcEObject != null) {
            this.transformationMapping.put(mappedFromSrcEObject, trgtEObject);
        }
        return trgtEObject;
    }

    protected void doTransform(EObject srcEObject, TreePath trgtParentTreePath) {
        EClass srcEClass = srcEObject.eClass();
        EObject trgtEObject = this.createTrgtEObject(srcEClass.getName(), srcEObject);
        trgtParentTreePath.addToLastSegmentContainer(trgtEObject);
        if (srcEObject.eIsProxy()) {
            ((InternalEObject)trgtEObject).eSetProxyURI(((EObjectImpl)srcEObject).eProxyURI());
        } else {
            this.copyAttributes(srcEObject, trgtEObject);
            this.copyReferences(srcEObject, trgtEObject, trgtParentTreePath);
        }
        trgtParentTreePath.addToLastSegmentContainer(trgtEObject);
    }

    protected void doTransformRef(EObject srcEObject) {
        this.doTransformRef(srcEObject, true);
    }

    protected void doTransformRef(EObject srcEObject, boolean resolve) {
        EClass scrEClass;
        block11: {
            scrEClass = srcEObject.eClass();
            EObject trgtEObject = this.transformationMapping.get(srcEObject);
            if (trgtEObject == null) break block11;
            EClass trgtEClass = trgtEObject.eClass();
            for (EReference srcERef : scrEClass.getEAllReferences()) {
                EReference trgtERef;
                Object srcERefValue;
                if (scrEClass.getEAllContainments().contains((Object)srcERef) || (srcERefValue = srcEObject.eGet((EStructuralFeature)srcERef, this.resolveProxies || resolve)) == null || (trgtERef = (EReference)trgtEClass.getEStructuralFeature(srcERef.getName())) == null || trgtERef.isTransient()) continue;
                if (!trgtERef.isMany()) {
                    trgtEObject.eSet((EStructuralFeature)trgtERef, (Object)this.transformationMapping.get(srcERefValue));
                    continue;
                }
                if (!(srcERefValue instanceof List)) continue;
                BasicEList srcRefList = (BasicEList)srcERefValue;
                List trgtRefList = (List)trgtEObject.eGet((EStructuralFeature)trgtERef);
                int top = srcRefList.size();
                int idx = 0;
                while (idx < top) {
                    block14: {
                        EObject trgtObj;
                        block13: {
                            block12: {
                                if (!this.resolveProxies && !resolve) break block12;
                                trgtObj = this.transformationMapping.get(srcRefList.get(idx));
                                break block13;
                            }
                            EObject perhapsProxy = (EObject)srcRefList.basicGet(idx);
                            if (perhapsProxy == null) break block14;
                            if (perhapsProxy.eIsProxy()) {
                                trgtObj = this.createTrgtEObject(perhapsProxy.eClass().getName(), perhapsProxy);
                                ((InternalEObject)trgtObj).eSetProxyURI(((EObjectImpl)perhapsProxy).eProxyURI());
                            } else {
                                trgtObj = this.transformationMapping.get(srcRefList.get(idx));
                            }
                        }
                        trgtRefList.add(trgtObj);
                    }
                    ++idx;
                }
            }
        }
        for (EReference srcERef : scrEClass.getEAllContainments()) {
            Object srcERefValue = srcEObject.eGet((EStructuralFeature)srcERef, this.resolveProxies || resolve);
            if (srcERefValue == null) continue;
            if (!srcERef.isMany()) {
                this.transformRef((EObject)srcERefValue);
                continue;
            }
            for (EObject srcChild : (List)srcERefValue) {
                this.transformRef(srcChild);
            }
        }
    }

    public List<Resource.Diagnostic> getResourceErrors() {
        return this.resourceErrors;
    }

    public void initTransformer(Resource srcResource, Resource trgtResource, EPackage trgtPackage, Map<String, Object> context) {
        this.srcResource = srcResource;
        this.trgtResource = trgtResource;
        this.trgtPackage = trgtPackage;
        this.context = context;
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        this.trgtPackageFactory = trgtPackage.getEFactoryInstance();
    }

    public final void startTransformation(boolean resolveProxies) {
        this.resolveProxies = resolveProxies;
        for (EObject srcEObject : this.srcResource.getContents()) {
            this.transform(srcEObject, new TreePath(this.trgtResource));
        }
        for (EObject srcEObject : this.srcResource.getContents()) {
            this.transformRef(srcEObject);
        }
    }

    public final void transform(EObject srcEObject, TreePath treePath) {
        this.checkResource(srcEObject);
        this.doTransform(srcEObject, treePath);
    }

    public final void transformRef(EObject srcEObject) {
        this.checkResource(srcEObject);
        this.doTransformRef(srcEObject);
    }
}

