/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.papyrus.infra.core.resource.ModelSet;

public class ExportAllDiagramsParameter {
    private ImageFileFormat exportFormat = ImageFileFormat.getDefaultImageFormat();
    private IResource outputDirectory = null;
    private URI diFileUri = null;
    private boolean qualifiedName = false;
    private ModelSet modelSet = null;
    private boolean isDisplayStatus = true;

    public ExportAllDiagramsParameter(URI diFileUri) {
        this.setDiFileUri(diFileUri);
    }

    public ExportAllDiagramsParameter(ModelSet modelSet) {
        this.setModelSet(modelSet);
    }

    public ImageFileFormat getExportFormat() {
        return this.exportFormat;
    }

    public void setExportFormat(String exportFormat) {
        this.exportFormat = ImageFileFormat.resolveImageFormat((String)exportFormat);
    }

    public String getOutputDirectoryPath() {
        IPath location = this.outputDirectory.getLocation();
        if (location == null) {
            location = this.outputDirectory.getFullPath();
        }
        return location.toString();
    }

    public void setOutputDirectory(IResource outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public URI getDiFileUri() {
        return this.diFileUri;
    }

    private void setDiFileUri(URI diFileUri) {
        this.diFileUri = diFileUri;
    }

    public boolean isQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(boolean qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    private void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    public boolean isDisplayStatus() {
        return this.isDisplayStatus;
    }

    public void setDisplayStatus(boolean isDisplayStatus) {
        this.isDisplayStatus = isDisplayStatus;
    }
}

