/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.papyrus.uml.diagram.activity.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.uml.diagram.activity.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class UMLNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof UMLNavigatorItem && !this.isOwnView(((UMLNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return UMLDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = UMLDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && UMLElementTypes.isKnownElementType(elementType)) {
            image = UMLElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        return this.getUnknownElementText(view);
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLActivityDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }
}

