/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.util;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.uml.export.Activator;
import org.eclipse.papyrus.uml.export.extension.AnnotateSVG;
import org.eclipse.papyrus.uml.export.svgextension.PapyrusCopyToImageUtil;
import org.eclipse.papyrus.uml.export.util.HTMLUtil;

public class ImageUtil {
    public static List<PartPositionInfo> reFactoredgenerateImg(Path path, Diagram diagram, List<AnnotateSVG> annotations) {
        if (Activator.getDefault().isDebugging()) {
            Activator.debug("Start generating svg for diagram " + diagram.getName() + " in " + String.valueOf(path));
        }
        PapyrusCopyToImageUtil copyToImageUtil = new PapyrusCopyToImageUtil(annotations);
        String diagramNaming = HTMLUtil.diagramRelativPath(diagram);
        IPath append = path.append(diagramNaming + "." + ImageFileFormat.SVG.toString());
        return ImageUtil.generateImg(append, copyToImageUtil, diagram, ImageFileFormat.SVG);
    }

    public static List<PartPositionInfo> generateImg(IPath imagePath, PapyrusCopyToImageUtil copyImageUtil, Diagram currentDiagram, ImageFileFormat fileFormat) {
        Activator.log(1, "Generate image to:" + imagePath.toString());
        File file = imagePath.toFile();
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            root.refreshLocal(2, null);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        List copyToImage = Collections.emptyList();
        try {
            copyToImage = copyImageUtil.copyToImage(currentDiagram, imagePath, fileFormat, (IProgressMonitor)new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return copyToImage;
    }
}

