/**
 * Copyright (c) 2006, 2014, 2021 Borland Software Corporation, Christian W. Damus, CEA LIST, Artal and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Patrick Tessier (CEA) - initial API and implementation
 * Thibault Landre (Atos Origin) - initial API and implementation
 * Vincent Lorenzo (CEA-LIST) - Bug 335987 [General][Enhancement] Show/Hide Connectors Labels and External Nodes Labels
 * Christian W. Damus - bug 451230
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : Remove reference to gmfgraph and ModelViewMap
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up providers + missing nonNLS/@override
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 unsure all default super classes declare overridables
 */
package impl.diagram.editparts;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildSideAffixedNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.RefreshHook;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ResizeConstraints;
import org.eclipse.papyrus.gmf.codegen.gmfgen.SnippetViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import utils.EditPartsUtils_qvto;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.ViewmapAttributesUtils_qvto;
import xpt.diagram.editparts.EditPartFactory;
import xpt.diagram.editparts.Utils_qvto;
import xpt.editor.VisualIDRegistry;
import xpt.providers.ElementTypes;

@Singleton
@SuppressWarnings("all")
public class NodeEditPart {
  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Common_qvto _common_qvto;

  @Inject
  @Extension
  private ViewmapAttributesUtils_qvto _viewmapAttributesUtils_qvto;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  @Extension
  private xpt.diagram.Utils_qvto _utils_qvto_1;

  @Inject
  @Extension
  private VisualIDRegistry _visualIDRegistry;

  @Inject
  @Extension
  private EditPartsUtils_qvto _editPartsUtils_qvto;

  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;

  @Inject
  private TextAware xptTextAware;

  @Inject
  private VisualIDRegistry xptVisualIDRegistry;

  @Inject
  private ElementTypes xptElementTypes;

  @Inject
  private EditPartFactory xptEditPartFactory;

  public CharSequence className(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }

  public CharSequence packageName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }

  protected CharSequence _extendsListContents(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _superEditPart = it.getSuperEditPart();
      boolean _tripleNotEquals = (_superEditPart != null);
      if (_tripleNotEquals) {
        String _superEditPart_1 = it.getSuperEditPart();
        _builder.append(_superEditPart_1);
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart");
        _builder.newLine();
      }
    }
    return _builder;
  }

  protected CharSequence _extendsListContents(final GenChildSideAffixedNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _superEditPart = it.getSuperEditPart();
      boolean _tripleNotEquals = (_superEditPart != null);
      if (_tripleNotEquals) {
        String _superEditPart_1 = it.getSuperEditPart();
        _builder.append(_superEditPart_1);
        _builder.newLineIfNotEmpty();
      } else {
        {
          boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
          if (_hasBorderItems) {
            _builder.append("org.eclipse.papyrus.uml.diagram.common.editparts.BorderedBorderItemEditPart");
            _builder.newLine();
          } else {
            _builder.append("org.eclipse.papyrus.uml.diagram.common.editparts.AbstractBorderItemEditPart");
            _builder.newLine();
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence constructor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createDefaultEditPoliciesBody(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _installCreationRolePolicy = this.installCreationRolePolicy(it);
    _builder.append(_installCreationRolePolicy);
    _builder.newLineIfNotEmpty();
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    CharSequence _installPrimaryDragEditPolicy = this.installPrimaryDragEditPolicy(it);
    _builder.append(_installPrimaryDragEditPolicy);
    _builder.newLineIfNotEmpty();
    CharSequence _installSemanticEditPolicy = this.xptEditpartsCommon.installSemanticEditPolicy(it);
    _builder.append(_installSemanticEditPolicy);
    _builder.newLineIfNotEmpty();
    CharSequence _installGraphicalNodeEditPolicy = this.installGraphicalNodeEditPolicy(it);
    _builder.append(_installGraphicalNodeEditPolicy);
    _builder.newLineIfNotEmpty();
    {
      boolean _isEmpty = it.getChildNodes().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.DRAG_DROP_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy());");
        _builder.newLine();
      }
    }
    CharSequence _installCanonicalEditPolicy = this.xptEditpartsCommon.installCanonicalEditPolicy(it);
    _builder.append(_installCanonicalEditPolicy);
    _builder.newLineIfNotEmpty();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());");
    _builder.newLine();
    CharSequence _behaviour = this.xptEditpartsCommon.behaviour(it);
    _builder.append(_behaviour);
    _builder.newLineIfNotEmpty();
    _builder.append("// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies");
    _builder.newLine();
    _builder.append("// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);");
    _builder.newLine();
    return _builder;
  }

  public CharSequence installGraphicalNodeEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.GRAPHICAL_NODE_ROLE, new org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy());");
    _builder.newLine();
    return _builder;
  }

  public CharSequence installCreationRolePolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!it.getChildNodes().isEmpty()) || this._utils_qvto.hasChildrenInListCompartments(it))) {
        CharSequence _installCreationEditPolicy = this.xptEditpartsCommon.installCreationEditPolicy(it);
        _builder.append(_installCreationEditPolicy);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  protected CharSequence _installPrimaryDragEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _installPrimaryDragEditPolicy(final GenChildSideAffixedNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, getPrimaryDragEditPolicy());");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createLayoutEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gef.editpolicies.LayoutEditPolicy createLayoutEditPolicy() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createLayoutEditPolicyBody = this.createLayoutEditPolicyBody(it);
    _builder.append(_createLayoutEditPolicyBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createLayoutEditPolicyBody(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ViewmapLayoutType _layoutType = it.getLayoutType();
      boolean _equals = Objects.equals(ViewmapLayoutType.XY_LAYOUT_LITERAL, _layoutType);
      if (_equals) {
        CharSequence _createLayoutEditPolicyBody_XY_LAYOUT = this.createLayoutEditPolicyBody_XY_LAYOUT(it);
        _builder.append(_createLayoutEditPolicyBody_XY_LAYOUT);
        _builder.newLineIfNotEmpty();
      } else {
        ViewmapLayoutType _layoutType_1 = it.getLayoutType();
        boolean _equals_1 = Objects.equals(ViewmapLayoutType.TOOLBAR_LAYOUT_LITERAL, _layoutType_1);
        if (_equals_1) {
          CharSequence _createLayoutEditPolicyBody_TOOLBAR_LAYOUT = this.createLayoutEditPolicyBody_TOOLBAR_LAYOUT(it);
          _builder.append(_createLayoutEditPolicyBody_TOOLBAR_LAYOUT);
          _builder.newLineIfNotEmpty();
        } else {
          ViewmapLayoutType _layoutType_2 = it.getLayoutType();
          boolean _equals_2 = Objects.equals(ViewmapLayoutType.FLOW_LAYOUT_LITERAL, _layoutType_2);
          if (_equals_2) {
            CharSequence _createLayoutEditPolicyBody_FLOW_LAYOUT = this.createLayoutEditPolicyBody_FLOW_LAYOUT(it);
            _builder.append(_createLayoutEditPolicyBody_FLOW_LAYOUT);
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _createLayoutEditPolicyBody_DEFAULT = this.createLayoutEditPolicyBody_DEFAULT(it);
            _builder.append(_createLayoutEditPolicyBody_DEFAULT);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence createLayoutEditPolicyBody_XY_LAYOUT(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
    _builder.append(_borderItemSelectionEditPolicy, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.EditPolicy result = super.createChildEditPolicy(child);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (result == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("return lep;");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createLayoutEditPolicyBody_TOOLBAR_LAYOUT(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
    _builder.append(_borderItemSelectionEditPolicy, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (child.getEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE) == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (child instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("return new org.eclipse.papyrus.uml.diagram.common.editpolicies.UMLTextSelectionEditPolicy();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return super.createChildEditPolicy(child);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("return lep;");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createLayoutEditPolicyBody_FLOW_LAYOUT(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.FlowLayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.FlowLayoutEditPolicy() {");
    _builder.newLine();
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
        _builder.append(_borderItemSelectionEditPolicy, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return super.createChildEditPolicy(child);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command createAddCommand(org.eclipse.gef.EditPart child, org.eclipse.gef.EditPart after) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _overrideC_2 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command createMoveChildCommand(org.eclipse.gef.EditPart child, org.eclipse.gef.EditPart after) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _overrideC_3 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command getCreateCommand(org.eclipse.gef.requests.CreateRequest request) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("return lep;");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createLayoutEditPolicyBody_DEFAULT(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
    _builder.append(_borderItemSelectionEditPolicy, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.EditPolicy result = child.getEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (result == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("result = new org.eclipse.gef.editpolicies.NonResizableEditPolicy();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command getMoveChildrenCommand(org.eclipse.gef.Request request) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _overrideC_2 = this._codeStyle.overrideC(it);
    _builder.append(_overrideC_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.gef.commands.Command getCreateCommand(org.eclipse.gef.requests.CreateRequest request) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.append("return lep;");
    _builder.newLine();
    return _builder;
  }

  public CharSequence borderItemSelectionEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        _builder.append("org.eclipse.gmf.runtime.notation.View childView = (org.eclipse.gmf.runtime.notation.View) child.getModel();");
        _builder.newLine();
        _builder.append("String vid = ");
        CharSequence _visualIDMethodCall = this._visualIDRegistry.getVisualIDMethodCall(it.getDiagram());
        _builder.append(_visualIDMethodCall);
        _builder.append("(childView);");
        _builder.newLineIfNotEmpty();
        _builder.append("if (vid != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("switch (vid) {");
        _builder.newLine();
        {
          int _size = IterableExtensions.size(this._utils_qvto.getExternalLabels(it));
          boolean _greaterThan = (_size > 0);
          if (_greaterThan) {
            {
              Iterable<GenExternalNodeLabel> _externalLabels = this._utils_qvto.getExternalLabels(it);
              for(final GenExternalNodeLabel nextLabel : _externalLabels) {
                _builder.append("\t\t");
                CharSequence _caseVisualID = this._visualIDRegistry.caseVisualID(nextLabel);
                _builder.append(_caseVisualID, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t\t");
            _builder.append("return ");
            CharSequence _borderItemSelectionEP = this.borderItemSelectionEP(it);
            _builder.append(_borderItemSelectionEP, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          int _size_1 = IterableExtensions.size(this._utils_qvto.getSideAffixedChildren(it));
          boolean _greaterThan_1 = (_size_1 > 0);
          if (_greaterThan_1) {
            {
              Iterable<GenChildSideAffixedNode> _sideAffixedChildren = this._utils_qvto.getSideAffixedChildren(it);
              for(final GenChildSideAffixedNode nextBorderItem : _sideAffixedChildren) {
                _builder.append("\t\t");
                CharSequence _caseVisualID_1 = this._visualIDRegistry.caseVisualID(nextBorderItem);
                _builder.append(_caseVisualID_1, "\t\t");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("\t\t");
            _builder.append("return new org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy();");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence borderItemSelectionEP(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected java.util.List<?> createSelectionHandles() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gef.handles.MoveHandle mh = new org.eclipse.gef.handles.MoveHandle((org.eclipse.gef.GraphicalEditPart) getHost());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("mh.setBorder(null);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return java.util.Collections.singletonList(mh);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * FIXME:
   * 1. single generation of createNodeShape(), with inner body filled by polymorphic initPrimaryShape, same as in Lite RT
   * 2. getPrimaryShape() for SnippetViewmap. Other templates use it regardless of Viewmap kind, perhaps need to add className to SnippetViewmap (with IFigure being default?)
   * 3. Common (single and shared with Lite RT) condition when to force useLocalConstraints. Lite checks for compartments isEmpty, shouldn't we do the same?
   */
  protected CharSequence _createNodeShape(final Viewmap it, final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    this._common_qvto.ERROR(((("Unknown viewmap: " + it) + " for node: ") + node));
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  protected CharSequence _createNodeShape(final FigureViewmap it, final GenNode node) {
    CharSequence _xblockexpression = null;
    {
      String _xifexpression = null;
      String _figureQualifiedClassName = it.getFigureQualifiedClassName();
      boolean _tripleEquals = (_figureQualifiedClassName == null);
      if (_tripleEquals) {
        _xifexpression = "org.eclipse.draw2d.RectangleFigure";
      } else {
        _xifexpression = it.getFigureQualifiedClassName();
      }
      String fqn = _xifexpression;
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _generatedMemberComment = this._common.generatedMemberComment();
      _builder.append(_generatedMemberComment);
      _builder.newLineIfNotEmpty();
      CharSequence _overrideC = this._codeStyle.overrideC(it);
      _builder.append(_overrideC);
      _builder.newLineIfNotEmpty();
      _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("return primaryShape = new ");
      _builder.append(fqn, "\t");
      _builder.append("()");
      CharSequence _forceUseLocalCoordinatesAnonymousClassBody = this.forceUseLocalCoordinatesAnonymousClassBody(node);
      _builder.append(_forceUseLocalCoordinatesAnonymousClassBody, "\t");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      CharSequence _primaryShapeMethod = this.getPrimaryShapeMethod(fqn, node);
      _builder.append(_primaryShapeMethod);
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }

  protected CharSequence _createNodeShape(final SnippetViewmap it, final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    String _body = it.getBody();
    _builder.append(_body, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _createNodeShape(final InnerClassViewmap it, final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return primaryShape = new ");
    String _className = it.getClassName();
    _builder.append(_className, "\t");
    _builder.append("()");
    CharSequence _forceUseLocalCoordinatesAnonymousClassBody = this.forceUseLocalCoordinatesAnonymousClassBody(node);
    _builder.append(_forceUseLocalCoordinatesAnonymousClassBody, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _primaryShapeMethod = this.getPrimaryShapeMethod(it.getClassName(), node);
    _builder.append(_primaryShapeMethod);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence forceUseLocalCoordinatesAnonymousClassBody(final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!node.getChildNodes().isEmpty()) && Objects.equals(node.getLayoutType(), ViewmapLayoutType.XY_LAYOUT_LITERAL))) {
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected boolean useLocalCoordinates() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence getPrimaryShapeMethod(final String fqn, final GenNode node) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(fqn);
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(this);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    _builder.append(fqn);
    _builder.append(" getPrimaryShape() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return (");
    _builder.append(fqn, "\t");
    _builder.append(") primaryShape;");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence addFixedChild(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean addFixedChild(org.eclipse.gef.EditPart childEditPart) {");
    _builder.newLine();
    _builder.append("\t");
    {
      Iterable<? extends GenLabel> _innerFixedLabels = this._utils_qvto.getInnerFixedLabels(it);
      for(final GenLabel label : _innerFixedLabels) {
        Viewmap _viewmap = label.getViewmap();
        ParentAssignedViewmap childViewmap = ((ParentAssignedViewmap) _viewmap);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if (childEditPart instanceof ");
        CharSequence _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName(label);
        _builder.append(_editPartQualifiedClassName, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("((");
        CharSequence _editPartQualifiedClassName_1 = this.xptEditPartFactory.getEditPartQualifiedClassName(label);
        _builder.append(_editPartQualifiedClassName_1, "\t\t\t");
        _builder.append(") childEditPart).");
        CharSequence _labelSetterName = this.xptTextAware.labelSetterName(childViewmap);
        _builder.append(_labelSetterName, "\t\t\t");
        _builder.append("(getPrimaryShape().");
        String _getterName = childViewmap.getGetterName();
        _builder.append(_getterName, "\t\t\t");
        _builder.append("());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    {
      Iterable<GenCompartment> _pinnedCompartments = this._utils_qvto.getPinnedCompartments(it);
      for(final GenCompartment compartment : _pinnedCompartments) {
        Viewmap _viewmap_1 = compartment.getViewmap();
        ParentAssignedViewmap childViewmap_1 = ((ParentAssignedViewmap) _viewmap_1);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if (childEditPart instanceof ");
        String _editPartQualifiedClassName_2 = compartment.getEditPartQualifiedClassName();
        _builder.append(_editPartQualifiedClassName_2, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("org.eclipse.draw2d.IFigure pane = getPrimaryShape().");
        String _getterName_1 = childViewmap_1.getGetterName();
        _builder.append(_getterName_1, "\t\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("pane.add(((");
        String _editPartQualifiedClassName_3 = compartment.getEditPartQualifiedClassName();
        _builder.append(_editPartQualifiedClassName_3, "\t\t\t");
        _builder.append(") childEditPart).getFigure());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}\t");
        _builder.newLine();
      }
    }
    {
      Iterable<GenChildSideAffixedNode> _sideAffixedChildren = this._utils_qvto.getSideAffixedChildren(it);
      for(final GenChildSideAffixedNode child : _sideAffixedChildren) {
        {
          String _locatorClassName = child.getLocatorClassName();
          boolean _tripleNotEquals = (_locatorClassName != null);
          if (_tripleNotEquals) {
            _builder.append("\t");
            CharSequence _genSpecificLocator = this.genSpecificLocator(child);
            _builder.append(_genSpecificLocator, "\t");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            _builder.append("if (childEditPart instanceof ");
            String _editPartQualifiedClassName_4 = child.getEditPartQualifiedClassName();
            _builder.append(_editPartQualifiedClassName_4, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator locator = new org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator(getMainFigure(), org.eclipse.draw2d.PositionConstants.");
            String _preferredSideName = child.getPreferredSideName();
            _builder.append(_preferredSideName, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("getBorderedFigure().getBorderItemContainer().add(((");
            String _editPartQualifiedClassName_5 = child.getEditPartQualifiedClassName();
            _builder.append(_editPartQualifiedClassName_5, "\t\t");
            _builder.append(") childEditPart).getFigure(), locator);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence removeFixedChild(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean removeFixedChild(org.eclipse.gef.EditPart childEditPart) {");
    _builder.newLine();
    {
      Iterable<? extends GenLabel> _innerFixedLabels = this._utils_qvto.getInnerFixedLabels(it);
      for(final GenLabel label : _innerFixedLabels) {
        _builder.append("\t");
        _builder.append("if (childEditPart instanceof ");
        CharSequence _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName(label);
        _builder.append(_editPartQualifiedClassName, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      Iterable<GenCompartment> _pinnedCompartments = this._utils_qvto.getPinnedCompartments(it);
      for(final GenCompartment compartment : _pinnedCompartments) {
        _builder.append("\t");
        Viewmap _viewmap = compartment.getViewmap();
        ParentAssignedViewmap childViewmap = ((ParentAssignedViewmap) _viewmap);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (childEditPart instanceof ");
        CharSequence _editPartQualifiedClassName_1 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment);
        _builder.append(_editPartQualifiedClassName_1, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("org.eclipse.draw2d.IFigure pane = getPrimaryShape().");
        String _getterName = childViewmap.getGetterName();
        _builder.append(_getterName, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("pane.remove(((");
        CharSequence _editPartQualifiedClassName_2 = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment);
        _builder.append(_editPartQualifiedClassName_2, "\t\t");
        _builder.append(") childEditPart).getFigure());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}\t");
        _builder.newLine();
      }
    }
    {
      Iterable<GenChildSideAffixedNode> _sideAffixedChildren = this._utils_qvto.getSideAffixedChildren(it);
      for(final GenChildSideAffixedNode child : _sideAffixedChildren) {
        _builder.append("\t");
        _builder.append("if (childEditPart instanceof ");
        CharSequence _editPartQualifiedClassName_3 = this.xptEditPartFactory.getEditPartQualifiedClassName(child);
        _builder.append(_editPartQualifiedClassName_3, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("getBorderedFigure().getBorderItemContainer().remove(((");
        CharSequence _editPartQualifiedClassName_4 = this.xptEditPartFactory.getEditPartQualifiedClassName(child);
        _builder.append(_editPartQualifiedClassName_4, "\t\t");
        _builder.append(") childEditPart).getFigure());");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence addChildVisual(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void addChildVisual(org.eclipse.gef.EditPart childEditPart, int index) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (addFixedChild(childEditPart)) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.addChildVisual(childEditPart, -1);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence removeChildVisual(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void removeChildVisual(org.eclipse.gef.EditPart childEditPart) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (removeFixedChild(childEditPart)){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.removeChildVisual(childEditPart);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getContentPaneFor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure getContentPaneFor(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart editPart) {");
    _builder.newLine();
    {
      Iterable<GenCompartment> _pinnedCompartments = this._utils_qvto.getPinnedCompartments(it);
      for(final GenCompartment compartment : _pinnedCompartments) {
        _builder.append("\t");
        Viewmap _viewmap = compartment.getViewmap();
        ParentAssignedViewmap childViewmap = ((ParentAssignedViewmap) _viewmap);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (editPart instanceof ");
        CharSequence _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName(compartment);
        _builder.append(_editPartQualifiedClassName, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return getPrimaryShape().");
        String _getterName = childViewmap.getGetterName();
        _builder.append(_getterName, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}\t");
        _builder.newLine();
      }
    }
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        _builder.append("if (editPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return getBorderedFigure().getBorderItemContainer();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return getContentPane();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence addBorderItem(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _size = IterableExtensions.size(this._utils_qvto.getExternalLabels(it));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void addBorderItem(org.eclipse.draw2d.IFigure borderItemContainer, org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart borderItemEditPart) {");
        _builder.newLine();
        {
          int _size_1 = this._editPartsUtils_qvto.getExternalLabelsWithoutSpecificLocator(it).size();
          boolean _greaterThan_1 = (_size_1 > 0);
          if (_greaterThan_1) {
            _builder.append("if (");
            {
              List<GenExternalNodeLabel> _externalLabelsWithoutSpecificLocator = this._editPartsUtils_qvto.getExternalLabelsWithoutSpecificLocator(it);
              boolean _hasElements = false;
              for(final GenExternalNodeLabel label : _externalLabelsWithoutSpecificLocator) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder.appendImmediate(" || ", "");
                }
                _builder.append("borderItemEditPart instanceof ");
                String _editPartQualifiedClassName = label.getEditPartQualifiedClassName();
                _builder.append(_editPartQualifiedClassName);
              }
            }
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator locator = new org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator(getMainFigure(), org.eclipse.draw2d.PositionConstants.SOUTH);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("locator.setBorderItemOffset(new org.eclipse.draw2d.geometry.Dimension(-20, -20));");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("borderItemContainer.add(borderItemEditPart.getFigure(), locator);");
            _builder.newLine();
            _builder.append("} else");
            _builder.newLine();
          }
        }
        {
          List<GenExternalNodeLabel> _externalLabelsWithSpecificLocator = this._editPartsUtils_qvto.getExternalLabelsWithSpecificLocator(it);
          for(final GenExternalNodeLabel label_1 : _externalLabelsWithSpecificLocator) {
            _builder.append("if (borderItemEditPart instanceof ");
            String _editPartQualifiedClassName_1 = label_1.getEditPartQualifiedClassName();
            _builder.append(_editPartQualifiedClassName_1);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator locator = new ");
            String _specificLocator = this._editPartsUtils_qvto.getSpecificLocator(label_1);
            _builder.append(_specificLocator, "\t");
            _builder.append("(getMainFigure());");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("borderItemContainer.add(borderItemEditPart.getFigure(), locator);");
            _builder.newLine();
            _builder.append("} else");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("super.addBorderItem(borderItemContainer, borderItemEditPart);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence createNodePlate(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure createNodePlate() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure result = new org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure(");
    {
      boolean _isPixelMapMode = this._utils_qvto_1.isPixelMapMode(it.getDiagram());
      if (_isPixelMapMode) {
        int _defaultSizeWidth = this._viewmapAttributesUtils_qvto.defaultSizeWidth(it.getViewmap(), 40);
        _builder.append(_defaultSizeWidth, "\t");
        _builder.append(", ");
        int _defaultSizeHeight = this._viewmapAttributesUtils_qvto.defaultSizeHeight(it.getViewmap(), 40);
        _builder.append(_defaultSizeHeight, "\t");
      } else {
        _builder.append("getMapMode().DPtoLP(");
        int _defaultSizeWidth_1 = this._viewmapAttributesUtils_qvto.defaultSizeWidth(it.getViewmap(), 40);
        _builder.append(_defaultSizeWidth_1, "\t");
        _builder.append("), getMapMode().DPtoLP(");
        int _defaultSizeHeight_1 = this._viewmapAttributesUtils_qvto.defaultSizeHeight(it.getViewmap(), 40);
        _builder.append(_defaultSizeHeight_1, "\t");
        _builder.append(")");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getPrimaryDragEditPolicy(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    ResizeConstraints rc = this._viewmapAttributesUtils_qvto.getResizeConstraints(it.getViewmap());
    _builder.newLineIfNotEmpty();
    {
      if (((null != it.getPrimaryDragEditPolicyQualifiedClassName()) || (null != rc))) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.gef.EditPolicy getPrimaryDragEditPolicy() {");
        _builder.newLine();
        {
          String _primaryDragEditPolicyQualifiedClassName = it.getPrimaryDragEditPolicyQualifiedClassName();
          boolean _tripleNotEquals = (null != _primaryDragEditPolicyQualifiedClassName);
          if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("return new ");
            String _primaryDragEditPolicyQualifiedClassName_1 = it.getPrimaryDragEditPolicyQualifiedClassName();
            _builder.append(_primaryDragEditPolicyQualifiedClassName_1, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            _builder.append("org.eclipse.gef.EditPolicy result = super.getPrimaryDragEditPolicy();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (result instanceof org.eclipse.gef.editpolicies.ResizableEditPolicy) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("org.eclipse.gef.editpolicies.ResizableEditPolicy ep = (org.eclipse.gef.editpolicies.ResizableEditPolicy) result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("ep.setResizeDirections(");
            {
              boolean _isEmpty = rc.getResizeHandleNames().isEmpty();
              boolean _not = (!_isEmpty);
              if (_not) {
                {
                  EList<String> _resizeHandleNames = rc.getResizeHandleNames();
                  boolean _hasElements = false;
                  for(final String name : _resizeHandleNames) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(" | ", "\t\t");
                    }
                    _builder.append("org.eclipse.draw2d.PositionConstants.");
                    _builder.append(name, "\t\t");
                  }
                }
              } else {
                _builder.append("org.eclipse.draw2d.PositionConstants.NONE");
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return result;");
            _builder.newLine();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence createFigure(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(((("Creates figure for this edit part.\n" + 
      "\n") + 
      "Body of this method does not depend on settings in generation model\n") + 
      "so you may safely remove <i>generated</i> tag and modify it."));
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure create");
    {
      boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
      if (_hasBorderItems) {
        _builder.append("Main");
      } else {
        _builder.append("Node");
      }
    }
    _builder.append("Figure() {");
    _builder.newLineIfNotEmpty();
    {
      if ((it instanceof GenChildSideAffixedNode)) {
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure figure = createNodePlate();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("figure.setLayoutManager(new org.eclipse.draw2d.StackLayout());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.draw2d.IFigure shape = createNodeShape();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("figure.add(shape);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("contentPane = setupContentPane(shape);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return figure;");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("return new org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure(createMainFigureWithSVG());");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence setupContentPane(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment(((("Default implementation treats passed figure as content pane.\n" + 
      "Respects layout one may have set for generated figure.\n\n") + 
      "@param nodeShape\n") + 
      "           instance of generated figure class"));
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure setupContentPane(org.eclipse.draw2d.IFigure nodeShape) {");
    _builder.newLine();
    {
      if ((((!it.getChildNodes().isEmpty()) || (!it.getCompartments().isEmpty())) || IterableExtensions.<GenNodeLabel>exists(it.getLabels(), ((Function1<GenNodeLabel, Boolean>) (GenNodeLabel l) -> {
        boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(l, GenExternalNodeLabel.class);
        return Boolean.valueOf((!_oclIsKindOf));
      })))) {
        _builder.append("\t");
        _builder.append("if (nodeShape.getLayoutManager() == null) {");
        _builder.newLine();
        {
          ViewmapLayoutType _layoutType = it.getLayoutType();
          boolean _equals = Objects.equals(_layoutType, ViewmapLayoutType.XY_LAYOUT_LITERAL);
          if (_equals) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("nodeShape.setLayoutManager(new org.eclipse.draw2d.FreeformLayout() {");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("public Object getConstraint(org.eclipse.draw2d.IFigure figure) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("Object result = constraints.get(figure);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("if (result == null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("result = new org.eclipse.draw2d.geometry.Rectangle(0, 0, -1, -1);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("});");
            _builder.newLine();
          } else {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout layout =new org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("layout.setSpacing(");
            {
              boolean _isPixelMapMode = this._utils_qvto_1.isPixelMapMode(it.getDiagram());
              if (_isPixelMapMode) {
                _builder.append("5");
              } else {
                _builder.append("getMapMode().DPtoLP(5)");
              }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("nodeShape.setLayoutManager(layout);");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return nodeShape; // use nodeShape itself as contentPane");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getContentPane(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.draw2d.IFigure getContentPane() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (contentPane != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return contentPane;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getContentPane();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence setForegroundColor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setForegroundColor(org.eclipse.swt.graphics.Color color) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (primaryShape != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("primaryShape.setForegroundColor(color);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence setBackgroundColor(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setBackgroundColor(org.eclipse.swt.graphics.Color color) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (primaryShape != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("primaryShape.setBackgroundColor(color);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence setLineWidth(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setLineWidth(int width) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.setLineWidth(width);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence setLineStyle(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void setLineType(int style) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (primaryShape instanceof org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure) {\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("((org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure) primaryShape).setLineStyle(style);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getPrimaryChildEditPart(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = it.getLabels().isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.gef.EditPart getPrimaryChildEditPart() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return getChildBySemanticHint(");
        CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(IterableExtensions.<GenNodeLabel>head(it.getLabels()));
        _builder.append(_typeMethodCall, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence handleNotificationEventBody(final GenTopLevelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (event.getNotifier() == getModel() && org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("handleMajorSemanticChange();");
    _builder.newLine();
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.handleNotificationEvent(event);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _innerClassDeclaration(final Viewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _innerClassDeclaration(final InnerClassViewmap it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    String _classBody = it.getClassBody();
    _builder.append(_classBody, "\t");
    return _builder;
  }

  public CharSequence getTargetEditPartMethod(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gef.EditPart getTargetEditPart(org.eclipse.gef.Request request) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (request instanceof org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter adapter = ((org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest) request).getViewAndElementDescriptor().getCreateElementRequestAdapter();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType type = (org.eclipse.gmf.runtime.emf.type.core.IElementType) adapter.getAdapter(org.eclipse.gmf.runtime.emf.type.core.IElementType.class);");
    _builder.newLine();
    {
      EList<GenCompartment> _compartments = it.getCompartments();
      for(final GenCompartment compartment : _compartments) {
        {
          boolean _listCompartmentHasChildren = this._utils_qvto.listCompartmentHasChildren(compartment);
          if (_listCompartmentHasChildren) {
            {
              EList<GenChildNode> _childNodes = compartment.getChildNodes();
              for(final GenChildNode childNode : _childNodes) {
                _builder.append("if (");
                CharSequence _className = this.xptElementTypes.className(it.getDiagram());
                _builder.append(_className);
                _builder.append(".isKindOf(type, ");
                CharSequence _accessElementType = this.xptElementTypes.accessElementType(childNode);
                _builder.append(_accessElementType);
                _builder.append(")) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("return getChildBySemanticHint(");
                CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(compartment);
                _builder.append(_typeMethodCall, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return super.getTargetEditPart(request);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence genSpecificLocator(final GenChildSideAffixedNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (childEditPart instanceof ");
    String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator locator = new ");
    String _locatorClassName = it.getLocatorClassName();
    _builder.append(_locatorClassName, "\t");
    _builder.append("(getMainFigure(), org.eclipse.draw2d.PositionConstants.");
    String _preferredSideName = it.getPreferredSideName();
    _builder.append(_preferredSideName, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("getBorderedFigure().getBorderItemContainer().add(((");
    String _editPartQualifiedClassName_1 = it.getEditPartQualifiedClassName();
    _builder.append(_editPartQualifiedClassName_1, "\t");
    _builder.append(") childEditPart).getFigure(), locator);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * CreateGenerator to refresh figure by taking account of event of UML element or graphical element
   */
  public CharSequence specificHandleNotificationEvent(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isSpecificNotificationEvent = it.isSpecificNotificationEvent();
      if (_isSpecificNotificationEvent) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Papyrus codeGen");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @generated");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("**/");
        _builder.newLine();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void handleNotificationEvent(org.eclipse.emf.common.notify.Notification event) {");
        _builder.newLine();
        {
          int _size = IterableExtensions.size(Iterables.<GenExternalNodeLabel>filter(it.getLabels(), GenExternalNodeLabel.class));
          boolean _notEquals = (_size != 0);
          if (_notEquals) {
            _builder.append("\t");
            _builder.append("/*");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* when a node have external node labels, the methods refreshChildren() remove the EditPart corresponding to the Label from the EditPart");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* Registry. After that, we can\'t reset the visibility to true (using the Show/Hide Label Action)!");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getView_Visible().equals(event.getFeature())) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("Object notifier = event.getNotifier();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("java.util.List<?> modelChildren = ((org.eclipse.gmf.runtime.notation.View)getModel()).getChildren();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (false == notifier instanceof org.eclipse.gmf.runtime.notation.Edge ");
            _builder.append("&& false == notifier instanceof org.eclipse.gmf.runtime.notation.BasicCompartment) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("if(modelChildren.contains(event.getNotifier())) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("return;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("super.handleNotificationEvent(event);");
        _builder.newLine();
        {
          RefreshHook _refreshHook = it.getRefreshHook();
          boolean _tripleNotEquals = (_refreshHook != null);
          if (_tripleNotEquals) {
            _builder.append("\t");
            CharSequence _specificHandleNotificationEventBody = this.specificHandleNotificationEventBody(it.getRefreshHook());
            _builder.append(_specificHandleNotificationEventBody, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence specificHandleNotificationEventBody(final RefreshHook it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (resolveSemanticElement() != null) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(");
    String _refreshCondition = it.getRefreshCondition();
    _builder.append(_refreshCondition, "\t");
    _builder.append("){ ");
    CharSequence _nonNLS = this._common.nonNLS(it.getRefreshCondition());
    _builder.append(_nonNLS, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    String _refreshAction = it.getRefreshAction();
    _builder.append(_refreshAction, "\t\t");
    _builder.append("; ");
    CharSequence _nonNLS_1 = this._common.nonNLS(it.getRefreshAction());
    _builder.append(_nonNLS_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("refreshVisuals();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence extendsListContents(final GenNode it) {
    if (it instanceof GenChildSideAffixedNode) {
      return _extendsListContents((GenChildSideAffixedNode)it);
    } else if (it != null) {
      return _extendsListContents(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence installPrimaryDragEditPolicy(final GenNode it) {
    if (it instanceof GenChildSideAffixedNode) {
      return _installPrimaryDragEditPolicy((GenChildSideAffixedNode)it);
    } else if (it != null) {
      return _installPrimaryDragEditPolicy(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }

  public CharSequence createNodeShape(final Viewmap it, final GenNode node) {
    if (it instanceof FigureViewmap) {
      return _createNodeShape((FigureViewmap)it, node);
    } else if (it instanceof InnerClassViewmap) {
      return _createNodeShape((InnerClassViewmap)it, node);
    } else if (it instanceof SnippetViewmap) {
      return _createNodeShape((SnippetViewmap)it, node);
    } else if (it != null) {
      return _createNodeShape(it, node);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, node).toString());
    }
  }

  public CharSequence innerClassDeclaration(final Viewmap it) {
    if (it instanceof InnerClassViewmap) {
      return _innerClassDeclaration((InnerClassViewmap)it);
    } else if (it != null) {
      return _innerClassDeclaration(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
