/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.releng.tools.internal.popup.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.releng.tools.internal.popup.actions.DependencyUpdater;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLDependencyUpdater
extends DependencyUpdater<Node> {
    private Document currentDocument;

    protected abstract String getXpath();

    @Override
    protected List<Node> getNodesToUpdate(IFile file) throws CoreException {
        File rmapFile = file.getLocation().toFile();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.currentDocument = docBuilder.parse(rmapFile);
            this.currentDocument.normalize();
            Element documentElement = this.currentDocument.getDocumentElement();
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList uris = (NodeList)xpath.evaluate(this.getXpath(), documentElement, XPathConstants.NODESET);
            ArrayList<Node> result = new ArrayList<Node>(uris.getLength());
            int i = 0;
            while (i < uris.getLength()) {
                result.add(uris.item(i));
                ++i;
            }
            return result;
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.releng.tools", "Error updating map: " + ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    @Override
    protected String getComment(Node node) {
        Node comment = this.getPrecedingComment(node);
        return comment == null ? null : this.getCommentContent(comment);
    }

    protected Node getPrecedingComment(Node node) {
        Comment comment = null;
        Node previous = node.getPreviousSibling();
        while (previous != null) {
            if (previous.getNodeType() == 8) {
                comment = (Comment)previous;
                break;
            }
            if (previous.getNodeType() != 3) break;
            previous = previous.getPreviousSibling();
        }
        return comment;
    }

    protected String getCommentContent(Node comment) {
        return comment.getTextContent();
    }

    @Override
    protected void save(IFile file) throws Exception {
        File destination = file.getLocation().toFile();
        this.save(this.currentDocument, destination);
    }

    protected void save(Document document, File destination) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(destination);
        DOMSource source = new DOMSource(this.currentDocument);
        transformer.transform(source, result);
    }
}

