/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.toolbar;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarButton;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;

@Deprecated
public class ToolbarConfiguration {
    public boolean removePasteText = true;
    public boolean removePasteFromWord = true;
    public boolean removeStyles = true;
    public boolean removeFormat = true;
    public boolean toolbarCollapsible = false;
    public boolean toolbarInitialExpanded = true;
    private Browser browser;
    private Set<ToolbarButton> customButtons = new LinkedHashSet<ToolbarButton>();
    private Map<String, BrowserFunction> buttonCallbacks = new HashMap<String, BrowserFunction>();
    private Set<String> removedButtons = new HashSet<String>();

    public void configureToolbar() {
        this.browser.evaluate(String.valueOf(this.getToolbarGroupConfiguration()) + this.getRemoveButtonConfiguration() + this.getCustomButtonConfiguration());
    }

    protected String getToolbarGroupConfiguration() {
        return "CKEDITOR.config.toolbarGroups = [{ name: 'clipboard', groups: [ 'clipboard', 'undo', 'find' ] },{ name: 'other' },'/',{ name: 'paragraph', groups: [ 'list', 'indent', 'align' ] },{ name: 'colors' },'/',{ name: 'styles' },{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] }] ;";
    }

    protected String getRemoveButtonConfiguration() {
        StringBuilder builder = new StringBuilder("CKEDITOR.config.removeButtons = 'Subscript,Superscript");
        if (this.removePasteText) {
            builder.append(",PasteText");
        }
        if (this.removePasteFromWord) {
            builder.append(",PasteFromWord");
        }
        if (this.removeStyles) {
            builder.append(",Styles");
        }
        if (this.removeFormat) {
            builder.append(",Format");
        }
        for (String removed : this.removedButtons) {
            builder.append(",").append(removed);
        }
        builder.append("';");
        return builder.toString();
    }

    protected String getCustomButtonConfiguration() {
        StringBuilder builder = new StringBuilder();
        for (ToolbarButton button : this.customButtons) {
            builder.append("CKEDITOR.instances.editor.addCommand('").append(button.getCommandName()).append("', {");
            builder.append("exec: function(edt) {");
            if (button.getJavascriptToExecute() == null) {
                builder.append("javaExecutionStarted();");
                BrowserFunction function = this.buttonCallbacks.get(button.getCommandName());
                builder.append(function.getName()).append("();");
                builder.append("javaExecutionFinished()");
            } else {
                builder.append(button.getJavascriptToExecute());
            }
            builder.append("}});");
            builder.append("CKEDITOR.instances.editor.ui.addButton('").append(button.getButtonName()).append("', {");
            builder.append("label: '").append(button.getButtonLabel()).append("',");
            builder.append("command: '").append(button.getCommandName()).append("',");
            builder.append("toolbar: '").append(button.getToolbar()).append("',");
            if (button.getIconURL() != null) {
                builder.append("icon: '").append(button.getIconURL().toString()).append("',");
            }
            builder.append("});");
        }
        return builder.toString();
    }

    public void addToolbarButton(final ToolbarButton button) {
        if (this.browser != null) {
            this.addToolbarButton(button, new BrowserFunction(this.browser, button.getCommandName()){

                public Object function(Object[] arguments) {
                    return button.execute();
                }
            });
        } else if (!this.customButtons.contains(button)) {
            this.customButtons.add(button);
        }
    }

    public void addToolbarButton(ToolbarButton button, BrowserFunction function) {
        if (this.buttonCallbacks.containsKey(button.getCommandName())) {
            this.buttonCallbacks.get(button.getCommandName()).dispose();
        }
        this.buttonCallbacks.put(button.getCommandName(), function);
        if (!this.customButtons.contains(button)) {
            this.customButtons.add(button);
        }
        this.removedButtons.remove(button.getButtonName());
    }

    public void removeToolbarButton(ToolbarButton button) {
        this.customButtons.remove(button);
        if (this.buttonCallbacks.containsKey(button.getCommandName())) {
            this.buttonCallbacks.get(button.getCommandName()).dispose();
            this.buttonCallbacks.remove(button.getCommandName());
        }
        this.removedButtons.add(button.getButtonName());
    }

    public void addDefaultToolbarButton(String buttonName) {
        this.removedButtons.remove(buttonName);
    }

    public void removeDefaultToolbarButton(String buttonName) {
        this.removedButtons.add(buttonName);
    }

    public void dispose() {
        for (BrowserFunction function : this.buttonCallbacks.values()) {
            function.dispose();
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
        for (ToolbarButton button : this.customButtons) {
            this.addToolbarButton(button);
        }
    }

    public Set<ToolbarButton> getCustomButtons() {
        return Collections.unmodifiableSet(this.customButtons);
    }

    public Map<String, BrowserFunction> getButtonCallbacks() {
        return Collections.unmodifiableMap(this.buttonCallbacks);
    }

    public Set<String> getRemovedButtons() {
        return Collections.unmodifiableSet(this.removedButtons);
    }

    public String[] getToolbarButtonConfigurations() {
        return new String[]{this.getToolbarGroupConfiguration(), this.getRemoveButtonConfiguration()};
    }
}

