/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.discovery.ui.wizards;

import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.infra.discovery.ui.internal.common.CommonImages;
import org.eclipse.papyrus.infra.discovery.ui.internal.common.Installer;
import org.eclipse.papyrus.infra.discovery.ui.internal.wizards.DiscoveryWizardMainPage;
import org.eclipse.papyrus.infra.discovery.ui.viewer.DiscoveryContentProvider;

public class DiscoveryWizard
extends Wizard {
    private DiscoveryWizardMainPage mainPage;
    private boolean showConnectorDescriptorKindFilter = true;
    private boolean showConnectorDescriptorTextFilter = true;
    private DiscoveryContentProvider provider;

    public DiscoveryWizard(DiscoveryContentProvider provider) {
        this.provider = provider;
        this.setWindowTitle(provider.getTitle());
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(CommonImages.BANNER_DISCOVERY);
    }

    public void addPages() {
        this.mainPage = new DiscoveryWizardMainPage(this.provider);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        return Installer.install(this.mainPage.getInstallableConnectors(), (IRunnableContext)this.getContainer());
    }

    public boolean isShowConnectorDescriptorKindFilter() {
        return this.showConnectorDescriptorKindFilter;
    }

    public void setShowConnectorDescriptorKindFilter(boolean showConnectorDescriptorKindFilter) {
        this.showConnectorDescriptorKindFilter = showConnectorDescriptorKindFilter;
    }

    public boolean isShowConnectorDescriptorTextFilter() {
        return this.showConnectorDescriptorTextFilter;
    }

    public void setShowConnectorDescriptorTextFilter(boolean showConnectorDescriptorTextFilter) {
        this.showConnectorDescriptorTextFilter = showConnectorDescriptorTextFilter;
    }
}

