/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal.resource;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.internal.language.ILanguageModel;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.Activator;

public class InternalIndexUtil {
    public static final String TRACE_INDEXER = "indexer";

    private InternalIndexUtil() {
    }

    public static boolean isTracing() {
        return Activator.log.isTraceEnabled(TRACE_INDEXER);
    }

    public static void tracef(String format, Object ... args) {
        Activator.log.trace(TRACE_INDEXER, String.format(format, args));
    }

    public static Set<String> getSemanticModelFileExtensions(ResourceSet resourceSet) {
        Set<String> result = null;
        try {
            if (resourceSet instanceof ModelSet) {
                ILanguageService.getLanguageModels((ModelSet)((ModelSet)resourceSet)).stream().map(m -> (ILanguageModel)m.getAdapter(ILanguageModel.class)).filter(Objects::nonNull).map(ILanguageModel::getModelFileExtension).filter(Objects::nonNull).collect(Collectors.toSet());
            }
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (result == null) {
            result = Collections.singleton("uml");
        }
        return result;
    }
}

