/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.views.config.manager.cell;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.views.config.utils.Utils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class ModelViewsCellManager
extends AbstractCellManager {
    protected List<Object> organizeAndResolvedObjects(Object columnElement, Object rowElement) {
        EObject first;
        IPageManager mngr;
        ArrayList<Object> objects = new ArrayList<Object>();
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        Object column = AxisUtils.getRepresentedElement((Object)columnElement);
        if (row instanceof String && ((String)row).startsWith("nattable_editor_pages:/") && column instanceof EObject) {
            objects.add(column);
            objects.add(row);
        } else if (column instanceof String && ((String)column).startsWith("nattable_editor_pages:/") && row instanceof EObject) {
            objects.add(row);
            objects.add(column);
        }
        if (objects.size() == 2 && ((mngr = Utils.getIPagneManager(first = (EObject)objects.get(0))) != null && !mngr.allPages().contains(first) || mngr == null)) {
            return null;
        }
        if (objects.size() == 2) {
            return objects;
        }
        return null;
    }

    public boolean handles(Object rowElement, Object columnElement, INattableModelManager tableManager) {
        return this.organizeAndResolvedObjects(columnElement, rowElement) != null;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement);
        String featureName = ((String)objects.get(1)).replace("nattable_editor_pages:/", "");
        Object editor = objects.get(0);
        if ("name".equals(featureName)) {
            return this.getEditorName(editor);
        }
        if ("context".equals(featureName)) {
            return this.getEditorContext(editor);
        }
        if ("isOpen".equals(featureName)) {
            return this.getEditorIsOpen(editor);
        }
        if ("type".equals(featureName)) {
            return this.getEditorType(editor);
        }
        return NOT_AVALAIBLE;
    }

    public boolean isCellEditable(Object rowElement, Object columnElement, INattableModelManager tableManager) {
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement);
        String featureName = ((String)objects.get(1)).replace("nattable_editor_pages:/", "");
        return featureName.equals("name");
    }

    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager manager) {
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement);
        EObject editor = (EObject)objects.get(0);
        String featureName = ((String)objects.get(1)).replace("nattable_editor_pages:/", "");
        if ("name".equals(featureName)) {
            EStructuralFeature feature = editor.eClass().getEStructuralFeature("name");
            if (!newValue.equals(editor.eClass().eGet(feature))) {
                SetRequest request = new SetRequest(domain, editor, feature, newValue);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)editor);
                return new GMFtoEMFCommandWrapper(provider.getEditCommand((IEditCommandRequest)request));
            }
        }
        return null;
    }

    protected Object getEditorType(Object editor) {
        if (editor instanceof EObject) {
            if (editor instanceof Table) {
                return ((Table)editor).getTableConfiguration().getType();
            }
            EStructuralFeature feature = ((EObject)editor).eClass().getEStructuralFeature("type");
            if (feature != null) {
                return ((EObject)editor).eGet(feature);
            }
        }
        return NOT_AVALAIBLE;
    }

    protected Object getEditorIsOpen(Object editor) {
        if (editor instanceof EObject) {
            IPageManager mngr = null;
            try {
                mngr = (IPageManager)ServiceUtilsForResource.getInstance().getService(IPageManager.class, (Object)((EObject)editor).eResource());
                return mngr.isOpen(editor);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return NOT_AVALAIBLE;
    }

    protected Object getEditorName(Object editor) {
        EObject eobject;
        EStructuralFeature feature;
        if (editor instanceof EObject && (feature = (eobject = (EObject)editor).eClass().getEStructuralFeature("name")) != null) {
            return eobject.eGet(feature);
        }
        return NOT_AVALAIBLE;
    }

    protected Object getEditorContext(Object editor) {
        Object result = Utils.getEditorContext(editor);
        if (result == null) {
            return NOT_AVALAIBLE;
        }
        return result;
    }
}

