/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.cell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.IGenericMatrixRelationshipCellManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.IUnsetValueCellManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.StringResolutionProblemWrapperCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;

public final class CellManagerFactory {
    private static final String CLASS_MANAGER = "manager";
    private static final String ORDER = "order";
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.cellmanager";
    public static final String CELL_MANAGER_NOT_FOUND = Messages.CellManagerFactory_CellManagerNotFound;
    private final Map<Integer, Collection<ICellManager>> managersMap = new TreeMap<Integer, Collection<ICellManager>>();
    private final List<IGenericMatrixRelationshipCellManager> matrixManagers = new ArrayList<IGenericMatrixRelationshipCellManager>();
    public static final CellManagerFactory INSTANCE = new CellManagerFactory();

    private CellManagerFactory() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            Integer order = new Integer(iConfigurationElement.getAttribute(ORDER));
            try {
                ICellManager solver = (ICellManager)iConfigurationElement.createExecutableExtension(CLASS_MANAGER);
                if (!this.managersMap.containsKey(order)) {
                    this.managersMap.put(order, new HashSet());
                }
                if (solver instanceof IGenericMatrixRelationshipCellManager) {
                    this.matrixManagers.add((IGenericMatrixRelationshipCellManager)solver);
                }
                this.managersMap.get(order).add(new StringResolutionProblemWrapperCellManager(solver));
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
    }

    public Object getCrossValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager != null) {
            return cellManager.getValue(columnElement, rowElement, tableManager);
        }
        return CELL_MANAGER_NOT_FOUND;
    }

    public Object getCrossValueIgnoringProblems(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager != null) {
            return ((StringResolutionProblemWrapperCellManager)cellManager).getValueIgnoringCellProblem(columnElement, rowElement, tableManager);
        }
        return CELL_MANAGER_NOT_FOUND;
    }

    private ICellManager getCellManager(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        ICellManager result = null;
        Iterator<Integer> orders = this.managersMap.keySet().iterator();
        while (orders.hasNext() && result == null) {
            Integer integer = orders.next();
            Iterator<ICellManager> cellManagers = this.managersMap.get(integer).iterator();
            while (cellManagers.hasNext() && result == null) {
                ICellManager current = cellManagers.next();
                if (!current.handles(columnElement, rowElement, tableManager)) continue;
                result = current;
            }
        }
        return result;
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager != null) {
            return cellManager.isCellEditable(columnElement, rowElement, tableManager);
        }
        return false;
    }

    public void setCellValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager == null) {
            throw new UnsupportedOperationException(CELL_MANAGER_NOT_FOUND);
        }
        cellManager.setValue(domain, columnElement, rowElement, newValue, tableManager);
    }

    public Command getSetStringValueCommand(TransactionalEditingDomain editingDomain, Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter stringResolvers, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager != null) {
            return cellManager.getSetStringValueCommand(editingDomain, columnElement, rowElement, valueAsString, stringResolvers, tableManager);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public AbstractStringValueConverter getOrCreateStringValueConverterClass(Object columnElement, Object rowElement, Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager != null) {
            return cellManager.getOrCreateStringValueConverterClass(existingConverters, multiValueSeparator, tableManager);
        }
        return null;
    }

    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueConverter, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager == null) {
            throw new UnsupportedOperationException(CELL_MANAGER_NOT_FOUND);
        }
        cellManager.setStringValue(columnElement, rowElement, valueAsString, valueConverter, sharedMap, tableManager);
    }

    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager != null) {
            return cellManager.isCellEditable(columnElement, rowElement, sharedMap, tableManager);
        }
        return false;
    }

    public Command getSetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager != null) {
            return cellManager.getSetValueCommand(domain, columnElement, rowElement, newValue, tableManager);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public final Collection<?> getCrossValueAsCollection(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        Object value = INSTANCE.getCrossValue(columnElement, rowElement, tableManager);
        Collection<Object> collection = Collections.emptyList();
        if (value instanceof Collection) {
            collection = (Collection)value;
        } else if (value instanceof Object[]) {
            collection = Arrays.asList(value);
        } else if (value != null) {
            collection = Collections.singletonList(value);
        }
        return collection;
    }

    public final void unsetCellValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager instanceof IUnsetValueCellManager) {
            ((IUnsetValueCellManager)cellManager).unsetCellValue(domain, columnElement, rowElement, tableManager);
        }
    }

    public final Command getUnsetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        ICellManager cellManager = this.getCellManager(columnElement, rowElement, tableManager);
        if (cellManager instanceof IUnsetValueCellManager) {
            return ((IUnsetValueCellManager)cellManager).getUnsetCellValueCommand(domain, columnElement, rowElement, tableManager);
        }
        return null;
    }

    public List<IGenericMatrixRelationshipCellManager> getRegisteredGenericMatrixRelationshipCellManager() {
        return this.matrixManagers;
    }
}

