/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TreeList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllColumnsCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.resize.action.VerticalResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.ClientAreaAdapter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.SliderScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.clientarea.ClientAreaResizeDragMode;
import org.eclipse.papyrus.infra.nattable.clientarea.ClientAreaResizeMatcher;
import org.eclipse.papyrus.infra.nattable.configuration.TreeTableClickSortConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.TreeTablePopupMenuConfiguration;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderHierarchicalLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderLayerStack;
import org.eclipse.papyrus.infra.nattable.listener.HideShowCategoriesTableListener;
import org.eclipse.papyrus.infra.nattable.manager.axis.AxisManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.axis.CompositeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.CompositeTreeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.ITreeItemAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.table.ITreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.selection.ObjectsSelectionExtractor;
import org.eclipse.papyrus.infra.nattable.tree.CollapseAndExpandActionsEnum;
import org.eclipse.papyrus.infra.nattable.tree.DatumExpansionModel;
import org.eclipse.papyrus.infra.nattable.tree.DatumTreeFormat;
import org.eclipse.papyrus.infra.nattable.utils.CollapseExpandActionHelper;
import org.eclipse.papyrus.infra.nattable.utils.DefaultSizeUtils;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.ui.util.EclipseCommandUtils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;

public class TreeNattableModelManager
extends NattableModelManager
implements ITreeNattableModelManager {
    protected TreeList treeList;
    protected DatumTreeFormat treeFormat;
    protected DatumExpansionModel expansionModel;
    private static final int scrollbarHeight = 17;
    protected ResourceSetListener hideShowCategoriesListener;

    public TreeNattableModelManager(Table rawModel, ISelectionExtractor selectionExtractor) {
        this(rawModel, selectionExtractor, true);
    }

    public TreeNattableModelManager(Table rawModel, ISelectionExtractor selectionExtractor, boolean initializeListeners) {
        super(rawModel, selectionExtractor, initializeListeners);
        Assert.isTrue((boolean)TableHelper.isTreeTable(rawModel));
        rawModel.eAdapters().remove((Object)this.changeAxisProvider);
        this.changeAxisProvider = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (NattablePackage.eINSTANCE.getTable_CurrentColumnAxisProvider() == msg.getFeature() && msg.getNewValue() != null && !msg.getNewValue().equals(msg.getOldValue())) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TreeNattableModelManager.this.init();
                            TreeNattableModelManager.this.refreshNatTable();
                        }
                    });
                }
            }
        };
        rawModel.eAdapters().add((Object)this.changeAxisProvider);
    }

    public TreeNattableModelManager(Table rawModel) {
        this(rawModel, new ObjectsSelectionExtractor());
    }

    @Override
    protected void registerPopupMenuConfiguration(NatTable natTable) {
        natTable.addConfiguration((IConfiguration)new TreeTablePopupMenuConfiguration(natTable));
    }

    @Override
    protected List<Object> createHorizontalElementList() {
        EventList eventList = GlazedLists.eventList(new ArrayList());
        this.basicHorizontalList = eventList = GlazedLists.threadSafeList((EventList)eventList);
        this.rowSortedList = new SortedList(this.basicHorizontalList, null);
        this.treeFormat = new DatumTreeFormat(this.getRowSortModel());
        this.expansionModel = new DatumExpansionModel();
        this.horizontalFilterList = new FilterList((EventList)this.rowSortedList);
        this.treeList = new TreeList((EventList)this.horizontalFilterList, (TreeList.Format)this.treeFormat, (TreeList.ExpansionModel)this.expansionModel);
        return this.treeList;
    }

    @Override
    public TreeList getTreeList() {
        return this.treeList;
    }

    @Override
    public NatTable createNattable(Composite parent, int style, IWorkbenchPartSite site) {
        Table table;
        BooleanValueStyle expandAll;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        NatTable nattable = super.createNattable(composite, style, site);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.natTable.setLayoutData((Object)gridData);
        this.createSplitSliders(composite, this.getRowHeaderLayerStack().getViewportLayer(), this.getBodyLayerStack().getViewportLayer());
        int leftWidth = this.getWidthSliderComposite();
        ClientAreaAdapter leftClientAreaAdapter = new ClientAreaAdapter(this.getRowHeaderLayerStack().getViewportLayer().getClientAreaProvider());
        leftClientAreaAdapter.setWidth(leftWidth);
        this.getRowHeaderLayerStack().getViewportLayer().setClientAreaProvider((IClientAreaProvider)leftClientAreaAdapter);
        this.getRowHeaderLayerStack().getViewportLayer().setVerticalScrollbarEnabled(false);
        this.filterColumnHeaderComposite.setLayerPainter((ILayerPainter)new CellLayerPainter(true, false));
        this.natTable.addOverlayPainter(new IOverlayPainter(){

            public void paintOverlay(GC gc, ILayer layer) {
                Color beforeColor = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_GRAY);
                int viewportBorderX = TreeNattableModelManager.this.getRowHeaderLayerStack().getWidth() - 1;
                gc.drawLine(viewportBorderX, 0, viewportBorderX, layer.getHeight() - 1);
                gc.setForeground(beforeColor);
            }
        });
        this.natTable.getUiBindingRegistry().registerFirstMouseMoveBinding((IMouseEventMatcher)new ClientAreaResizeMatcher((ILayer)this.getRowHeaderLayerStack()), (IMouseAction)new VerticalResizeCursorAction());
        this.natTable.getUiBindingRegistry().registerFirstMouseDragMode((IMouseEventMatcher)new ClientAreaResizeMatcher((ILayer)this.getRowHeaderLayerStack()), (IDragMode)new ClientAreaResizeDragMode((ILayer)this.getRowHeaderLayerStack().getIndexRowHeaderLayer(), (ILayer)this.getRowHeaderLayerStack().getTreeLayer(), leftClientAreaAdapter, this.getRowHeaderLayerStack().getViewportLayer(), this.getBodyLayerStack().getViewportLayer()));
        List<Integer> hiddenDepth = StyleUtils.getHiddenDepths(this);
        if (hiddenDepth.size() > 0) {
            this.hideShowCategories(hiddenDepth, null);
        }
        this.hideShowCategoriesListener = new HideShowCategoriesTableListener(this);
        if (this.getTableEditingDomain() != null) {
            this.getTableEditingDomain().addResourceSetListener(this.hideShowCategoriesListener);
        }
        if (StyleUtils.hasAppliedFilter(this)) {
            this.doCollapseExpandAction(CollapseAndExpandActionsEnum.EXPAND_ALL, null);
        }
        if ((expandAll = (BooleanValueStyle)(table = this.getTable()).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "expandAll")) == null) {
            TableConfiguration config = table.getTableConfiguration();
            expandAll = (BooleanValueStyle)config.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "expandAll");
        }
        if (expandAll != null && expandAll.isBooleanValue()) {
            this.doCollapseExpandAction(CollapseAndExpandActionsEnum.EXPAND_ALL, null);
        }
        return nattable;
    }

    protected int getWidthSliderComposite() {
        int result = 0;
        IntValueStyle valueRowHeader = (IntValueStyle)this.getTable().getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowHeaderWidth");
        result = valueRowHeader != null ? valueRowHeader.getIntValue() : this.calculateBestWidthSliderComposite();
        return result;
    }

    protected int calculateBestWidthSliderComposite() {
        int result = 0;
        AbstractHeaderAxisConfiguration rowHeader = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisConfigurationUsedInTable(this.getTable());
        IntValueStyle valueFirstRow = (IntValueStyle)rowHeader.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowLabelWidth");
        result = valueFirstRow != null ? (result += valueFirstRow.getIntValue()) : (result += DefaultSizeUtils.getDefaultRowHeaderWidth());
        IntValueStyle valueSecondRow = (IntValueStyle)rowHeader.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowPosition2LabelWidth");
        result = valueSecondRow != null ? (result += valueSecondRow.getIntValue()) : (result += DefaultSizeUtils.getDefaultRowHeaderWidth());
        IntValueStyle valueThirdRow = (IntValueStyle)rowHeader.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowPosition3LabelWidth");
        result = valueThirdRow != null ? (1 == valueThirdRow.getIntValue() % 2 ? (result += valueThirdRow.getIntValue() / 2 + 1) : (result += valueThirdRow.getIntValue() / 2)) : (1 == DefaultSizeUtils.getDefaultRowHeaderWidth() % 2 ? (result += DefaultSizeUtils.getDefaultRowHeaderWidth() / 2 + 1) : (result += DefaultSizeUtils.getDefaultRowHeaderWidth() / 2));
        return result;
    }

    private void createSplitSliders(Composite natTableParent, final ViewportLayer left, ViewportLayer right) {
        Composite sliderComposite = new Composite(natTableParent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 17;
        sliderComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        sliderComposite.setLayout((Layout)gridLayout);
        Composite sliderLeftComposite = new Composite(sliderComposite, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int width = ((ClientAreaAdapter)left.getClientAreaProvider()).getWidth();
                if (TreeNattableModelManager.this.getRowHeaderLayerStack() != null && TreeNattableModelManager.this.getRowHeaderLayerStack().getIndexRowHeaderLayer() != null) {
                    width += TreeNattableModelManager.this.getRowHeaderLayerStack().getIndexRowHeaderLayer().getWidth();
                }
                return new Point(width, 17);
            }
        };
        sliderLeftComposite.setLayout((Layout)new FillLayout());
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        sliderLeftComposite.setLayoutData((Object)gridData);
        this.addControlListener(sliderLeftComposite);
        Slider sliderLeft = new Slider(sliderLeftComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        sliderLeft.setLayoutData((Object)gridData);
        left.setHorizontalScroller((IScroller)new SliderScroller(sliderLeft));
        Slider sliderRight = new Slider(sliderComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        sliderRight.setLayoutData((Object)gridData);
        right.setHorizontalScroller((IScroller)new SliderScroller(sliderRight));
    }

    protected void addControlListener(Composite leftSliderComposite) {
        leftSliderComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int initialSize;
                if (TreeNattableModelManager.this.natTable == null || TreeNattableModelManager.this.natTable.isDisposed()) {
                    return;
                }
                super.controlResized(e);
                CompositeCommand resizeRowHeaderCommand = new CompositeCommand("Resize Slider composite");
                TransactionalEditingDomain tableDomain = TableEditingDomainUtils.getTableEditingDomain(TreeNattableModelManager.this.getTable());
                if (tableDomain == null) {
                    return;
                }
                int newHeaderWidth = TreeNattableModelManager.this.getRowHeaderLayerStack().getViewportLayer().getClientAreaWidth();
                if (newHeaderWidth != (initialSize = TreeNattableModelManager.this.calculateBestWidthSliderComposite())) {
                    IntValueStyle valueIndex = (IntValueStyle)TreeNattableModelManager.this.getTable().getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowHeaderWidth");
                    if (valueIndex != null && valueIndex.getIntValue() != newHeaderWidth) {
                        SetRequest resizeRowHeader = new SetRequest(tableDomain, (EObject)valueIndex, (EStructuralFeature)NattablestylePackage.eINSTANCE.getIntValueStyle_IntValue(), (Object)newHeaderWidth);
                        resizeRowHeaderCommand.add((IUndoableOperation)new SetValueCommand(resizeRowHeader));
                    } else if (valueIndex == null && newHeaderWidth != DefaultSizeUtils.getDefaultRowHeaderWidth()) {
                        valueIndex = NattablestyleFactory.eINSTANCE.createIntValueStyle();
                        valueIndex.setIntValue(newHeaderWidth);
                        valueIndex.setName("rowHeaderWidth");
                        SetRequest initRowHeaderSizeRequest = new SetRequest(tableDomain, (EObject)TreeNattableModelManager.this.getTable(), (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)valueIndex);
                        resizeRowHeaderCommand.add((IUndoableOperation)new SetValueCommand(initRowHeaderSizeRequest));
                    }
                    if (resizeRowHeaderCommand.canExecute() && !resizeRowHeaderCommand.isEmpty()) {
                        tableDomain.getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper((ICommand)resizeRowHeaderCommand));
                    }
                } else {
                    IntValueStyle valueIndex = (IntValueStyle)TreeNattableModelManager.this.getTable().getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowHeaderWidth");
                    if (valueIndex != null) {
                        DestroyElementRequest destroyRowHeaderWidthRequest = new DestroyElementRequest(tableDomain, (EObject)valueIndex, false);
                        new GMFtoEMFCommandWrapper((ICommand)new DestroyElementCommand(destroyRowHeaderWidthRequest)).execute();
                    }
                }
            }
        });
    }

    @Override
    protected void addClickSortConfiguration(NatTable natTable) {
        natTable.addConfiguration((IConfiguration)new TreeTableClickSortConfiguration());
    }

    @Override
    protected void updateToggleActionState() {
        super.updateToggleActionState();
        DisplayStyle style = TableHelper.getTableDisplayStyle(this);
        ICommandService commandService = EclipseCommandUtils.getCommandService();
        if (commandService != null) {
            Command command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.table.hierarchic.style");
            if (!DisplayStyle.NORMAL.equals((Object)style)) {
                this.updateRadioCommandState(command, style.getLiteral());
            }
        }
    }

    @Override
    protected ICompositeAxisManager createAxisManager(List<AxisManagerRepresentation> representations, AbstractAxisProvider contentProvider, boolean columnAxisManager) {
        if (columnAxisManager) {
            return super.createAxisManager(representations, contentProvider, columnAxisManager);
        }
        return this.createTreeAxisManager(representations, contentProvider, columnAxisManager);
    }

    protected ICompositeAxisManager createTreeAxisManager(List<AxisManagerRepresentation> representations, AbstractAxisProvider contentProvider, boolean columnAxisManager) {
        CompositeTreeAxisManagerForEventList compositeAxisManager = new CompositeTreeAxisManagerForEventList((EventList<Object>)this.horizontalFilterList);
        ArrayList<IAxisManagerForEventList> managers = new ArrayList<IAxisManagerForEventList>();
        for (AxisManagerRepresentation current : representations) {
            IAxisManager manager = AxisManagerFactory.INSTANCE.getAxisManager(current);
            Assert.isTrue((boolean)(manager instanceof IAxisManagerForEventList));
            manager.init(this, current, contentProvider);
            managers.add((IAxisManagerForEventList)manager);
        }
        compositeAxisManager.init(this, null, contentProvider);
        DatumTreeFormat treeFormat = this.getTreeFormat();
        treeFormat.setTreeComparatorProvider(compositeAxisManager);
        this.expansionModel.setAxisManager(compositeAxisManager);
        ((CompositeAxisManagerForEventList)compositeAxisManager).setSubManagers(managers);
        return compositeAxisManager;
    }

    @Override
    public DatumTreeFormat getTreeFormat() {
        return this.treeFormat;
    }

    @Override
    public int getTreeItemDepth(ITreeItemAxis axis) {
        DatumTreeFormat format = this.getTreeFormat();
        if (format != null) {
            ArrayList path = new ArrayList();
            format.getPath(path, axis);
            return path.size() - 1;
        }
        return 0;
    }

    @Override
    public int getSemanticDepth(ITreeItemAxis axis) {
        Object representedObject = axis.getElement();
        if (representedObject instanceof TreeFillingConfiguration) {
            return ((TreeFillingConfiguration)representedObject).getDepth();
        }
        ITreeItemAxis parent = axis.getParent();
        if (parent == null) {
            return 0;
        }
        representedObject = parent.getElement();
        Assert.isTrue((boolean)(representedObject instanceof TreeFillingConfiguration));
        return ((TreeFillingConfiguration)representedObject).getDepth();
    }

    @Override
    public void hideShowCategories(List<Integer> depthToHide, List<Integer> depthToShow) {
        this.hideShowRowCategories(depthToHide, depthToShow);
        this.hideShowColumnCategoriesInRowHeader(depthToHide, depthToShow);
    }

    @Override
    public void hideShowRowCategories(List<Integer> depthToHide, List<Integer> depthToShow) {
        ((ITreeItemAxisManagerForEventList)this.getRowAxisManager()).managedHideShowCategoriesForDepth(depthToHide, depthToShow);
    }

    @Override
    public void hideShowColumnCategoriesInRowHeader(List<Integer> depthToHide, List<Integer> depthToShow) {
        this.natTable.refresh();
        RowHeaderHierarchicalLayerStack rowHeaderLayerStack = this.getRowHeaderLayerStack();
        if (rowHeaderLayerStack instanceof RowHeaderHierarchicalLayerStack) {
            ColumnHideShowLayer layer = rowHeaderLayerStack.getRowHeaderColumnHideShowLayer();
            ILayer subLayer = layer.getUnderlyingLayerByPosition(0, 0);
            if (TableHelper.isMultiColumnTreeTable(this)) {
                int tmp;
                Integer curr;
                int i;
                boolean hasRootConfif = FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), 0);
                if (depthToHide != null && depthToHide.size() > 0) {
                    int[] indexToHide = new int[depthToHide.size()];
                    i = 0;
                    while (i < depthToHide.size()) {
                        curr = depthToHide.get(i);
                        tmp = -1;
                        tmp = hasRootConfif ? curr * 2 : curr * 2 - 1;
                        indexToHide[i] = tmp = layer.underlyingToLocalColumnPosition(subLayer, tmp);
                        ++i;
                    }
                    layer.doCommand((ILayerCommand)new MultiColumnHideCommand((ILayer)layer, indexToHide));
                }
                if (depthToShow != null && depthToShow.size() > 0) {
                    ArrayList<Integer> indexToShow = new ArrayList<Integer>();
                    i = 0;
                    while (i < depthToShow.size()) {
                        curr = depthToShow.get(i);
                        tmp = -1;
                        tmp = hasRootConfif ? curr * 2 : curr * 2 - 1;
                        indexToShow.add(tmp);
                        ++i;
                    }
                    layer.doCommand((ILayerCommand)new MultiColumnShowCommand(indexToShow));
                }
            } else {
                layer.doCommand((ILayerCommand)new ShowAllColumnsCommand());
            }
        }
    }

    @Override
    protected RowHeaderLayerStack createRowHeaderLayerStack(BodyLayerStack bodyLayerStack) {
        return new RowHeaderHierarchicalLayerStack(bodyLayerStack, this);
    }

    @Override
    public RowHeaderHierarchicalLayerStack getRowHeaderLayerStack() {
        return (RowHeaderHierarchicalLayerStack)super.getRowHeaderLayerStack();
    }

    @Override
    public void doCollapseExpandAction(CollapseAndExpandActionsEnum actionId, List<ITreeItemAxis> selectedAxis) {
        CollapseExpandActionHelper.doCollapseExpandAction(actionId, selectedAxis, this.getTableAxisElementProvider(), this.natTable);
    }

    @Override
    protected Adapter createInvertAxisListener() {
        return null;
    }

    private void modifyAcisDeliver(List<IAxis> iAxis) {
        for (IAxis axis : iAxis) {
            if (!(axis instanceof ITreeItemAxis)) continue;
            boolean isDelivering = axis.eDeliver();
            if (isDelivering) {
                axis.eSetDeliver(false);
            }
            ((ITreeItemAxis)axis).getChildren().clear();
            if (!isDelivering) continue;
            axis.eSetDeliver(true);
        }
    }

    @Override
    public void dispose() {
        EList iAxis;
        if (this.getTableEditingDomain() != null && this.hideShowCategoriesListener != null) {
            this.getTableEditingDomain().removeResourceSetListener(this.hideShowCategoriesListener);
            this.hideShowCategoriesListener = null;
        }
        if ((iAxis = this.getHorizontalAxisProvider() == null ? null : this.getHorizontalAxisProvider().getAxis()) != null && !iAxis.isEmpty()) {
            Runnable runnable = new Runnable((List)iAxis){
                private final /* synthetic */ List val$iAxis;
                {
                    this.val$iAxis = list;
                }

                @Override
                public void run() {
                    TreeNattableModelManager.this.modifyAcisDeliver(this.val$iAxis);
                }
            };
            try {
                if (this.getTableEditingDomain() != null) {
                    GMFUnsafe.write((TransactionalEditingDomain)this.getTableEditingDomain(), (Runnable)runnable);
                } else {
                    this.modifyAcisDeliver((List<IAxis>)iAxis);
                }
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
            catch (RollbackException e) {
                Activator.log.error((Throwable)e);
            }
        }
        if (this.getTableEditingDomain() != null && this.hideShowCategoriesListener != null) {
            this.getTableEditingDomain().removeResourceSetListener(this.hideShowCategoriesListener);
        }
        super.dispose();
    }
}

