/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.nattable.utils.TypeSelectionEnum;

public class PastePropertyTester
extends PropertyTester {
    private static final String CAN_PASTE_PROPERTY = "canPaste";
    private static final String CAN_INSERT_PROPERTY = "canInsert";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        TypeSelectionEnum typeSelection = TypeSelectionEnum.NONE;
        if (1 == args.length) {
            typeSelection = TypeSelectionEnum.getTypeSelection(args[0].toString());
        }
        if (CAN_PASTE_PROPERTY.equals(property)) {
            if (receiver instanceof TableStructuredSelection) {
                TableStructuredSelection selection = (TableStructuredSelection)((Object)receiver);
                TableSelectionWrapper tableSelectionWrapper = (TableSelectionWrapper)selection.getAdapter(TableSelectionWrapper.class);
                if (tableSelectionWrapper != null) {
                    TypeSelectionEnum typeSelectionFromWrapper = this.getTypeSelection(tableSelectionWrapper);
                    result = false;
                    if (TypeSelectionEnum.CELL.equals((Object)typeSelection)) {
                        if (TypeSelectionEnum.NONE.equals((Object)typeSelectionFromWrapper)) {
                            result = true;
                        } else if (TypeSelectionEnum.CELL.equals((Object)typeSelectionFromWrapper)) {
                            result = tableSelectionWrapper.getFullySelectedColumns().isEmpty() && tableSelectionWrapper.getFullySelectedRows().isEmpty() && !tableSelectionWrapper.getSelectedCells().isEmpty() && tableSelectionWrapper.isContinuousCells();
                        }
                    } else if (TypeSelectionEnum.ROW.equals((Object)typeSelection) && TypeSelectionEnum.ROW.equals((Object)typeSelectionFromWrapper)) {
                        result = tableSelectionWrapper.getFullySelectedColumns().isEmpty() && !tableSelectionWrapper.getFullySelectedRows().isEmpty() && !tableSelectionWrapper.isCellsOutsideOfAxis() && tableSelectionWrapper.isContinuousRows();
                    } else if (TypeSelectionEnum.COLUMN.equals((Object)typeSelection) && TypeSelectionEnum.COLUMN.equals((Object)typeSelectionFromWrapper)) {
                        result = !tableSelectionWrapper.getFullySelectedColumns().isEmpty() && tableSelectionWrapper.getFullySelectedRows().isEmpty() && !tableSelectionWrapper.isCellsOutsideOfAxis() && tableSelectionWrapper.isContinuousColumns();
                    }
                }
            } else if (receiver instanceof StructuredSelection && ((StructuredSelection)receiver).isEmpty()) {
                result = true;
            }
        } else if (CAN_INSERT_PROPERTY.equals(property)) {
            if (receiver instanceof TableStructuredSelection) {
                TableStructuredSelection selection = (TableStructuredSelection)((Object)receiver);
                TableSelectionWrapper tableSelectionWrapper = (TableSelectionWrapper)selection.getAdapter(TableSelectionWrapper.class);
                if (tableSelectionWrapper != null) {
                    TypeSelectionEnum typeSelectionFromWrapper = this.getTypeSelection(tableSelectionWrapper);
                    result = false;
                    if (TypeSelectionEnum.ROW.equals((Object)typeSelection) && TypeSelectionEnum.ROW.equals((Object)typeSelectionFromWrapper)) {
                        result = tableSelectionWrapper.getFullySelectedColumns().isEmpty() && !tableSelectionWrapper.getFullySelectedRows().isEmpty() && !tableSelectionWrapper.isCellsOutsideOfAxis() && tableSelectionWrapper.isContinuousRows();
                    }
                }
            } else if (receiver instanceof StructuredSelection && ((StructuredSelection)receiver).isEmpty()) {
                result = true;
            }
        }
        return result;
    }

    protected TypeSelectionEnum getTypeSelection(TableSelectionWrapper tableSelectionWrapper) {
        TypeSelectionEnum result = TypeSelectionEnum.NONE;
        if (!tableSelectionWrapper.getFullySelectedRows().isEmpty() && tableSelectionWrapper.getFullySelectedColumns().isEmpty()) {
            result = TypeSelectionEnum.ROW;
        } else if (tableSelectionWrapper.getFullySelectedRows().isEmpty() && !tableSelectionWrapper.getFullySelectedColumns().isEmpty()) {
            result = TypeSelectionEnum.COLUMN;
        } else if (tableSelectionWrapper.getFullySelectedRows().isEmpty() && tableSelectionWrapper.getFullySelectedColumns().isEmpty() && !tableSelectionWrapper.getSelectedCells().isEmpty()) {
            result = TypeSelectionEnum.CELL;
        }
        return result;
    }
}

