/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.BundleIconExplorerDialog;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class IconValueEditor
extends StringEditor {
    private static final String BROWSE_ICON = "/icons/browse_12x12.gif";
    private Button button = null;

    public IconValueEditor(Composite parent, int style) {
        super(parent, style);
        ++((GridLayout)this.getLayout()).numColumns;
        this.button = factory.createButton((Composite)this, null, 8);
        this.button.setImage(Activator.getDefault().getImage(BROWSE_ICON));
        this.button.setToolTipText(Messages.ReferenceDialog_EditValue);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IconValueEditor.this.handleManageBrowseButtonPressed();
            }
        });
    }

    protected void handleManageBrowseButtonPressed() {
        BundleIconExplorerDialog dialog = new BundleIconExplorerDialog(this.getParent().getShell(), this.getText().getText());
        if (dialog.open() == 0) {
            Object[] values = dialog.getResult();
            if (1 != values.length) {
                String message = String.valueOf(Messages.IconValueEditor_WaitingOneIconButFound) + values.length;
                Activator.getDefault();
                Activator.log.error(message, null);
                Status status = new Status(4, "org.eclipse.papyrus.infra.widgets", message);
                this.updateStatus((IStatus)status);
            } else {
                this.setValue(values[0].toString());
                this.notifyChange();
            }
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.button.setEnabled(!readOnly);
    }
}

