/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.util.SelectInDiagramHelper;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.LineMode;
import org.eclipse.papyrus.uml.diagram.sequence.CustomMessages;
import org.eclipse.papyrus.uml.diagram.sequence.draw2d.routers.MessageRouter;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageAsyncEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageFoundEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageLostEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageSyncEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.MessageCreate;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageCreateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class MessageConnectionLineSegEditPolicy
extends ConnectionBendpointEditPolicy {
    private static final String MOVE_LINE_ORIENTATION_DATA = "Move line orientation";
    private static final String MOVED_UP = "Moved Up";
    private static final String MOVED_DOWN = "Moved Down";
    private static final String MOVED_HORIZONTAL = "Moved Horizontal";
    private ConnectionRouter router;

    public MessageConnectionLineSegEditPolicy() {
        super(LineMode.ORTHOGONAL_FREE);
    }

    protected List createManualHandles() {
        MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
        if (kind == MessageRouter.RouterKind.SELF || kind == MessageRouter.RouterKind.HORIZONTAL || this.getConnection() instanceof MessageCreate) {
            return Collections.emptyList();
        }
        return super.createManualHandles();
    }

    public Command getCommand(Request request) {
        MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
        if (kind == MessageRouter.RouterKind.SELF || kind == MessageRouter.RouterKind.HORIZONTAL || this.getConnection() instanceof MessageCreate) {
            return super.getCommand(request);
        }
        if (request instanceof BendpointRequest) {
            return this.getMoveMessageCommand((BendpointRequest)request);
        }
        return null;
    }

    protected Command getMoveMessageCommand(BendpointRequest request) {
        if (this.getHost() instanceof MessageLostEditPart || this.getHost() instanceof MessageFoundEditPart) {
            PointList points = this.getConnection().getPoints().getCopy();
            CompoundCommand command = new CompoundCommand("Move");
            AbstractMessageEditPart MessageSyncEditPart2 = (AbstractMessageEditPart)this.getHost();
            ReconnectRequest sourceReq = new ReconnectRequest((Object)"Reconnection source");
            sourceReq.setConnectionEditPart((ConnectionEditPart)MessageSyncEditPart2);
            Point sourceLocation = points.getFirstPoint().getCopy();
            this.getConnection().translateToAbsolute((Translatable)sourceLocation);
            EditPart source = MessageSyncEditPart2.getSource();
            sourceReq.setLocation(sourceLocation);
            sourceReq.setTargetEditPart(source);
            Command moveSourceCommand = source.getCommand((Request)sourceReq);
            command.add(moveSourceCommand);
            EditPart target = MessageSyncEditPart2.getTarget();
            ReconnectRequest targetReq = new ReconnectRequest((Object)"Reconnection target");
            targetReq.setConnectionEditPart((ConnectionEditPart)MessageSyncEditPart2);
            Point targetLocation = points.getLastPoint().getCopy();
            this.getConnection().translateToAbsolute((Translatable)targetLocation);
            targetReq.setLocation(targetLocation);
            targetReq.setTargetEditPart(target);
            Command moveTargetCommand = target.getCommand((Request)targetReq);
            command.add(moveTargetCommand);
            return command.unwrap();
        }
        return null;
    }

    protected Command getBendpointsChangedCommand(BendpointRequest request) {
        ConnectionNodeEditPart connectionPart;
        EObject message;
        if (this.getHost().getViewer() instanceof ScrollingGraphicalViewer && this.getHost().getViewer().getControl() instanceof FigureCanvas) {
            SelectInDiagramHelper.exposeLocation((FigureCanvas)((FigureCanvas)this.getHost().getViewer().getControl()), (Point)request.getLocation().getCopy());
        }
        if (this.getHost() instanceof ConnectionNodeEditPart && (message = (connectionPart = (ConnectionNodeEditPart)this.getHost()).resolveSemanticElement()) instanceof Message) {
            MessageEnd send = ((Message)message).getSendEvent();
            MessageEnd rcv = ((Message)message).getReceiveEvent();
            EditPart srcPart = connectionPart.getSource();
            LifelineEditPart srcLifelinePart = SequenceUtil.getParentLifelinePart(srcPart);
            EditPart tgtPart = connectionPart.getTarget();
            LifelineEditPart tgtLifelinePart = SequenceUtil.getParentLifelinePart(tgtPart);
            if (srcLifelinePart != null && tgtLifelinePart != null) {
                MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
                if ((this.getHost() instanceof MessageSyncEditPart || this.getHost() instanceof MessageAsyncEditPart) && kind == MessageRouter.RouterKind.SELF) {
                    return this.getSelfLinkMoveCommand(request, connectionPart, send, rcv, srcLifelinePart);
                }
                if (this.getHost() instanceof MessageCreateEditPart) {
                    RectangleFigure fig = tgtLifelinePart.getPrimaryShape().getFigureLifelineNameContainerFigure();
                    Rectangle bounds = fig.getBounds().getCopy();
                    fig.translateToAbsolute((Translatable)bounds);
                    PointList points = this.getConnection().getPoints();
                    Point sourceRefPoint = points.getFirstPoint().getCopy();
                    this.getConnection().translateToAbsolute((Translatable)sourceRefPoint);
                    int dy = sourceRefPoint.y - bounds.getCenter().y;
                    Point location = tgtLifelinePart.getFigure().getBounds().getLocation().getCopy().translate(0, dy);
                    ICommandProxy moveCmd = new ICommandProxy((ICommand)new SetBoundsCommand(tgtLifelinePart.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)tgtLifelinePart.getNotationView()), location));
                    if (dy < 0) {
                        return LifelineMessageCreateHelper.moveCascadeLifeline(tgtLifelinePart, (Command)moveCmd, dy);
                    }
                    Command cmd = LifelineMessageCreateHelper.moveCascadeLifeline(tgtLifelinePart, null, dy);
                    cmd = cmd == null ? moveCmd : cmd.chain((Command)moveCmd);
                    return cmd;
                }
                int y = request.getLocation().y;
                Command srcCmd = this.createMoveMessageEndCommand((Message)message, srcPart, send, y, srcLifelinePart);
                Command tgtCmd = this.createMoveMessageEndCommand((Message)message, tgtPart, rcv, y, tgtLifelinePart);
                CompoundCommand compoudCmd = new CompoundCommand(CustomMessages.MoveMessageCommand_Label);
                Point oldLocation = SequenceUtil.getAbsoluteEdgeExtremity(connectionPart, true);
                if (oldLocation != null) {
                    int oldY = oldLocation.y;
                    if (oldY < y) {
                        compoudCmd.add(tgtCmd);
                        compoudCmd.add(srcCmd);
                    } else {
                        compoudCmd.add(srcCmd);
                        compoudCmd.add(tgtCmd);
                    }
                    return compoudCmd;
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createMoveMessageEndCommand(Message message, EditPart endEditPart, MessageEnd end, int yLocation, LifelineEditPart lifeline) {
        if (end instanceof OccurrenceSpecification) {
            List<EditPart> empty = Collections.emptyList();
            return OccurrenceSpecificationMoveHelper.getMoveOccurrenceSpecificationsCommand((OccurrenceSpecification)end, null, yLocation, -1, lifeline, empty);
        }
        if (end instanceof Gate) {
            boolean isSource = end == message.getSendEvent();
            ConnectionNodeEditPart connection = (ConnectionNodeEditPart)this.getHost();
            if (isSource) {
                ReconnectRequest req = new ReconnectRequest((Object)"Reconnection source");
                req.setConnectionEditPart((ConnectionEditPart)connection);
                req.setTargetEditPart(endEditPart);
                Point location = SequenceUtil.getAbsoluteEdgeExtremity(connection, true);
                location.setY(yLocation);
                req.setLocation(location);
                Command command = endEditPart.getCommand((Request)req);
                return command;
            }
            ReconnectRequest req = new ReconnectRequest((Object)"Reconnection target");
            req.setConnectionEditPart((ConnectionEditPart)connection);
            req.setTargetEditPart(endEditPart);
            Point location = SequenceUtil.getAbsoluteEdgeExtremity(connection, false);
            location.setY(yLocation);
            req.setLocation(location);
            Command command = endEditPart.getCommand((Request)req);
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getSelfLinkMoveCommand(BendpointRequest request, ConnectionNodeEditPart connectionPart, MessageEnd send, MessageEnd rcv, LifelineEditPart srcLifelinePart) {
        Object moveData = request.getExtendedData().get(MOVE_LINE_ORIENTATION_DATA);
        CompoundCommand compoudCmd = new CompoundCommand(CustomMessages.MoveMessageCommand_Label);
        compoudCmd.add(super.getBendpointsChangedCommand(request));
        PointList points = this.getConnection().getPoints();
        if (MOVED_UP.equals(moveData)) {
            Point sourceRefPoint = points.getFirstPoint();
            this.getConnection().translateToAbsolute((Translatable)sourceRefPoint);
            Command srcCmd = this.getReconnectCommand(connectionPart, connectionPart.getSource(), sourceRefPoint, "Reconnection source");
            compoudCmd.add(srcCmd);
        } else if (MOVED_DOWN.equals(moveData)) {
            Point targetRefPoint = points.getLastPoint();
            this.getConnection().translateToAbsolute((Translatable)targetRefPoint);
            Command tgtCmd = this.getReconnectCommand(connectionPart, connectionPart.getTarget(), targetRefPoint, "Reconnection target");
            compoudCmd.add(tgtCmd);
        }
        return compoudCmd.unwrap();
    }

    protected Command getReconnectCommand(ConnectionNodeEditPart connectionPart, EditPart targetPart, Point location, String requestType) {
        ReconnectRequest reconnReq = new ReconnectRequest();
        reconnReq.setConnectionEditPart((ConnectionEditPart)connectionPart);
        reconnReq.setLocation(location);
        reconnReq.setTargetEditPart(targetPart);
        reconnReq.setType((Object)requestType);
        reconnReq.getExtendedData().put("Do not move these edit parts", true);
        Command cmd = targetPart.getCommand((Request)reconnReq);
        return cmd;
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof BendpointRequest) {
            MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
            if (kind == MessageRouter.RouterKind.SELF || kind == MessageRouter.RouterKind.HORIZONTAL || this.getConnection() instanceof MessageCreate) {
                if (this.getLineSegMode() != LineMode.OBLIQUE && "move bendpoint".equals(request.getType())) {
                    List constraint = (List)this.getConnection().getRoutingConstraint();
                    if (constraint.size() > 2) {
                        super.showSourceFeedback(request);
                    }
                } else {
                    super.showSourceFeedback(request);
                }
                if (this.getLineSegMode() != LineMode.OBLIQUE && "move bendpoint".equals(request.getType())) {
                    this.showMoveLineSegFeedback((BendpointRequest)request);
                }
            } else if (this.getHost() instanceof MessageFoundEditPart || this.getHost() instanceof MessageLostEditPart) {
                this.showMoveLineSegFeedback((BendpointRequest)request);
            }
        }
    }

    protected void showMoveLineSegFeedback(BendpointRequest request) {
        MessageRouter.RouterKind kind = MessageRouter.RouterKind.getKind(this.getConnection(), this.getConnection().getPoints());
        if ((this.getHost() instanceof MessageSyncEditPart || this.getHost() instanceof MessageAsyncEditPart) && kind == MessageRouter.RouterKind.SELF) {
            if (this.router == null) {
                this.router = this.getConnection().getConnectionRouter();
                this.getConnection().setConnectionRouter((ConnectionRouter)new DummyRouter());
            }
            PointList linkPoints = this.getConnection().getPoints().getCopy();
            Point ptLoc = new Point(request.getLocation());
            this.getConnection().translateToRelative((Translatable)ptLoc);
            int dy = 0;
            int dx = 0;
            int from = 0;
            int to = 0;
            int index = request.getIndex();
            if (index == 0) {
                dy = ptLoc.y - linkPoints.getFirstPoint().y;
                from = 0;
                to = 1;
                request.getExtendedData().put(MOVE_LINE_ORIENTATION_DATA, MOVED_UP);
            } else if (index == 1) {
                dx = ptLoc.x - linkPoints.getMidpoint().x;
                from = 1;
                to = 2;
                request.getExtendedData().put(MOVE_LINE_ORIENTATION_DATA, MOVED_HORIZONTAL);
            } else if (index == 2) {
                dy = ptLoc.y - linkPoints.getLastPoint().y;
                from = 2;
                to = 3;
                request.getExtendedData().put(MOVE_LINE_ORIENTATION_DATA, MOVED_DOWN);
            }
            if (this.getHost() instanceof MessageSyncEditPart && index > 1) {
                dy = 0;
            }
            int size = linkPoints.size();
            if (from >= 0 && from < size && to >= 0 && to < size && from <= to) {
                int i = from;
                while (i <= to) {
                    Point p = linkPoints.getPoint(i);
                    p.translate(dx, dy);
                    linkPoints.setPoint(p, i);
                    ++i;
                }
            }
            if (this.checkBounds(linkPoints)) {
                this.getConnection().setPoints(linkPoints);
                this.getConnection().getLayoutManager().layout((IFigure)this.getConnection());
            }
            return;
        }
        if (this.getHost() instanceof MessageCreateEditPart || this.getHost() instanceof MessageLostEditPart || this.getHost() instanceof MessageFoundEditPart) {
            if (this.router == null) {
                this.router = this.getConnection().getConnectionRouter();
                this.getConnection().setConnectionRouter((ConnectionRouter)new DummyRouter());
            }
            PointList linkPoints = this.getConnection().getPoints().getCopy();
            Point ptLoc = new Point(request.getLocation());
            this.getConnection().translateToRelative((Translatable)ptLoc);
            int dy = ptLoc.y - linkPoints.getFirstPoint().y;
            int size = linkPoints.size();
            int i = 0;
            while (i < size) {
                Point p = linkPoints.getPoint(i).translate(0, dy);
                linkPoints.setPoint(p, i);
                ++i;
            }
            if (this.checkBounds(linkPoints)) {
                this.getConnection().setPoints(linkPoints);
                this.getConnection().getLayoutManager().layout((IFigure)this.getConnection());
            }
            return;
        }
        super.showMoveLineSegFeedback(request);
    }

    protected boolean checkBounds(PointList linkPoints) {
        if (linkPoints.getFirstPoint().y > linkPoints.getLastPoint().y) {
            return false;
        }
        EditPart sourcePart = ((ConnectionNodeEditPart)this.getHost()).getSource();
        if (sourcePart instanceof LifelineEditPart) {
            LifelineEditPart lep = (LifelineEditPart)sourcePart;
            NodeFigure fig = lep.getPrimaryShape().getFigureLifelineDotLineFigure().getDashLineRectangle();
            Rectangle bounds = fig.getBounds().getCopy();
            fig.translateToAbsolute((Translatable)bounds);
            Rectangle conBounds = linkPoints.getBounds();
            this.getConnection().translateToAbsolute((Translatable)conBounds);
            if (conBounds.y <= bounds.y || conBounds.getBottom().y >= bounds.getBottom().y) {
                return false;
            }
        } else if (sourcePart instanceof AbstractExecutionSpecificationEditPart) {
            AbstractExecutionSpecificationEditPart esep = (AbstractExecutionSpecificationEditPart)sourcePart;
            IFigure fig = esep.getFigure();
            Rectangle bounds = fig.getBounds().getCopy();
            fig.translateToAbsolute((Translatable)bounds);
            Rectangle conBounds = linkPoints.getBounds().getCopy();
            this.getConnection().translateToAbsolute((Translatable)conBounds);
            if (this.getHost() instanceof MessageSyncEditPart ? conBounds.width < 2 || conBounds.height < 2 || conBounds.y <= bounds.y || conBounds.getBottom().y >= bounds.getBottom().y : bounds.intersects(conBounds.getShrinked(1, 1)) || conBounds.width < 2 || conBounds.height < 2 || conBounds.y <= bounds.y || conBounds.getBottom().y >= bounds.getBottom().y) {
                return false;
            }
        }
        return true;
    }

    protected void eraseConnectionFeedback(BendpointRequest request, boolean removeFeedbackFigure) {
        this.getConnection().setVisible(true);
        super.eraseConnectionFeedback(request, removeFeedbackFigure);
        if (this.router != null) {
            this.getConnection().setConnectionRouter(this.router);
        }
        this.router = null;
    }

    static class DummyRouter
    extends AbstractRouter {
        DummyRouter() {
        }

        public void route(Connection conn) {
        }
    }
}

