/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLRelationshipHelper {
    private List<EClass> managedEClasses;

    public UMLRelationshipHelper() {
        ArrayList<EClass> managedEClasses = new ArrayList<EClass>();
        managedEClasses.add(UMLPackage.eINSTANCE.getAbstraction());
        managedEClasses.add(UMLPackage.eINSTANCE.getDependency());
        this.managedEClasses = Collections.unmodifiableList(managedEClasses);
    }

    public List<EClass> getManagedEClass() {
        return this.managedEClasses;
    }

    public boolean canHaveMoreThan2Ends(EClass relationshipEClass) {
        if (UMLPackage.eINSTANCE.getAbstraction() == relationshipEClass) {
            return true;
        }
        return UMLPackage.eINSTANCE.getDependency() == relationshipEClass;
    }

    public boolean isDirectedRelationship(EClass relationshipEClass) {
        if (UMLPackage.eINSTANCE.getAbstraction() == relationshipEClass) {
            return true;
        }
        return UMLPackage.eINSTANCE.getDependency() == relationshipEClass;
    }

    public EStructuralFeature getRelationshipSourceFeature(EClass relationshipEClass) {
        if (UMLPackage.eINSTANCE.getAbstraction() == relationshipEClass) {
            return UMLPackage.eINSTANCE.getDependency_Client();
        }
        if (UMLPackage.eINSTANCE.getDependency() == relationshipEClass) {
            return UMLPackage.eINSTANCE.getDependency_Client();
        }
        return null;
    }

    public EStructuralFeature getRelationshipTargetFeature(EClass relationshipEClass) {
        if (UMLPackage.eINSTANCE.getAbstraction() == relationshipEClass) {
            return UMLPackage.eINSTANCE.getDependency_Supplier();
        }
        if (UMLPackage.eINSTANCE.getDependency() == relationshipEClass) {
            return UMLPackage.eINSTANCE.getDependency_Supplier();
        }
        return null;
    }

    public Collection<? extends Element> getSources(Element relationship) {
        if (relationship instanceof Dependency) {
            return ((Dependency)relationship).getClients();
        }
        return Collections.emptyList();
    }

    public Collection<? extends Element> getTargets(Element relationship) {
        if (relationship instanceof Dependency) {
            return ((Dependency)relationship).getSuppliers();
        }
        return Collections.emptyList();
    }

    public Element getBestOwner(MetamodelTypeConfiguration elementTypeConfiguration, Element source, Element target, Element editorContext) {
        EClass relationshipToCreate = elementTypeConfiguration.getEClass();
        if (UMLPackage.eINSTANCE.getAbstraction() == relationshipToCreate) {
            return source.getOwner();
        }
        if (UMLPackage.eINSTANCE.getDependency() == relationshipToCreate) {
            return source.getOwner();
        }
        return null;
    }

    public Element getBestOwner(ElementTypeConfiguration elementTypeConfiguration, Element source, Element target, Element editorContext) {
        if (elementTypeConfiguration instanceof MetamodelTypeConfiguration) {
            return this.getBestOwner((MetamodelTypeConfiguration)elementTypeConfiguration, source, target, editorContext);
        }
        if (elementTypeConfiguration instanceof SpecializationTypeConfiguration) {
            return this.getBestOwner((SpecializationTypeConfiguration)elementTypeConfiguration, source, target, editorContext);
        }
        return null;
    }

    public Element getBestOwner(SpecializationTypeConfiguration elementTypeConfiguration, Element source, Element target, Element editorContext) {
        return 1 == elementTypeConfiguration.getSpecializedTypes().size() ? this.getBestOwner((ElementTypeConfiguration)elementTypeConfiguration.getSpecializedTypes().get(0), source, target, editorContext) : null;
    }

    public int getNumberOfEnds(Element relationship) {
        return this.getSources(relationship).size() + this.getTargets(relationship).size();
    }
}

