/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.gmf.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.util.CommandUtils;

public class CommandTreeIterator<C>
implements Iterator<C> {
    private final Class<C> type;
    private Iterator<?> current;
    private List<Iterator<?>> iterators = new ArrayList();
    private C preparedNext;

    private CommandTreeIterator(Object root, Class<C> type) {
        this.type = type;
        root = this.unwrap(root);
        if (this.isCompound(root)) {
            this.pushIterator(root);
        } else {
            this.prepareNext(root);
        }
    }

    public static CommandTreeIterator<Command> iterateEMF(Object command) {
        return CommandTreeIterator.iterate(command, Command.class);
    }

    public static CommandTreeIterator<ICommand> iterateGMF(Object command) {
        return CommandTreeIterator.iterate(command, ICommand.class);
    }

    public static CommandTreeIterator<?> iterate(Object command) {
        return CommandTreeIterator.iterate(command, Object.class);
    }

    public static <C> CommandTreeIterator<C> iterate(Object command, Class<C> leafCommandType) {
        return new CommandTreeIterator<C>(command, leafCommandType);
    }

    private boolean prepareNext(Object command) {
        if (this.type.isInstance(command)) {
            this.preparedNext = this.type.cast(command);
        }
        return this.preparedNext != null;
    }

    private Iterator<?> pushIterator(Object compoundCommand) {
        if (this.current != null) {
            this.iterators.add(this.current);
        }
        this.current = this.iterator(compoundCommand);
        return this.current;
    }

    private Iterator<?> popIterator() {
        this.current = this.iterators.isEmpty() ? null : this.iterators.remove(this.iterators.size() - 1);
        return this.current;
    }

    private Object internalNext() {
        Object result = null;
        while (result == null && this.current != null) {
            if (this.current.hasNext()) {
                Object next = this.unwrap(this.current.next());
                if (this.isCompound(next)) {
                    this.pushIterator(next);
                    continue;
                }
                result = next;
                continue;
            }
            this.popIterator();
        }
        return result;
    }

    boolean isDone() {
        return this.current == null && this.iterators.isEmpty();
    }

    @Override
    public boolean hasNext() {
        while (!this.isDone() && this.preparedNext == null) {
            Object next = this.internalNext();
            if (!this.type.isInstance(next)) continue;
            this.preparedNext = this.type.cast(next);
        }
        return this.preparedNext != null;
    }

    @Override
    public C next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        C result = this.preparedNext;
        this.preparedNext = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private Object unwrap(Object command) {
        Object result = command;
        if (command instanceof ICommandWrapper) {
            result = ((ICommandWrapper)command).getWrappedCommand();
        } else if (ICommandWrapper.isWrapper(command, Object.class)) {
            result = ICommandWrapper.unwrap(command, Object.class);
        }
        if (result != command) {
            result = this.unwrap(result);
        }
        return result;
    }

    private boolean isCompound(Object command) {
        return CommandUtils.isCompound(command);
    }

    private Iterator<?> iterator(Object compoundCommand) {
        return CommandUtils.getChildren(compoundCommand).iterator();
    }
}

