/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.BorderItemContainerFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.locator.AdvancedBorderItemLocator;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DestructionEventFigure;

public class CenterLocator
extends AdvancedBorderItemLocator {
    private DestructionEventFigure destructionEventFigure = null;
    private BorderItemContainerFigure borderItemContainerFigure = null;

    public CenterLocator(IFigure parentFigure, int location) {
        super(parentFigure, location);
    }

    private DestructionEventFigure getDestructionEventFigure() {
        BorderItemContainerFigure borderItemContainerFigure;
        if (this.destructionEventFigure == null && (borderItemContainerFigure = this.getBorderItemContainerFigure()) != null) {
            for (Object child : borderItemContainerFigure.getChildren()) {
                if (!(child instanceof DefaultSizeNodeFigure)) continue;
                for (Object figure : ((DefaultSizeNodeFigure)child).getChildren()) {
                    if (!(figure instanceof DestructionEventFigure)) continue;
                    this.destructionEventFigure = (DestructionEventFigure)((Object)figure);
                    return this.destructionEventFigure;
                }
            }
        }
        return this.destructionEventFigure;
    }

    private BorderItemContainerFigure getBorderItemContainerFigure() {
        if (this.borderItemContainerFigure == null) {
            IFigure figure = this.getParentFigure().getParent();
            for (Object object : figure.getChildren()) {
                if (!(object instanceof BorderItemContainerFigure)) continue;
                this.borderItemContainerFigure = (BorderItemContainerFigure)object;
                return this.borderItemContainerFigure;
            }
        }
        return this.borderItemContainerFigure;
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        if (this.getDestructionEventFigure() != null && borderItem.equals(this.getDestructionEventFigure().getParent())) {
            Rectangle realLocation = new Rectangle(proposedLocation);
            Point point = new Point(this.getParentBorder().getCenter().x - realLocation.getSize().width / 2, this.getParentBorder().y + this.getParentBorder().height - realLocation.height / 2);
            realLocation.setLocation(point);
            return realLocation;
        }
        proposedLocation.setX(this.getParentFigure().getBounds().x + this.getParentFigure().getBounds().width / 2 - borderItem.getBounds().width() / 2);
        if (proposedLocation.y - proposedLocation.height / 2 <= this.getParentFigure().getBounds().y) {
            proposedLocation.setY(this.getParentFigure().getBounds().y);
        }
        if (proposedLocation.y - proposedLocation.height / 2 >= this.getParentFigure().getBounds().getBottomLeft().y) {
            proposedLocation.setY(this.getParentFigure().getBounds().getBottomLeft().y);
        }
        return super.getValidLocation(proposedLocation, borderItem);
    }
}

