/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;

public class CoordinateReferentialUtils {
    public static Point transformPointFromScreenToDiagramReferential(Point locationOnScreen, GraphicalViewer graphicalViewer) {
        FigureCanvas figureCanvas = (FigureCanvas)graphicalViewer.getControl();
        Point locationScreen = figureCanvas.getViewport().getViewLocation();
        ZoomManager zoomManager = (ZoomManager)graphicalViewer.getProperty(ZoomManager.class.toString());
        Point locationOnDiagram = new Point(locationOnScreen.x + locationScreen.x, locationOnScreen.y + locationScreen.y);
        if (zoomManager != null) {
            locationOnDiagram = locationOnDiagram.getScaled(1.0 / zoomManager.getZoom());
        }
        return locationOnDiagram;
    }

    public static Point transformPointFromDiagramToScreenReferential(Point locationOnDiagram, GraphicalViewer graphicalViewer) {
        FigureCanvas figureCanvas = (FigureCanvas)graphicalViewer.getControl();
        Point locationScreen = figureCanvas.getViewport().getViewLocation();
        ZoomManager zoomManager = (ZoomManager)graphicalViewer.getProperty(ZoomManager.class.toString());
        Point locationOnScreen = locationOnDiagram.getCopy();
        if (zoomManager != null) {
            locationOnScreen = locationOnScreen.getScaled(zoomManager.getZoom());
        }
        locationOnScreen = new Point(locationOnScreen.x - locationScreen.x, locationOnScreen.y - locationScreen.y);
        return locationOnScreen;
    }

    public static Point getFigurePositionRelativeToDiagramReferential(IFigure figure, DiagramEditPart diagramEditPart) {
        Rectangle bounds = figure.getBounds().getCopy();
        figure.getParent().translateToAbsolute((Translatable)bounds);
        Point relativeToParent = bounds.getTopLeft().getCopy();
        diagramEditPart.getFigure().translateToRelative((Translatable)relativeToParent);
        return relativeToParent;
    }
}

