/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NamedStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StyledElement;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class StyleUtils {
    public static final List<Integer> getHiddenDepths(Table table) {
        IntListValueStyle style = StyleUtils.getHiddenDepthsValueStyle(table);
        if (style == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(style.getIntListValue());
    }

    public static final List<Integer> getHiddenDepths(INattableModelManager manager) {
        return StyleUtils.getHiddenDepths(manager.getTable());
    }

    public static final IntListValueStyle getHiddenDepthsValueStyle(Table table) {
        return (IntListValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getIntListValueStyle(), "hiddenCategoriesByDepth");
    }

    public static final IntListValueStyle getHiddenDepthsValueStyle(INattableModelManager manager) {
        return StyleUtils.getHiddenDepthsValueStyle(manager.getTable());
    }

    public static final boolean isHiddenDepth(INattableModelManager manager, int depth) {
        return StyleUtils.isHiddenDepth(manager.getTable(), depth);
    }

    public static final boolean isHiddenDepth(Table table, int depth) {
        List<Integer> hidden = StyleUtils.getHiddenDepths(table);
        return hidden.contains(depth);
    }

    public static final boolean hasAppliedFilter(INattableModelManager manager) {
        for (Object current : manager.getColumnElementsList()) {
            if (!(current instanceof StyledElement)) continue;
            StyledElement element = (StyledElement)current;
            NamedStyle style = element.getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "filterId");
            if (style != null) {
                return true;
            }
            style = element.getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "filterForcedByUserId");
            if (style == null) continue;
            return true;
        }
        return false;
    }

    public static boolean getBooleanNamedStyleValue(StyledElement styledElement, String namedStyleString, boolean defaultValue) {
        BooleanValueStyle booleanNamedStyle;
        if (styledElement != null && namedStyleString != null && (booleanNamedStyle = (BooleanValueStyle)styledElement.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), namedStyleString)) != null) {
            return booleanNamedStyle.isBooleanValue();
        }
        return defaultValue;
    }

    public static boolean getBooleanNamedStyleValue(Table table, String namedStyleString) {
        boolean resultValue = false;
        if (table != null && namedStyleString != null) {
            BooleanValueStyle booleanNamedStyle = (BooleanValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), namedStyleString);
            if (booleanNamedStyle == null) {
                TableConfiguration config = table.getTableConfiguration();
                booleanNamedStyle = (BooleanValueStyle)config.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), namedStyleString);
            }
            resultValue = booleanNamedStyle != null && booleanNamedStyle.isBooleanValue();
        }
        return resultValue;
    }

    public static void setBooleanNamedStyle(TransactionalEditingDomain editingDomain, StyledElement styledElement, String namedStyleString, boolean value) {
        SetRequest request;
        IElementEditService editService;
        BooleanValueStyle booleanNamedStyle;
        if (editingDomain != null && styledElement != null && namedStyleString != null && (booleanNamedStyle = (BooleanValueStyle)styledElement.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), namedStyleString)) != null && (editService = ElementEditServiceUtils.getCommandProvider((EObject)booleanNamedStyle)).canEdit((IEditCommandRequest)(request = new SetRequest(editingDomain, (EObject)booleanNamedStyle, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)value)))) {
            Command command = GMFtoEMFCommandWrapper.wrap((ICommand)editService.getEditCommand((IEditCommandRequest)request));
            editingDomain.getCommandStack().execute(command);
        }
    }

    public static void initBooleanNamedStyle(TransactionalEditingDomain editingDomain, StyledElement styledElement, String namedStyleString, boolean defaultValue) {
        BooleanValueStyle namedStyle;
        if (editingDomain != null && styledElement != null && namedStyleString != null && (namedStyle = (BooleanValueStyle)styledElement.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), namedStyleString)) == null) {
            namedStyle = NattablestyleFactory.eINSTANCE.createBooleanValueStyle();
            namedStyle.setName(namedStyleString);
            namedStyle.setBooleanValue(defaultValue);
            ArrayList<BooleanValueStyle> styleList = new ArrayList<BooleanValueStyle>((Collection<BooleanValueStyle>)styledElement.getStyles());
            styleList.add(namedStyle);
            IElementEditService editService = ElementEditServiceUtils.getCommandProvider((EObject)styledElement);
            SetRequest request = new SetRequest(editingDomain, (EObject)styledElement, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), styleList);
            if (editService.canEdit((IEditCommandRequest)request)) {
                Command command = GMFtoEMFCommandWrapper.wrap((ICommand)editService.getEditCommand((IEditCommandRequest)request));
                editingDomain.getCommandStack().execute(command);
            }
        }
    }

    public static void deleteBooleanNamedStyle(TransactionalEditingDomain editingDomain, StyledElement styledElement, String namedStyleString) {
        BooleanValueStyle namedStyle;
        if (editingDomain != null && styledElement != null && namedStyleString != null && (namedStyle = (BooleanValueStyle)styledElement.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), namedStyleString)) != null) {
            ArrayList styleList = new ArrayList(styledElement.getStyles());
            styleList.remove(namedStyle);
            IElementEditService editService = ElementEditServiceUtils.getCommandProvider((EObject)styledElement);
            SetRequest request = new SetRequest(editingDomain, (EObject)styledElement, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), styleList);
            if (editService.canEdit((IEditCommandRequest)request)) {
                Command command = GMFtoEMFCommandWrapper.wrap((ICommand)editService.getEditCommand((IEditCommandRequest)request));
                editingDomain.getCommandStack().execute(command);
            }
        }
    }
}

