/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SenderRequestUtils;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.CoordinateReferentialUtils;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class UpdateNodeReferenceEditPolicy
extends GraphicalEditPolicy {
    public static String UDPATE_NODE_REFERENCE = "UdpateNodeReferenceEditPolicy";

    public Command getCommand(Request request) {
        if (request instanceof ReconnectRequest && !SenderRequestUtils.isASender(request, this.getHost())) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            ConnectionEditPart linkEditPart = reconnectRequest.getConnectionEditPart();
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ MOVE ANCHORS of " + linkEditPart.getClass().getName());
            Point locationOnDiagram = CoordinateReferentialUtils.transformPointFromScreenToDiagramReferential(reconnectRequest.getLocation(), (GraphicalViewer)this.getHost().getViewer());
            UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+-- LocationOnDiagram " + locationOnDiagram);
            if (linkEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE") != null) {
                SequenceReferenceEditPolicy references = (SequenceReferenceEditPolicy)linkEditPart.getEditPolicy((Object)"SEQUENCE_REFERENCE");
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EditPart editPart : references.getStrongReferences().keySet()) {
                    int delta;
                    if (SenderRequestUtils.isASender(request, editPart) || !this.getHost().getChildren().contains(editPart)) continue;
                    GraphicalEditPart gEditPart = (GraphicalEditPart)editPart;
                    Point GEPlocationOnDiagram = CoordinateReferentialUtils.getFigurePositionRelativeToDiagramReferential(gEditPart.getFigure(), this.getDiagramEditPart(this.getHost()));
                    locationOnDiagram = CoordinateReferentialUtils.transformPointFromScreenToDiagramReferential((Point)SequenceUtil.getSnappedLocation((EditPart)gEditPart, reconnectRequest.getLocation().getCopy()), (GraphicalViewer)this.getHost().getViewer());
                    UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> try to Move  from " + GEPlocationOnDiagram + " " + editPart.getClass().getName());
                    ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"resize");
                    changeBoundsRequest.setLocation(reconnectRequest.getLocation().getCopy());
                    changeBoundsRequest.setEditParts(editPart);
                    if (references.getStrongReferences().get(editPart).equals("START")) {
                        delta = locationOnDiagram.y() - GEPlocationOnDiagram.y();
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> Delta " + delta + " " + editPart.getClass().getName());
                        changeBoundsRequest.setMoveDelta(new Point(0, delta));
                        changeBoundsRequest.setSizeDelta(new Dimension(0, 0));
                    }
                    if (references.getStrongReferences().get(editPart).equals("FINISH")) {
                        delta = locationOnDiagram.y() - GEPlocationOnDiagram.y() - gEditPart.getFigure().getBounds().height;
                        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+--> Delta " + delta + " " + editPart.getClass().getName());
                        changeBoundsRequest.setMoveDelta(new Point(0, delta));
                        changeBoundsRequest.setSizeDelta(new Dimension(0, 0));
                    }
                    ArrayList<EditPart> senderList = SenderRequestUtils.getSenders(request);
                    SenderRequestUtils.addRequestSenders((Request)changeBoundsRequest, senderList);
                    SenderRequestUtils.addRequestSender((Request)changeBoundsRequest, (EditPart)linkEditPart);
                    Command cmd = editPart.getCommand((Request)changeBoundsRequest);
                    compoundCommand.add(cmd);
                }
                if (compoundCommand.size() == 0) {
                    return super.getCommand((Request)reconnectRequest);
                }
                return compoundCommand;
            }
            return super.getCommand(request);
        }
        return super.getCommand(request);
    }

    public DiagramEditPart getDiagramEditPart(EditPart editPart) {
        while (editPart instanceof IGraphicalEditPart) {
            if (editPart instanceof DiagramEditPart) {
                return (DiagramEditPart)editPart;
            }
            editPart = editPart.getParent();
        }
        if (editPart instanceof DiagramRootEditPart) {
            return (DiagramEditPart)((DiagramRootEditPart)editPart).getChildren().get(0);
        }
        return null;
    }
}

