/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchLibraryContentProvider
implements IStructuredContentProvider {
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    protected boolean isModelResource(ModelSet modelSet, Resource resource) {
        IModel resourceModel = modelSet.getModelFor((Object)resource);
        if (resourceModel == null) {
            return false;
        }
        if (resourceModel instanceof AbstractBaseModel) {
            AbstractBaseModel model = (AbstractBaseModel)resourceModel;
            if (model.getResource() == resource) {
                return true;
            }
            if (model.isControlled(resource)) {
                return true;
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)inputElement;
            HashSet<URI> allReferencedURIs = new HashSet<URI>();
            HashSet<Resource> allModelResources = new HashSet<Resource>();
            for (Resource resource : modelSet.getResources()) {
                if (!this.isModelResource(modelSet, resource)) continue;
                allModelResources.add(resource);
            }
            for (Resource modelResource : allModelResources) {
                TreeIterator allContents = EcoreUtil.getAllProperContents((Resource)modelResource, (boolean)true);
                while (allContents.hasNext()) {
                    EObject next = (EObject)allContents.next();
                    EList allReferences = next.eClass().getEAllReferences();
                    for (EReference reference : allReferences) {
                        if (reference.isContainer() || reference.isContainment() || reference.isVolatile() || reference.isTransient() || reference.isDerived() || !reference.isChangeable()) continue;
                        Object value = next.eGet((EStructuralFeature)reference);
                        if (value instanceof EObject) {
                            this.handleReferenceValue(value, allReferencedURIs);
                            continue;
                        }
                        if (!(value instanceof List)) continue;
                        List values = (List)value;
                        for (Object objectValue : values) {
                            this.handleReferenceValue(objectValue, allReferencedURIs);
                        }
                    }
                }
            }
            Iterator iterator = allReferencedURIs.iterator();
            while (iterator.hasNext()) {
                URI referencedURI = (URI)iterator.next();
                if (referencedURI == null) {
                    iterator.remove();
                    continue;
                }
                Resource referencedResource = modelSet.getResource(referencedURI, false);
                if (referencedResource == null) continue;
                if (allModelResources.contains(referencedResource)) {
                    iterator.remove();
                    continue;
                }
                if (!(referencedURI instanceof Resource)) continue;
                for (EObject rootElement : ((Resource)referencedURI).getContents()) {
                    if (rootElement.eContainer() == null) continue;
                    iterator.remove();
                }
            }
            return allReferencedURIs.toArray();
        }
        return null;
    }

    protected void handleReferenceValue(Object objectValue, Set<URI> allReferencedURIs) {
        if (objectValue instanceof EObject) {
            EObject eObject = (EObject)objectValue;
            allReferencedURIs.add(EcoreUtil.getURI((EObject)eObject).trimFragment());
        }
    }
}

