/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.part;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class UMLElementChooserDialog
extends Dialog {
    private final AdapterFactory myItemProvidersAdapterFactory;
    private TreeViewer myTreeViewer;
    private URI mySelectedModelElementURI;
    private TransactionalEditingDomain myEditingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();

    public UMLElementChooserDialog(Shell parentShell, AdapterFactory itemProvidersAdapterFactory) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.myItemProvidersAdapterFactory = itemProvidersAdapterFactory;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setSelection(this.myTreeViewer);
        return control;
    }

    protected void setSelection(TreeViewer treeViewer) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Select model element");
        this.createModelBrowser(composite);
        this.setInput(this.myTreeViewer);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.setOkButtonEnabled(false);
        return buttonBar;
    }

    private void createModelBrowser(Composite composite) {
        this.myTreeViewer = new TreeViewer(composite, 2820);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.myTreeViewer.getTree().setLayoutData((Object)layoutData);
        this.myTreeViewer.setContentProvider((IContentProvider)new ModelElementsTreeContentProvider());
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementsTreeLabelProvider());
        this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new OkButtonEnabler());
    }

    protected void setInput(TreeViewer treeViewer) {
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public URI getSelectedModelElementURI() {
        return this.mySelectedModelElementURI;
    }

    public int open() {
        int result = super.open();
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        this.myEditingDomain.dispose();
        return result;
    }

    protected boolean isValid(EObject selectedElement) {
        return false;
    }

    private class ModelElementsTreeContentProvider
    implements ITreeContentProvider {
        private ITreeContentProvider myWorkbenchContentProvider = new WorkbenchContentProvider();
        private AdapterFactoryContentProvider myAdapterFctoryContentProvier;

        private ModelElementsTreeContentProvider() {
            this.myAdapterFctoryContentProvier = new AdapterFactoryContentProvider(UMLElementChooserDialog.this.myItemProvidersAdapterFactory);
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = this.myWorkbenchContentProvider.getChildren(parentElement);
            if (result != null && result.length > 0) {
                return result;
            }
            if (parentElement instanceof IFile) {
                IFile modelFile = (IFile)parentElement;
                IPath resourcePath = modelFile.getFullPath();
                ResourceSet resourceSet = UMLElementChooserDialog.this.myEditingDomain.getResourceSet();
                try {
                    Resource modelResource = resourceSet.getResource(URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)true), true);
                    return this.myAdapterFctoryContentProvier.getChildren((Object)modelResource);
                }
                catch (WrappedException e) {
                    e.printStackTrace();
                    return Collections.EMPTY_LIST.toArray();
                }
            }
            return this.myAdapterFctoryContentProvier.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            Object parent = this.myWorkbenchContentProvider.getParent(element);
            if (parent != null) {
                return parent;
            }
            if (!(element instanceof EObject)) {
                return null;
            }
            EObject eObject = (EObject)element;
            if (eObject.eContainer() == null && eObject.eResource().getURI().isFile()) {
                String path = eObject.eResource().getURI().path();
                return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
            }
            return this.myAdapterFctoryContentProvier.getParent((Object)eObject);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return this.isValidModelFile((IFile)element);
            }
            return this.myWorkbenchContentProvider.hasChildren(element) || this.myAdapterFctoryContentProvier.hasChildren(element);
        }

        private boolean isValidModelFile(IFile file) {
            String fileExtension = file.getFullPath().getFileExtension();
            return "uml".equals(fileExtension);
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.myWorkbenchContentProvider.getElements(inputElement);
            if (elements != null && elements.length > 0) {
                return elements;
            }
            if (!(inputElement instanceof Resource)) {
                return Collections.EMPTY_LIST.toArray();
            }
            Resource modelResource = (Resource)inputElement;
            return this.myAdapterFctoryContentProvier.getChildren((Object)modelResource);
        }

        public void dispose() {
            this.myAdapterFctoryContentProvier.dispose();
            this.myWorkbenchContentProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myWorkbenchContentProvider.inputChanged(viewer, oldInput, newInput);
            this.myAdapterFctoryContentProvier.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class ModelElementsTreeLabelProvider
    implements ILabelProvider {
        private WorkbenchLabelProvider myWorkbenchLabelProvider = new WorkbenchLabelProvider();
        private AdapterFactoryLabelProvider myAdapterFactoryLabelProvider;

        private ModelElementsTreeLabelProvider() {
            this.myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(UMLElementChooserDialog.this.myItemProvidersAdapterFactory);
        }

        public Image getImage(Object element) {
            Image result = this.myWorkbenchLabelProvider.getImage(element);
            return result != null ? result : this.myAdapterFactoryLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            String result = this.myWorkbenchLabelProvider.getText(element);
            return result != null && result.length() > 0 ? result : this.myAdapterFactoryLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.addListener(listener);
            this.myAdapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.myWorkbenchLabelProvider.dispose();
            this.myAdapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myWorkbenchLabelProvider.isLabelProperty(element, property) || this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.removeListener(listener);
            this.myAdapterFactoryLabelProvider.removeListener(listener);
        }
    }

    private class OkButtonEnabler
    implements ISelectionChangedListener {
        private OkButtonEnabler() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1) {
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IWrapperItemProvider) {
                    selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
                }
                if (selectedElement instanceof FeatureMap.Entry) {
                    selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
                }
                if (selectedElement instanceof EObject) {
                    EObject selectedModelElement = (EObject)selectedElement;
                    UMLElementChooserDialog.this.setOkButtonEnabled(UMLElementChooserDialog.this.isValid(selectedModelElement));
                    UMLElementChooserDialog.this.mySelectedModelElementURI = EcoreUtil.getURI((EObject)selectedModelElement);
                    return;
                }
            }
            UMLElementChooserDialog.this.mySelectedModelElementURI = null;
            UMLElementChooserDialog.this.setOkButtonEnabled(false);
        }
    }
}

