/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;

public class FixInteractionOperandsOnOpening {
    public final int TOP_HEIGHT = 20;

    public void fix(Diagram diagram) {
        String IAO_ID = "InteractionOperand_Shape";
        TreeIterator it = diagram.eAllContents();
        while (it.hasNext()) {
            View parentParentView;
            Shape iaOperandShape;
            View parentDecoration;
            String currentType;
            EObject current = (EObject)it.next();
            if (!(current instanceof Shape) || !IAO_ID.equals(currentType = ((Shape)current).getType()) || (parentDecoration = ViewUtil.getViewContainer((EObject)(iaOperandShape = (Shape)current))) == null || !((parentParentView = ViewUtil.getViewContainer((EObject)parentDecoration)) instanceof Shape)) continue;
            Shape parentShape = (Shape)parentParentView;
            Bounds iaOperandShapeBounds = (Bounds)iaOperandShape.getLayoutConstraint();
            Bounds parentShapeBounds = (Bounds)parentShape.getLayoutConstraint();
            if (iaOperandShapeBounds.getX() != 0 || iaOperandShapeBounds.getY() != 0 || iaOperandShapeBounds.getWidth() != -1) continue;
            int size = parentDecoration.getChildren().size();
            int index = parentDecoration.getChildren().indexOf((Object)iaOperandShape);
            int height = (parentShapeBounds.getHeight() - 20) / size;
            int y = index * height;
            Rectangle newBounds = new Rectangle(0, y, parentShapeBounds.getWidth() - 2, height);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
            FixLocationCommand fixCommand = new FixLocationCommand(editingDomain, "Fix combined fragment on opening", iaOperandShapeBounds, newBounds);
            editingDomain.getCommandStack().execute((Command)fixCommand);
        }
    }

    public class FixLocationCommand
    extends RecordingCommand {
        private Bounds iaViewBounds;
        private Rectangle iaViewNewBounds;

        public FixLocationCommand(TransactionalEditingDomain domain, String label, Bounds iaViewBounds, Rectangle iaViewNewBounds) {
            super(domain, label);
            this.iaViewBounds = iaViewBounds;
            this.iaViewNewBounds = iaViewNewBounds;
        }

        protected void doExecute() {
            this.iaViewBounds.setX(this.iaViewNewBounds.x());
            this.iaViewBounds.setY(this.iaViewNewBounds.y());
            this.iaViewBounds.setWidth(this.iaViewNewBounds.width());
            this.iaViewBounds.setHeight(this.iaViewNewBounds.height());
        }

        public boolean canUndo() {
            return false;
        }
    }
}

