/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.standard.FilteredRegisteredElementsSelectionDialog;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileTreeSelectionDialog;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.Message;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class RegisteredProfileSelectionDialog
extends FilteredRegisteredElementsSelectionDialog {
    private Package currentPackage;

    public RegisteredProfileSelectionDialog(Composite parent, Package umlPackage) {
        super(parent.getShell(), true, (Object[])Registry.getRegisteredProfiles().toArray(new IRegisteredProfile[0]), new ArrayList(), "Apply profiles from Papyrus repository :", "");
        this.currentPackage = umlPackage;
    }

    public List<Profile> run() {
        this.open();
        LinkedList<Profile> result = new LinkedList<Profile>();
        ResourceSet resourceSet = Util.createTemporaryResourceSet();
        try {
            List<Profile> profilesToApply = this.treatSelection(resourceSet);
            for (Profile profile : profilesToApply) {
                result.add((Profile)EMFHelper.reloadIntoContext((EObject)profile, (EObject)this.currentPackage));
            }
        }
        finally {
            EMFHelper.unload((ResourceSet)resourceSet);
        }
        return result;
    }

    private List<Profile> treatSelection(ResourceSet resourceSet) {
        Object[] selection = this.getResult();
        if (selection == null) {
            return new ArrayList<Profile>();
        }
        ArrayList<Profile> listOfProfileToApply = new ArrayList<Profile>();
        ArrayList<String> subprofilesList = new ArrayList<String>();
        int i = 0;
        while (i < selection.length) {
            IRegisteredProfile currentProfile = (IRegisteredProfile)selection[i];
            URI modelUri = currentProfile.getUri();
            Resource modelResource = resourceSet.getResource(modelUri, true);
            String qualifiedNames = currentProfile.getQualifiedNames();
            String[] profiles = qualifiedNames.split(",");
            int j = 0;
            while (j < profiles.length) {
                String string = profiles[j].trim();
                subprofilesList.add(string);
                ++j;
            }
            if (!modelResource.getContents().isEmpty() && modelResource.getContents().get(0) instanceof Profile) {
                Message processMsg = new Message("Profile application", "Loading profiles...");
                processMsg.open();
                Profile profileToApply = (Profile)modelResource.getContents().get(0);
                processMsg.close();
                listOfProfileToApply.add(profileToApply);
            }
            ++i;
        }
        if (!listOfProfileToApply.isEmpty()) {
            ProfileTreeSelectionDialog profileDialog = new ProfileTreeSelectionDialog(this.getShell(), listOfProfileToApply, subprofilesList);
            int returnValue = profileDialog.open();
            if (returnValue == 0) {
                Collection dlgResult = profileDialog.getResult();
                ArrayList<Profile> result = new ArrayList<Profile>(dlgResult.size());
                for (ElementImportTreeSelectionDialog.ImportSpec next : dlgResult) {
                    result.add((Profile)next.getElement());
                }
                return result;
            }
            new ArrayList();
        }
        return new ArrayList<Profile>();
    }
}

