/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.listener;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringListValueStyle;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.graphics.Point;

public class NatTableDragSourceListener
implements DragSourceListener {
    protected ISelection selection;
    private NatTable nattable;
    private INattableModelManager tableManager;
    private Table table;

    public NatTableDragSourceListener(INattableModelManager tableManager, NatTable nattable, Table table) {
        this.tableManager = tableManager;
        this.nattable = nattable;
        this.table = table;
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = false;
        int i = 0;
        while (i < this.getGridRegions().size() && !event.doit) {
            if (!this.isResizing(event) && this.nattable.getRegionLabelsByXY(event.x, event.y).hasLabel(this.getGridRegions().get(i))) {
                event.doit = true;
            }
            ++i;
        }
        if (event.doit) {
            this.selection = this.tableManager.getSelectionInTable();
            LocalSelectionTransfer.getTransfer().setSelection(this.selection);
            LocalSelectionTransfer.getTransfer().setSelectionSetTime(System.currentTimeMillis());
        }
    }

    protected List<String> getGridRegions() {
        ArrayList<String> regions = new ArrayList<String>();
        StringListValueStyle values = (StringListValueStyle)this.table.getNamedStyle(NattablestylePackage.eINSTANCE.getStringListValueStyle(), "dragRegions");
        if (values == null) {
            values = (StringListValueStyle)this.table.getTableConfiguration().getNamedStyle(NattablestylePackage.eINSTANCE.getStringListValueStyle(), "dragRegions");
        }
        if (values != null) {
            EList stringListValue = values.getStringListValue();
            for (String region : stringListValue) {
                if (this.table.isInvertAxis()) {
                    if ("ROW_HEADER".equals(region)) {
                        region = "COLUMN_HEADER";
                    } else if ("COLUMN_HEADER".equals(region)) {
                        region = "ROW_HEADER";
                    }
                }
                regions.add(region);
            }
        }
        return regions;
    }

    protected boolean isResizing(DragSourceEvent event) {
        return CellEdgeDetectUtil.getRowPositionToResize((ILayer)this.nattable, (Point)new Point(event.x, event.y)) >= 0 || CellEdgeDetectUtil.getColumnPositionToResize((ILayer)this.nattable, (Point)new Point(event.x, event.y)) >= 0;
    }

    public void dragSetData(DragSourceEvent event) {
        if (LocalTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.selection;
        } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = LocalSelectionTransfer.getTransfer().getSelection();
        }
    }

    public void dragFinished(DragSourceEvent event) {
        this.selection = null;
        LocalTransfer.getInstance().javaToNative(null, null);
        LocalSelectionTransfer.getTransfer().setSelection(null);
    }
}

