/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy.classifier;

import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.TypeHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;

public class ClassifierAsPropertyToStructuredCompartmentDropStrategy
extends TransactionalDropStrategy {
    protected Point getLocation(DropObjectsRequest request, GraphicalEditPart targetEP) {
        Point location = request.getLocation().getCopy();
        targetEP.getContentPane().translateToRelative((Translatable)location);
        targetEP.getContentPane().translateFromParent((Translatable)location);
        location.translate(targetEP.getContentPane().getClientArea().getLocation().getNegated());
        return location;
    }

    protected boolean understandRequest(Request request) {
        if (!(request instanceof DropObjectsRequest)) {
            return false;
        }
        DropObjectsRequest dropRequest = (DropObjectsRequest)request;
        if (request.getExtendedData().size() == 0) {
            return false;
        }
        return dropRequest.getLocation() != null;
    }

    protected boolean isStructuredClassifierEP(EditPart ep) {
        if (!(ep instanceof GraphicalEditPart)) {
            return false;
        }
        EObject targetSemantic = this.getTargetSemanticElement(ep);
        if (!(targetSemantic instanceof StructuredClassifier)) {
            return false;
        }
        View notationView = ((IGraphicalEditPart)ep).getNotationView();
        if (notationView == null || notationView.getDiagram() == null) {
            return false;
        }
        return "CompositeStructure".equals(notationView.getDiagram().getType());
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if (this.understandRequest(request) && this.isStructuredClassifierEP(targetEditPart)) {
            GraphicalEditPart gtEditPart = (GraphicalEditPart)targetEditPart;
            TypeHelper helper = new TypeHelper((TransactionalEditingDomain)this.getEditingDomain(targetEditPart));
            Point location = this.getLocation((DropObjectsRequest)request, gtEditPart);
            CompoundCommand cc = new CompoundCommand();
            for (EObject dropElement : this.getSourceEObjects(request)) {
                if (dropElement instanceof Collaboration || !(dropElement instanceof Classifier) || dropElement instanceof Association) continue;
                Classifier classifier = (Classifier)dropElement;
                cc.add((Command)helper.dropTypeAsTypedProperty(gtEditPart, (Type)classifier, location));
            }
            return cc.canExecute() ? cc : null;
        }
        return null;
    }

    public String getLabel() {
        return "Drop type as typed property";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.dnd.ClassifierToStructureCompAsPropertyDrop";
    }

    public String getDescription() {
        return "Drops a classifier into the structure compartment of a structured classifier as a property.";
    }

    public String getCategoryID() {
        return "org.eclipse.papyrus.dnd.ClassifierToStructureCompAsPropertyDrop";
    }

    public String getCategoryLabel() {
        return "Drop a classifier into the structure compartment of a structured classifier as property";
    }

    public Image getImage() {
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public void setOptions(Map<String, Object> options) {
    }
}

