/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.uml.diagram.common.draw2d.LifelineDotLineFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;

public class LifelineDotLineCustomFigure
extends LifelineDotLineFigure {
    private LayoutManager inlineModeManager;
    private LayoutManager normalModeManager = new XYLayout();
    private boolean inlineMode;
    private int innerConnectableElementsNumber;

    public LifelineDotLineCustomFigure() {
        this.inlineModeManager = new XYLayout();
        this.setLayoutManager(this.normalModeManager);
    }

    public void configure(boolean inlineMode, int innerConnectableElementsNumber) {
        if (inlineMode) {
            this.innerConnectableElementsNumber = innerConnectableElementsNumber;
        }
        if (this.inlineMode != inlineMode) {
            this.inlineMode = inlineMode;
            if (inlineMode) {
                this.setLayoutManager(this.inlineModeManager);
            } else {
                this.setLayoutManager(this.normalModeManager);
            }
        }
    }

    protected void outlineShape(Graphics graphics) {
        if (!this.inlineMode) {
            this.paintDashLineBackground(graphics);
            super.outlineShape(graphics);
        }
    }

    protected void paintDashLineBackground(Graphics graphics) {
        NodeFigure dashLineRectangle = this.getDashLineRectangle();
        if (!dashLineRectangle.isOpaque()) {
            return;
        }
        Rectangle r = this.getBounds().getCopy();
        r.x += r.width / 2;
        r.width = 1;
        Rectangle lineBounds = r.expand(4, 0);
        graphics.pushState();
        try {
            graphics.setBackgroundColor(dashLineRectangle.getBackgroundColor());
            graphics.setForegroundColor(dashLineRectangle.getForegroundColor());
            graphics.fillRectangle(lineBounds);
        }
        finally {
            graphics.popState();
        }
    }

    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        NodeFigure dashLineRectangle = this.getDashLineRectangle();
        return dashLineRectangle.containsPoint(x, y);
    }

    public static class DefaultSizeNodeFigureEx
    extends DefaultSizeNodeFigure {
        public DefaultSizeNodeFigureEx(int width, int height) {
            super(width, height);
        }

        public IFigure findMouseEventTargetAt(int x, int y) {
            IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
            if (f != null) {
                return f;
            }
            if (!this.containsPoint(x, y)) {
                return null;
            }
            if (this.isMouseEventTarget()) {
                return this;
            }
            return null;
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            if (search.prune((IFigure)this)) {
                return null;
            }
            IFigure child = this.findDescendantAtExcluding(x, y, search);
            if (child != null) {
                return child;
            }
            if (!this.containsPoint(x, y)) {
                return null;
            }
            if (search.accept((IFigure)this)) {
                return this;
            }
            return null;
        }
    }

    public static class NodeNamedElementFigureEx
    extends NodeNamedElementFigure {
        public IFigure findMouseEventTargetAt(int x, int y) {
            IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
            if (f != null) {
                return f;
            }
            if (!this.containsPoint(x, y)) {
                return null;
            }
            if (this.isMouseEventTarget()) {
                return this;
            }
            return null;
        }

        public IFigure findFigureAt(int x, int y, TreeSearch search) {
            if (search.prune((IFigure)this)) {
                return null;
            }
            IFigure child = this.findDescendantAtExcluding(x, y, search);
            if (child != null) {
                return child;
            }
            if (!this.containsPoint(x, y)) {
                return null;
            }
            if (search.accept((IFigure)this)) {
                return this;
            }
            return null;
        }
    }
}

