/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.function.BooleanSupplier;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.widgets.Display;

public abstract class RetryingDeferredAction {
    private static final int DEFAULT_RETRY_LIMIT = 3;
    private final Display display;
    private final int retryLimit;
    private volatile int retries;

    public RetryingDeferredAction(Display display, int retryLimit) {
        if (retryLimit <= 0) {
            throw new IllegalArgumentException("retry limit must be positive");
        }
        this.display = display;
        this.retryLimit = retryLimit;
    }

    public RetryingDeferredAction(Display display) {
        this(display, 3);
    }

    public RetryingDeferredAction(int retryLimit) {
        this(Display.getCurrent(), retryLimit);
    }

    public RetryingDeferredAction() {
        this(Display.getCurrent(), 3);
    }

    public static void defer(Display display, int retryLimit, BooleanSupplier action) {
        new Wrapper(display, retryLimit, action).post();
    }

    public static void defer(Display display, BooleanSupplier action) {
        RetryingDeferredAction.defer(display, 3, action);
    }

    public static void defer(int retryLimit, BooleanSupplier action) {
        RetryingDeferredAction.defer(Display.getCurrent(), retryLimit, action);
    }

    public static void defer(BooleanSupplier action) {
        RetryingDeferredAction.defer(Display.getCurrent(), 3, action);
    }

    protected abstract boolean prepare();

    protected abstract void perform();

    private void run() {
        if (this.prepare()) {
            this.perform();
        } else {
            ++this.retries;
            this.post();
        }
    }

    public void post() {
        if (this.retries < this.retryLimit) {
            this.display.asyncExec(this::run);
        } else {
            UMLDiagramEditorPlugin.log.warn("Retry limit exceeded for " + this);
        }
    }

    private static final class Wrapper
    extends RetryingDeferredAction {
        private final BooleanSupplier action;

        Wrapper(Display display, int retryLimit, BooleanSupplier action) {
            super(display, retryLimit);
            this.action = action;
        }

        @Override
        protected boolean prepare() {
            return this.action.getAsBoolean();
        }

        @Override
        protected void perform() {
        }
    }
}

