/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;
import org.eclipse.papyrus.uml.diagram.common.dialogs.CreateOrShowExistingLinkDialog;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.LinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.messages.Messages;
import org.eclipse.papyrus.uml.diagram.common.util.AssociationUtil;
import org.eclipse.papyrus.uml.diagram.common.util.LinkEndsMapper;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateOrShowExistingElementHelper {
    protected final ILinkMappingHelper linkMappingHelper;

    public CreateOrShowExistingElementHelper() {
        this(new ILinkMappingHelper(){

            @Override
            public Collection<?> getTarget(Element link) {
                return LinkMappingHelper.getTarget(link);
            }

            @Override
            public Collection<?> getSource(Element link) {
                return LinkMappingHelper.getSource(link);
            }
        });
    }

    public CreateOrShowExistingElementHelper(ILinkMappingHelper linkHelper) {
        this.linkMappingHelper = linkHelper;
    }

    public Command getCreateOrRestoreElementCommand(CreateRelationshipRequest req, Command defaultCommand, IElementType linkElementType) {
        List<LinkEndsMapper> existingElements;
        EObject container;
        if (this.showDialogAccordingPreferences() && defaultCommand.canExecute() && (container = req.getContainer()) instanceof Element && (existingElements = this.getExistingLinksBetweenSourceAndTarget(req, linkElementType)).size() > 0) {
            String className = this.getIElementTypeNameToDisplay(linkElementType);
            String dialogTitle = NLS.bind((String)Messages.CreateOrShowExistingElementHelper_CreateOrRestoreX, (Object)className);
            String dialogMessage = NLS.bind((String)Messages.CreateOrShowExistingElementHelper_XBetweenTheseElementAlreadyExists, (Object)className);
            CreateOrShowExistingLinkDialog dialog = new CreateOrShowExistingLinkDialog(dialogTitle, dialogMessage, existingElements);
            return new ICommandProxy(CreateOrShowExistingElementHelper.getOpenLinkDialogCommand(req, defaultCommand, dialog, existingElements));
        }
        return defaultCommand;
    }

    protected boolean hasWantedType(EObject element, IElementType elementType) {
        return element.eClass() == elementType.getEClass();
    }

    protected boolean showDialogAccordingPreferences() {
        String preferenceName;
        boolean showDialog = true;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean contains = store.contains(preferenceName = PreferencesConstantsHelper.getPapyrusEditorConstant((int)35));
        if (contains) {
            showDialog = !store.getBoolean(preferenceName);
        }
        return showDialog;
    }

    protected String getIElementTypeNameToDisplay(IElementType elementType) {
        return elementType.getEClass().getName();
    }

    private boolean getExpectedNavigable(boolean source, CreateRelationshipRequest request) {
        Object isAffects = null;
        boolean expectedNavigable = false;
        if (!source && (isAffects = request.getParameter("papyrus.affectsTarget")) != null && isAffects.equals(true)) {
            expectedNavigable = true;
        }
        return expectedNavigable;
    }

    protected List<LinkEndsMapper> getExistingLinksBetweenSourceAndTarget(CreateRelationshipRequest request, IElementType wantedElementType) {
        ArrayList<LinkEndsMapper> existingElement;
        block11: {
            EClass wantedEClass;
            block8: {
                existingElement = new ArrayList<LinkEndsMapper>();
                wantedEClass = wantedElementType.getEClass();
                if (!UMLPackage.eINSTANCE.getAssociation().equals(wantedEClass)) break block8;
                for (Element current : ((Element)request.getContainer()).getOwnedElements()) {
                    boolean identicalAssociation;
                    ArrayList sources;
                    block10: {
                        EObject sourceRequest;
                        block9: {
                            if (!this.hasWantedType((EObject)current, wantedElementType)) continue;
                            sources = new ArrayList(this.linkMappingHelper.getSource(current));
                            ArrayList targets = new ArrayList(this.linkMappingHelper.getTarget(current));
                            sourceRequest = request.getSource();
                            EObject targetRequest = request.getTarget();
                            if (!sources.contains(sourceRequest) || !targets.contains(targetRequest)) continue;
                            identicalAssociation = true;
                            if (!sourceRequest.equals(targetRequest)) break block9;
                            identicalAssociation = false;
                            Property firstEnd = AssociationUtil.getInitialTargetFirstEnd((Association)current);
                            Property secondEnd = AssociationUtil.getInitialSourceSecondEnd((Association)current);
                            if (firstEnd == null || secondEnd == null || !firstEnd.getType().equals(secondEnd.getType())) break block10;
                            boolean checkSourceAndTarget = this.checkReflexiveAssociation(request, firstEnd, secondEnd);
                            if (!checkSourceAndTarget) {
                                checkSourceAndTarget = this.checkReflexiveAssociation(request, secondEnd, firstEnd);
                            }
                            if (!checkSourceAndTarget) break block10;
                            identicalAssociation = true;
                            break block10;
                        }
                        Iterator iterator = ((Association)current).getMemberEnds().iterator();
                        while (iterator.hasNext() && identicalAssociation) {
                            Property property = (Property)iterator.next();
                            boolean isSource = sourceRequest.equals(property.getType());
                            boolean expectedNavigable = this.getExpectedNavigable(isSource, request);
                            if (AssociationUtil.isIdenticalProperties(expectedNavigable, AggregationKind.NONE_LITERAL, property)) continue;
                            identicalAssociation = false;
                        }
                    }
                    if (!identicalAssociation) continue;
                    existingElement.add(new LinkEndsMapper((EObject)current, sources, null, null));
                }
                break block11;
            }
            if (UMLPackage.eINSTANCE.getTransition().equals(wantedEClass)) {
                for (Element current : ((Region)request.getContainer()).getTransitions()) {
                    if (!this.hasWantedType((EObject)current, wantedElementType)) continue;
                    Collection<?> sources = this.linkMappingHelper.getSource(current);
                    Collection<?> targets = this.linkMappingHelper.getTarget(current);
                    if (!sources.contains(request.getSource()) || !targets.contains(request.getTarget())) continue;
                    existingElement.add(new LinkEndsMapper((EObject)current, null, sources, targets));
                }
            } else {
                for (Element current : ((Element)request.getContainer()).getOwnedElements()) {
                    if (!this.hasWantedType((EObject)current, wantedElementType)) continue;
                    Collection<?> sources = this.linkMappingHelper.getSource(current);
                    Collection<?> targets = this.linkMappingHelper.getTarget(current);
                    if (!sources.contains(request.getSource()) || !targets.contains(request.getTarget())) continue;
                    if (UMLPackage.eINSTANCE.getConnector().equals(wantedEClass)) {
                        existingElement.add(new LinkEndsMapper((EObject)current, sources, null, null));
                        continue;
                    }
                    existingElement.add(new LinkEndsMapper((EObject)current, null, sources, targets));
                }
            }
        }
        return existingElement;
    }

    private boolean checkReflexiveAssociation(CreateRelationshipRequest request, Property firstProperty, Property secondProperty) {
        boolean expectedNavigable = this.getExpectedNavigable(true, request);
        if (!AssociationUtil.isIdenticalProperties(expectedNavigable, AggregationKind.NONE_LITERAL, firstProperty)) {
            return false;
        }
        expectedNavigable = this.getExpectedNavigable(false, request);
        return AssociationUtil.isIdenticalProperties(expectedNavigable, AggregationKind.NONE_LITERAL, secondProperty);
    }

    public static final ICommand getOpenLinkDialogCommand(final CreateRelationshipRequest request, final Command defaultCommand, final CreateOrShowExistingLinkDialog dialog, List<LinkEndsMapper> existingEObject) {
        AbstractTransactionalCommand compoundCommand = new AbstractTransactionalCommand(request.getEditingDomain(), "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int result = dialog.open();
                switch (result) {
                    case 0: {
                        defaultCommand.execute();
                        return CommandResult.newOKCommandResult((Object)request.getNewElement());
                    }
                    case 1: {
                        EObject selectedElement = dialog.getResult();
                        if (selectedElement != null) {
                            request.setNewElement(selectedElement);
                            return CommandResult.newOKCommandResult((Object)selectedElement);
                        }
                        return CommandResult.newErrorCommandResult((String)"The selected element in the dialog is null");
                    }
                }
                return CommandResult.newCancelledCommandResult();
            }

            public boolean canExecute() {
                return defaultCommand.canExecute();
            }
        };
        return compoundCommand;
    }

    public ILinkMappingHelper getLinkMappingHelper() {
        return this.linkMappingHelper;
    }
}

