/**
 * Copyright (c) 2007, 2010, 2014 Borland Software Corporation, CEA, and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Borland) - [243151] explicit source/target for links
 *    Michael Golubev (Montages) - API extracted to gmf.tooling.runtime, template migrated to Xtend2
 *    Christian W. Damus (CEA) - bug 426732: override the cross-reference searches for views to use the CrossReferenceAdapter
 */
package aspects.xpt.diagram.updater;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramUpdater;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class NodeDescriptor extends xpt.diagram.updater.NodeDescriptor {
  @Inject
  @Extension
  private Common _common;
  
  @Override
  public CharSequence extendsList(final GenDiagramUpdater it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.papyrus.infra.gmfdiag.common.updater.UpdaterNodeDescriptor");
    return _builder;
  }
  
  @Override
  public CharSequence constructor(final GenDiagramUpdater it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.emf.ecore.EObject modelElement, String visualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(modelElement, visualID);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
