package aspects.xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.editor.CreationWizardPage;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.GenDiagram_qvto;

@Singleton
@SuppressWarnings("all")
public class CreationWizard extends xpt.editor.CreationWizard {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;
  
  @Inject
  @Extension
  private GenDiagram_qvto _genDiagram_qvto;
  
  @Inject
  private Activator xptActivator;
  
  @Inject
  private CreationWizardPage xptCreationWizardPage;
  
  @Inject
  private DiagramEditorUtil xptDiagramEditorUtil;
  
  @Inject
  private Externalizer xptExternalizer;
  
  @Override
  public CharSequence CreationWizard(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList, "\t\t");
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList, "\t\t");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.ui.IWorkbench workbench;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t   ");
    _builder.append("protected org.eclipse.jface.viewers.IStructuredSelection selection;");
    _builder.newLine();
    _builder.append("\t   ");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected ");
    CharSequence _qualifiedClassName = this.xptCreationWizardPage.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t");
    _builder.append(" diagramModelFilePage;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      boolean _standaloneDomainModel = this._genDiagram_qvto.standaloneDomainModel(it);
      if (_standaloneDomainModel) {
        _builder.append("\t");
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected ");
        CharSequence _qualifiedClassName_1 = this.xptCreationWizardPage.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_1, "\t");
        _builder.append(" domainModelFilePage;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.emf.ecore.resource.Resource diagram;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private boolean openNewlyCreatedDiagramEditor = true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t   ");
    _builder.append("public org.eclipse.ui.IWorkbench getWorkbench() {");
    _builder.newLine();
    _builder.append("\t       ");
    _builder.append("return workbench;");
    _builder.newLine();
    _builder.append("\t   ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t   ");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.jface.viewers.IStructuredSelection getSelection() {");
    _builder.newLine();
    _builder.append("\t       ");
    _builder.append("return selection;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_8, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public final org.eclipse.emf.ecore.resource.Resource getDiagram() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return diagram;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_9, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public final boolean isOpenNewlyCreatedDiagramEditor() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return openNewlyCreatedDiagramEditor;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_10, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_11 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_11, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void init(org.eclipse.ui.IWorkbench workbench, org.eclipse.jface.viewers.IStructuredSelection selection) {");
    _builder.newLine();
    _builder.append("\t       ");
    _builder.append("this.workbench = workbench;");
    _builder.newLine();
    _builder.append("\t       ");
    _builder.append("this.selection = selection;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("setWindowTitle(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizard(it)));
    _builder.append(_accessorCall, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("setDefaultPageImageDescriptor(");
    CharSequence _qualifiedClassName_2 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_2, "\t");
    _builder.append(".getBundledImageDescriptor(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("\"icons/wizban/New");
    {
      GenClass _domainDiagramElement = it.getDomainDiagramElement();
      boolean _notEquals = (!Objects.equal(_domainDiagramElement, null));
      if (_notEquals) {
        String _prefix = it.getDomainDiagramElement().getGenPackage().getPrefix();
        _builder.append(_prefix, "\t\t\t");
      }
    }
    _builder.append("Wizard.gif\")); //$NON-NLS-1$");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("setNeedsProgressMonitor(true);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_12 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_12, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void addPages() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("diagramModelFilePage = new ");
    CharSequence _qualifiedClassName_3 = this.xptCreationWizardPage.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_3, "\t\t");
    _builder.append("(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("\"DiagramModelFile\", getSelection(), \"");
    String _diagramFileExtension = it.getEditorGen().getDiagramFileExtension();
    _builder.append(_diagramFileExtension, "\t\t\t\t");
    _builder.append("\"); //$NON-NLS-1$ //$NON-NLS-2$");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramModelFilePage.setTitle(");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizardDiagramPage(it)));
    _builder.append(_accessorCall_1, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("diagramModelFilePage.setDescription(");
    CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
      this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForCreationWizardDiagramPage(it)));
    _builder.append(_accessorCall_2, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("addPage(diagramModelFilePage);");
    _builder.newLine();
    {
      boolean _standaloneDomainModel_1 = this._genDiagram_qvto.standaloneDomainModel(it);
      if (_standaloneDomainModel_1) {
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("domainModelFilePage = new ");
        CharSequence _qualifiedClassName_4 = this.xptCreationWizardPage.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_4, "\t\t");
        _builder.append("(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("\"DomainModelFile\", getSelection(), \"");
        String _domainFileExtension = it.getEditorGen().getDomainFileExtension();
        _builder.append(_domainFileExtension, "\t\t\t\t");
        _builder.append("\") { //$NON-NLS-1$ //$NON-NLS-2$");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public void setVisible(boolean visible) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("if (visible) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("String fileName = diagramModelFilePage.getFileName();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("fileName = fileName.substring(0, fileName.length() - \".");
        String _diagramFileExtension_1 = it.getEditorGen().getDiagramFileExtension();
        _builder.append(_diagramFileExtension_1, "\t\t\t\t");
        _builder.append("\".length()); //$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("setFileName(");
        CharSequence _qualifiedClassName_5 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append(_qualifiedClassName_5, "\t\t\t\t");
        _builder.append(".getUniqueFileName(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t\t\t");
        _builder.append("getContainerFullPath(), fileName, \"");
        String _domainFileExtension_1 = it.getEditorGen().getDomainFileExtension();
        _builder.append(_domainFileExtension_1, "\t\t\t\t\t\t");
        _builder.append("\")); //$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("super.setVisible(visible);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("domainModelFilePage.setTitle(");
        CharSequence _accessorCall_3 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
          this._externalizerUtils_qvto.titleKey(this.i18nKeyForCreationWizardDomainPage(it)));
        _builder.append(_accessorCall_3, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("domainModelFilePage.setDescription(");
        CharSequence _accessorCall_4 = this.xptExternalizer.accessorCall(it.getEditorGen(), 
          this._externalizerUtils_qvto.descriptionKey(this.i18nKeyForCreationWizardDomainPage(it)));
        _builder.append(_accessorCall_4, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("addPage(domainModelFilePage);");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_13 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_13, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean performFinish() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.jface.operation.IRunnableWithProgress op =");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(_application, null);
      if (_equals) {
        _builder.append("\t");
        _builder.append("new org.eclipse.ui.actions.WorkspaceModifyOperation(null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
        _builder.append(_overrideC_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("protected void execute(org.eclipse.core.runtime.IProgressMonitor monitor)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("throws org.eclipse.core.runtime.CoreException, InterruptedException {");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("new org.eclipse.jface.operation.IRunnableWithProgress() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("public void run(org.eclipse.core.runtime.IProgressMonitor monitor)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("throws InvocationTargetException, InterruptedException {");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("diagram = ");
    CharSequence _qualifiedClassName_6 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_6, "\t");
    _builder.append(".createDiagram(diagramModelFilePage.getURI(),");
    _builder.newLineIfNotEmpty();
    {
      boolean _standaloneDomainModel_2 = this._genDiagram_qvto.standaloneDomainModel(it);
      if (_standaloneDomainModel_2) {
        _builder.append("\t");
        _builder.append("domainModelFilePage.getURI(),");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("monitor);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (isOpenNewlyCreatedDiagramEditor() && diagram != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName_7 = this.xptDiagramEditorUtil.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_7, "\t\t\t");
    _builder.append(".openDiagram(diagram);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} catch (org.eclipse.ui.PartInitException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.jface.dialogs.ErrorDialog.openError(getContainer().getShell(),");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    CharSequence _accessorCall_5 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForCreationWizardOpenEditorError(it));
    _builder.append(_accessorCall_5, "\t\t\t\t\t");
    _builder.append(", null, e.getStatus());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("getContainer().run(false, true, op);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (InterruptedException e) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} catch (java.lang.reflect.InvocationTargetException e) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (e.getTargetException() instanceof org.eclipse.core.runtime.CoreException) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.jface.dialogs.ErrorDialog.openError(getContainer().getShell(),");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    CharSequence _accessorCall_6 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForCreationWizardCreationError(it));
    _builder.append(_accessorCall_6, "\t\t\t\t\t");
    _builder.append(", null,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("((org.eclipse.core.runtime.CoreException) e.getTargetException()).getStatus());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _qualifiedClassName_8 = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName_8, "\t\t\t");
    _builder.append(".getInstance().logError(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t");
    _builder.append("\"Error creating diagram\", e.getTargetException()); //$NON-NLS-1$");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return diagram != null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
