/**
 * Copyright (c) 2006-2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.xpt;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.papyrusgmfgenextension.VisualIDOverride;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
@SuppressWarnings("all")
public class Common extends xpt.Common {
  @Override
  public CharSequence copyright(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      String _copyrightText = it.getCopyrightText();
      boolean _notEquals = (!Objects.equal(_copyrightText, null));
      if (_notEquals) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        String _replaceAll = it.getCopyrightText().replaceAll("\n", "\n * ");
        _builder.append(_replaceAll, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public String stringVisualID(final GenCommonBase it) {
    String _xifexpression = null;
    final Function1<VisualIDOverride, Boolean> _function = new Function1<VisualIDOverride, Boolean>() {
      @Override
      public Boolean apply(final VisualIDOverride v) {
        GenCommonBase _genView = v.getGenView();
        return Boolean.valueOf(Objects.equal(_genView, it));
      }
    };
    boolean _exists = IteratorExtensions.<VisualIDOverride>exists(Iterators.<VisualIDOverride>filter(it.eResource().getAllContents(), VisualIDOverride.class), _function);
    if (_exists) {
      final Function1<VisualIDOverride, Boolean> _function_1 = new Function1<VisualIDOverride, Boolean>() {
        @Override
        public Boolean apply(final VisualIDOverride v) {
          GenCommonBase _genView = v.getGenView();
          return Boolean.valueOf(Objects.equal(_genView, it));
        }
      };
      _xifexpression = IteratorExtensions.<VisualIDOverride>findFirst(Iterators.<VisualIDOverride>filter(it.eResource().getAllContents(), VisualIDOverride.class), _function_1).getVisualID();
    } else {
      _xifexpression = Integer.valueOf(it.getVisualID()).toString();
    }
    return _xifexpression;
  }
  
  public String stringUniqueIdentifier(final GenCommonBase it) {
    String _xifexpression = null;
    final Function1<VisualIDOverride, Boolean> _function = new Function1<VisualIDOverride, Boolean>() {
      @Override
      public Boolean apply(final VisualIDOverride v) {
        GenCommonBase _genView = v.getGenView();
        return Boolean.valueOf(Objects.equal(_genView, it));
      }
    };
    boolean _exists = IteratorExtensions.<VisualIDOverride>exists(Iterators.<VisualIDOverride>filter(it.eResource().getAllContents(), VisualIDOverride.class), _function);
    if (_exists) {
      final Function1<VisualIDOverride, Boolean> _function_1 = new Function1<VisualIDOverride, Boolean>() {
        @Override
        public Boolean apply(final VisualIDOverride v) {
          GenCommonBase _genView = v.getGenView();
          return Boolean.valueOf(Objects.equal(_genView, it));
        }
      };
      _xifexpression = IteratorExtensions.<VisualIDOverride>findFirst(Iterators.<VisualIDOverride>filter(it.eResource().getAllContents(), VisualIDOverride.class), _function_1).getVisualID();
    } else {
      _xifexpression = it.getUniqueIdentifier();
    }
    return _xifexpression;
  }
}
