/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.internal.operations;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.papyrus.dev.project.management.internal.operations.AbstractManifestUpdateOperation;
import org.eclipse.papyrus.dev.project.management.internal.operations.DependencyAnalysisContext;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.papyrus.infra.tools.util.Iterables2;
import org.eclipse.pde.core.project.IRequiredBundleDescription;

public class OptimizeDependenciesOperation
extends AbstractManifestUpdateOperation {
    public OptimizeDependenciesOperation(Map<? extends IFile, ? extends IManifestEditor> manifests) {
        super("Optimize Bundle Dependencies", manifests);
    }

    @Override
    protected IStatus doExecute(IProgressMonitor monitor, Map<? extends IFile, ? extends IManifestEditor> manifests) throws ExecutionException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Analyzing ...", (int)(manifests.size() + 1));
        sub.split(1).beginTask("Initializing", -1);
        DependencyAnalysisContext analysisContext = new DependencyAnalysisContext(manifests.keySet());
        List bundles = Iterables2.topoSort(analysisContext.getAnalysisRoots(), DependencyAnalysisContext.BundleAnalysis::partialCompare);
        for (DependencyAnalysisContext.BundleAnalysis bundle : bundles) {
            IManifestEditor editor = manifests.get(bundle.getManifest());
            SubMonitor step = sub.split(1);
            if (step.isCanceled()) {
                throw new OperationCanceledException();
            }
            editor.init();
            this.optimizeDependencies(bundle, editor, (IProgressMonitor)step);
        }
        return Status.OK_STATUS;
    }

    private void optimizeDependencies(DependencyAnalysisContext.BundleAnalysis bundle, IManifestEditor manifest, IProgressMonitor monitor) {
        monitor.beginTask(bundle.getBundleID(), -1);
        bundle.pushMonitor(monitor);
        try {
            DependencyAnalysisContext.DependencyGraph graph = bundle.getDependencyGraph();
            DependencyAnalysisContext.APIExports api = bundle.getAPIExports();
            for (IRequiredBundleDescription requireBundle : manifest.getRequiredBundles()) {
                String required = requireBundle.getName();
                if (graph.isRedundant(required)) {
                    manifest.removeRequiredBundle(required);
                    graph.removeDependency(required);
                    continue;
                }
                if (!api.isExposed(required) || requireBundle.isExported()) continue;
                manifest.setRequiredBundleExported(required, true);
                graph.reexport(required);
            }
        }
        finally {
            bundle.popMonitor();
        }
    }
}

