/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ocl.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EDataTypeImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ocl.expressions.CollectionKind;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.ExpressionsPackage;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.internal.OCLPlugin;
import org.eclipse.emf.ocl.internal.parser.CompatibilityParser;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.types.BagType;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.OrderedSetType;
import org.eclipse.emf.ocl.types.SequenceType;
import org.eclipse.emf.ocl.types.SetType;
import org.eclipse.emf.ocl.types.TypesFactory;
import org.eclipse.emf.ocl.types.TypesPackage;
import org.eclipse.emf.ocl.types.impl.AnyTypeImpl;
import org.eclipse.emf.ocl.types.impl.SetTypeImpl;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.emf.ocl.utilities.ASTNode;
import org.eclipse.emf.ocl.utilities.PredefinedType;
import org.eclipse.emf.ocl.utilities.TypedASTNode;
import org.eclipse.emf.ocl.utilities.impl.Bag;
import org.eclipse.emf.ocl.utilities.impl.CollectionFactory;
import org.eclipse.ocl.internal.l10n.OCLMessages;

public class CollectionTypeImpl
extends EDataTypeImpl
implements CollectionType {
    public static final String copyright = "";
    protected static final int START_POSITION_EDEFAULT = -1;
    protected int startPosition = -1;
    protected static final int END_POSITION_EDEFAULT = -1;
    protected int endPosition = -1;
    protected static final int TYPE_START_POSITION_EDEFAULT = -1;
    protected int typeStartPosition = -1;
    protected static final int TYPE_END_POSITION_EDEFAULT = -1;
    protected int typeEndPosition = -1;
    private static CollectionFactory collFactory = CollectionFactory.getInstance();
    public static SequenceType OCL_SEQUENCE = TypesPackage.eINSTANCE.getTypesFactory().createSequenceType(AnyTypeImpl.OCL_T);
    public static SetType OCL_SET = TypesPackage.eINSTANCE.getTypesFactory().createSetType(AnyTypeImpl.OCL_T);
    public static OrderedSetType OCL_ORDERED_SET = TypesPackage.eINSTANCE.getTypesFactory().createOrderedSetType(AnyTypeImpl.OCL_T);
    public static BagType OCL_BAG = TypesPackage.eINSTANCE.getTypesFactory().createBagType(AnyTypeImpl.OCL_T);
    public static CollectionType OCL_COLLECTION = TypesPackage.eINSTANCE.getTypesFactory().createCollectionType(AnyTypeImpl.OCL_T);
    private static final String PRODUCT_FIRST = "first";
    private static final String PRODUCT_SECOND = "second";
    private static EList operations;
    private static EList iterators;
    protected EClassifier elementType;
    protected static final CollectionKind KIND_EDEFAULT;

    static {
        KIND_EDEFAULT = CollectionKind.COLLECTION_LITERAL;
    }

    public int getOperationCodeFor(String oper) {
        if (oper.equals("count")) {
            return 140;
        }
        if (oper.equals("size")) {
            return 20;
        }
        if (oper.equals("=")) {
            return 60;
        }
        if (oper.equals("<>")) {
            return 61;
        }
        if (oper.equals("excludes")) {
            return 141;
        }
        if (oper.equals("excludesAll")) {
            return 142;
        }
        if (oper.equals("includes")) {
            return 143;
        }
        if (oper.equals("includesAll")) {
            return 144;
        }
        if (oper.equals("isEmpty")) {
            return 145;
        }
        if (oper.equals("notEmpty")) {
            return 146;
        }
        if (oper.equals("product")) {
            return 147;
        }
        if (oper.equals("sum")) {
            return 148;
        }
        if (oper.equals("asBag")) {
            return 149;
        }
        if (oper.equals("asOrderedSet")) {
            return 150;
        }
        if (oper.equals("asSequence")) {
            return 151;
        }
        if (oper.equals("asSet")) {
            return 152;
        }
        if (oper.equals("excluding")) {
            return 153;
        }
        if (oper.equals("flatten")) {
            return 154;
        }
        if (oper.equals("including")) {
            return 155;
        }
        if (oper.equals("intersection")) {
            return 156;
        }
        if (oper.equals("union")) {
            return 157;
        }
        if (oper.equals("at")) {
            return 158;
        }
        if (oper.equals(PRODUCT_FIRST)) {
            return 159;
        }
        if (oper.equals("indexOf")) {
            return 160;
        }
        if (oper.equals("insertAt")) {
            return 161;
        }
        if (oper.equals("last")) {
            return 162;
        }
        if (oper.equals("prepend")) {
            return 163;
        }
        if (oper.equals("subSequence")) {
            return 164;
        }
        if (oper.equals("append")) {
            return 165;
        }
        if (oper.equals("subOrderedSet")) {
            return 166;
        }
        if (oper.equals("-")) {
            return 2;
        }
        if (oper.equals("symmetricDifference")) {
            return 167;
        }
        if (oper.equals("exists")) {
            return 201;
        }
        if (oper.equals("forAll")) {
            return 202;
        }
        if (oper.equals("isUnique")) {
            return 203;
        }
        if (oper.equals("one")) {
            return 204;
        }
        if (oper.equals("any")) {
            return 205;
        }
        if (oper.equals("collect")) {
            return 206;
        }
        if (oper.equals("collectNested")) {
            return 207;
        }
        if (oper.equals("closure")) {
            return 208;
        }
        if (oper.equals("select")) {
            return 209;
        }
        if (oper.equals("reject")) {
            return 210;
        }
        if (oper.equals("sortedBy")) {
            return 211;
        }
        return 0;
    }

    public String getOperationNameFor(int opcode) {
        switch (opcode) {
            case 140: {
                return "count";
            }
            case 20: {
                return "size";
            }
            case 60: {
                return "=";
            }
            case 61: {
                return "<>";
            }
            case 141: {
                return "excludes";
            }
            case 142: {
                return "excludesAll";
            }
            case 143: {
                return "includes";
            }
            case 144: {
                return "includesAll";
            }
            case 145: {
                return "isEmpty";
            }
            case 146: {
                return "notEmpty";
            }
            case 147: {
                return "product";
            }
            case 148: {
                return "sum";
            }
            case 149: {
                return "asBag";
            }
            case 150: {
                return "asOrderedSet";
            }
            case 151: {
                return "asSequence";
            }
            case 152: {
                return "asSet";
            }
            case 153: {
                return "excluding";
            }
            case 154: {
                return "flatten";
            }
            case 155: {
                return "including";
            }
            case 156: {
                return "intersection";
            }
            case 157: {
                return "union";
            }
            case 158: {
                return "at";
            }
            case 159: {
                return PRODUCT_FIRST;
            }
            case 160: {
                return "indexOf";
            }
            case 161: {
                return "insertAt";
            }
            case 162: {
                return "last";
            }
            case 163: {
                return "prepend";
            }
            case 164: {
                return "subSequence";
            }
            case 165: {
                return "append";
            }
            case 166: {
                return "subOrderedSet";
            }
            case 2: {
                return "-";
            }
            case 167: {
                return "symmetricDifference";
            }
            case 201: {
                return "exists";
            }
            case 202: {
                return "forAll";
            }
            case 203: {
                return "isUnique";
            }
            case 204: {
                return "one";
            }
            case 205: {
                return "any";
            }
            case 206: {
                return "collect";
            }
            case 207: {
                return "collectNested";
            }
            case 208: {
                return "closure";
            }
            case 209: {
                return "select";
            }
            case 210: {
                return "reject";
            }
            case 211: {
                return "sortedBy";
            }
        }
        return copyright;
    }

    protected static EList createOperations() {
        BasicEList result = new BasicEList();
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_INTEGER, "count", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "excludes", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "excludesAll", (EClassifier)OCL_COLLECTION, "c2"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "includes", AnyTypeImpl.OCL_T, "object"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "includesAll", (EClassifier)OCL_COLLECTION, "c2"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_BOOLEAN, "isEmpty"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_BOOLEAN, "notEmpty"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)new SetTypeImpl((EClassifier)TypesFactory.eINSTANCE.createTupleType(CollectionTypeImpl.createTupleParts(new String[]{PRODUCT_FIRST, PRODUCT_SECOND}, new EClassifier[]{AnyTypeImpl.OCL_T, AnyTypeImpl.OCL_T2}))), "product", (EClassifier)new CollectionTypeImpl(AnyTypeImpl.OCL_T2), "c2"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_REAL, "sum"));
        result.add((Object)TypeUtil.createUnaryOperation((EClassifier)Types.OCL_INTEGER, "size"));
        return result;
    }

    protected static EList createIterators() {
        BasicEList result = new BasicEList();
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "exists", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "forAll", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "isUnique", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)Types.OCL_BOOLEAN, "one", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation(AnyTypeImpl.OCL_T, "any", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)TypesFactory.eINSTANCE.createCollectionType(AnyTypeImpl.OCL_T2), "collect", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        result.add((Object)TypeUtil.createBinaryOperation((EClassifier)TypesFactory.eINSTANCE.createSetType(AnyTypeImpl.OCL_T2), "closure", (EClassifier)ExpressionsPackage.Literals.OCL_EXPRESSION, "expr"));
        return result;
    }

    public EList getOperations() {
        if (operations == null) {
            operations = CollectionTypeImpl.createOperations();
        }
        return operations;
    }

    public EList getIterators() {
        if (iterators == null) {
            iterators = CollectionTypeImpl.createIterators();
        }
        return iterators;
    }

    protected CollectionTypeImpl() {
    }

    protected CollectionTypeImpl(EClassifier elementType) {
        this.elementType = elementType;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.elementType != null ? "Collection(" + this.elementType.getName() + ')' : "Collection(?)";
        }
        return super.getName();
    }

    public EClassifier getResultTypeFor(EClassifier ownerType, int opcode, EList args) throws SemanticException {
        switch (opcode) {
            case 20: 
            case 140: {
                return Types.OCL_INTEGER;
            }
            case 60: 
            case 61: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: {
                return Types.OCL_BOOLEAN;
            }
            case 148: {
                EClassifier type = this.getElementType();
                if (type != Types.OCL_REAL && type != Types.OCL_INTEGER) {
                    String message = OCLMessages.SumOperator_ERROR_;
                    CompatibilityParser.ERR(message);
                }
                return type;
            }
            case 147: {
                EClassifier t = this.getElementType();
                OCLExpression arg = (OCLExpression)args.get(0);
                CollectionType argType = (CollectionType)arg.getType();
                EClassifier t2 = argType.getElementType();
                SetType resultType = TypesFactory.eINSTANCE.createSetType();
                resultType.setElementType((EClassifier)TypesFactory.eINSTANCE.createTupleType(CollectionTypeImpl.createTupleParts(new String[]{PRODUCT_FIRST, PRODUCT_SECOND}, new EClassifier[]{t, t2})));
                return resultType;
            }
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                return Types.OCL_BOOLEAN;
            }
            case 205: {
                return this.getElementType();
            }
            case 206: {
                return TypesFactory.eINSTANCE.createCollectionType(AnyTypeImpl.OCL_T2);
            }
            case 208: {
                return TypesFactory.eINSTANCE.createSetType(AnyTypeImpl.OCL_T2);
            }
        }
        String message = OCLMessages.bind((String)OCLMessages.CollectionType_ERROR_, (Object)this.getName(), (Object)this.getOperationNameFor(opcode));
        CompatibilityParser.ERR(message);
        return null;
    }

    private static List createTupleParts(String[] names, EClassifier[] types) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        int i = 0;
        while (i < names.length) {
            Variable var = ExpressionsFactory.eINSTANCE.createVariable();
            var.setName(names[i]);
            var.setType(types[i]);
            result.add(var);
            ++i;
        }
        return result;
    }

    public int getRelationshipTo(EClassifier type) {
        if (!(type instanceof CollectionType)) {
            return 8;
        }
        CollectionType other = (CollectionType)type;
        int kindRelationship = CollectionTypeImpl.getRelationship(this.getKind(), other.getKind());
        if (kindRelationship == 8) {
            return kindRelationship;
        }
        int elementRelationship = TypeUtil.getRelationship(this.getElementType(), other.getElementType());
        switch (kindRelationship) {
            case 1: {
                return elementRelationship;
            }
            case 2: {
                switch (elementRelationship) {
                    case 1: 
                    case 2: {
                        return 2;
                    }
                }
                return 8;
            }
            case 4: {
                switch (elementRelationship) {
                    case 1: 
                    case 4: {
                        return 4;
                    }
                }
                return 8;
            }
        }
        return 8;
    }

    public EClassifier getCommonSupertype(EClassifier type) throws SemanticException {
        if (!(type instanceof CollectionType)) {
            String message = OCLMessages.bind((String)OCLMessages.TypeMismatch_ERROR_, (Object)this.getName(), (Object)TypeUtil.getName((ENamedElement)type));
            CompatibilityParser.ERR(message);
        }
        CollectionType other = (CollectionType)type;
        CollectionKind commonKind = CollectionTypeImpl.commonSuperType(this.getKind(), other.getKind());
        EClassifier resultElementType = TypeUtil.commonSuperType(this.getElementType(), other.getElementType());
        return TypesFactory.eINSTANCE.createCollectionType(commonKind, resultElementType);
    }

    public static CollectionKind commonSuperType(CollectionKind kind1, CollectionKind kind2) {
        switch (kind1.getValue()) {
            case 3: {
                switch (kind2.getValue()) {
                    case 3: {
                        return CollectionKind.BAG_LITERAL;
                    }
                }
                return CollectionKind.COLLECTION_LITERAL;
            }
            case 4: {
                switch (kind2.getValue()) {
                    case 4: {
                        return CollectionKind.SEQUENCE_LITERAL;
                    }
                }
                return CollectionKind.COLLECTION_LITERAL;
            }
            case 2: {
                switch (kind2.getValue()) {
                    case 2: 
                    case 5: {
                        return CollectionKind.SET_LITERAL;
                    }
                }
                return CollectionKind.COLLECTION_LITERAL;
            }
            case 5: {
                switch (kind2.getValue()) {
                    case 5: {
                        return CollectionKind.ORDERED_SET_LITERAL;
                    }
                    case 2: {
                        return CollectionKind.SET_LITERAL;
                    }
                }
                return CollectionKind.COLLECTION_LITERAL;
            }
        }
        return CollectionKind.COLLECTION_LITERAL;
    }

    public static int getRelationship(CollectionKind kind1, CollectionKind kind2) {
        switch (kind1.getValue()) {
            case 3: {
                switch (kind2.getValue()) {
                    case 3: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                }
                return 8;
            }
            case 2: {
                switch (kind2.getValue()) {
                    case 2: {
                        return 1;
                    }
                    case 5: {
                        return 4;
                    }
                    case 1: {
                        return 2;
                    }
                }
                return 8;
            }
            case 5: {
                switch (kind2.getValue()) {
                    case 5: {
                        return 1;
                    }
                    case 1: 
                    case 2: {
                        return 2;
                    }
                }
                return 8;
            }
            case 4: {
                switch (kind2.getValue()) {
                    case 4: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                }
                return 8;
            }
        }
        switch (kind2.getValue()) {
            case 1: {
                return 1;
            }
        }
        return 4;
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.COLLECTION_TYPE;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int newStartPosition) {
        int oldStartPosition = this.startPosition;
        this.startPosition = newStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldStartPosition, this.startPosition));
        }
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(int newEndPosition) {
        int oldEndPosition = this.endPosition;
        this.endPosition = newEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldEndPosition, this.endPosition));
        }
    }

    public int getTypeStartPosition() {
        return this.typeStartPosition;
    }

    public void setTypeStartPosition(int newTypeStartPosition) {
        int oldTypeStartPosition = this.typeStartPosition;
        this.typeStartPosition = newTypeStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldTypeStartPosition, this.typeStartPosition));
        }
    }

    public int getTypeEndPosition() {
        return this.typeEndPosition;
    }

    public void setTypeEndPosition(int newTypeEndPosition) {
        int oldTypeEndPosition = this.typeEndPosition;
        this.typeEndPosition = newTypeEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldTypeEndPosition, this.typeEndPosition));
        }
    }

    public EClassifier getElementType() {
        if (this.elementType != null && this.elementType.eIsProxy()) {
            InternalEObject oldElementType = (InternalEObject)this.elementType;
            this.elementType = (EClassifier)this.eResolveProxy(oldElementType);
            if (this.elementType != oldElementType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 13, (Object)oldElementType, (Object)this.elementType));
            }
        }
        return this.elementType;
    }

    public EClassifier basicGetElementType() {
        return this.elementType;
    }

    public void setElementType(EClassifier newElementType) {
        EClassifier oldElementType = this.elementType;
        this.elementType = newElementType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldElementType, (Object)this.elementType));
        }
    }

    public CollectionKind getKind() {
        return CollectionKind.COLLECTION_LITERAL;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return new Integer(this.getStartPosition());
            }
            case 10: {
                return new Integer(this.getEndPosition());
            }
            case 11: {
                return new Integer(this.getTypeStartPosition());
            }
            case 12: {
                return new Integer(this.getTypeEndPosition());
            }
            case 13: {
                if (resolve) {
                    return this.getElementType();
                }
                return this.basicGetElementType();
            }
            case 14: {
                return this.getKind();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setStartPosition((Integer)newValue);
                return;
            }
            case 10: {
                this.setEndPosition((Integer)newValue);
                return;
            }
            case 11: {
                this.setTypeStartPosition((Integer)newValue);
                return;
            }
            case 12: {
                this.setTypeEndPosition((Integer)newValue);
                return;
            }
            case 13: {
                this.setElementType((EClassifier)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setStartPosition(-1);
                return;
            }
            case 10: {
                this.setEndPosition(-1);
                return;
            }
            case 11: {
                this.setTypeStartPosition(-1);
                return;
            }
            case 12: {
                this.setTypeEndPosition(-1);
                return;
            }
            case 13: {
                this.setElementType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.startPosition != -1;
            }
            case 10: {
                return this.endPosition != -1;
            }
            case 11: {
                return this.typeStartPosition != -1;
            }
            case 12: {
                return this.typeEndPosition != -1;
            }
            case 13: {
                return this.elementType != null;
            }
            case 14: {
                return this.getKind() != KIND_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass) {
        if (baseClass == ASTNode.class) {
            switch (derivedFeatureID) {
                case 9: {
                    return 0;
                }
                case 10: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (derivedFeatureID) {
                case 11: {
                    return 2;
                }
                case 12: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == PredefinedType.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        if (baseClass == ASTNode.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 9;
                }
                case 1: {
                    return 10;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (baseFeatureID) {
                case 2: {
                    return 11;
                }
                case 3: {
                    return 12;
                }
            }
            return -1;
        }
        if (baseClass == PredefinedType.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (startPosition: ");
        result.append(this.startPosition);
        result.append(", endPosition: ");
        result.append(this.endPosition);
        result.append(", typeStartPosition: ");
        result.append(this.typeStartPosition);
        result.append(", typeEndPosition: ");
        result.append(this.typeEndPosition);
        result.append(')');
        return result.toString();
    }

    public static int size(Set s) {
        return s.size();
    }

    public static boolean includes(Collection c, Object o) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!AnyTypeImpl.equal(iter.next(), o)) continue;
            return true;
        }
        return false;
    }

    public static boolean excludes(Collection c, Object o) {
        return !CollectionTypeImpl.includes(c, o);
    }

    public static int count(Collection c, Object o) {
        int count = 0;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (!AnyTypeImpl.equal(it.next(), o)) continue;
            ++count;
        }
        return count;
    }

    public static boolean includesAll(Collection c1, Collection c2) {
        Iterator iter = c2.iterator();
        while (iter.hasNext()) {
            if (CollectionTypeImpl.includes(c1, iter.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean excludesAll(Collection c1, Collection c2) {
        Iterator it = c2.iterator();
        while (it.hasNext()) {
            if (!CollectionTypeImpl.includes(c1, it.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Collection c) {
        return c.isEmpty();
    }

    public static boolean notEmpty(Collection c) {
        return !c.isEmpty();
    }

    public static Object sum(Collection c) {
        if (c.isEmpty()) {
            return null;
        }
        Iterator it = c.iterator();
        Object o = it.next();
        if (o instanceof Integer) {
            int currVal = 0;
            it = c.iterator();
            while (it.hasNext()) {
                currVal += ((Integer)it.next()).intValue();
            }
            return new Integer(currVal);
        }
        if (o instanceof Double) {
            double currVal = 0.0;
            it = c.iterator();
            while (it.hasNext()) {
                currVal += ((Double)it.next()).doubleValue();
            }
            return new Double(currVal);
        }
        RuntimeException error = new RuntimeException(OCLMessages.SumOperator_ERROR_);
        OCLPlugin.throwing(CollectionTypeImpl.class, "sum", error);
        throw error;
    }

    public static boolean equals(Collection c1, Collection c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1 instanceof Bag && c2 instanceof Bag) {
            return ((Bag)c1).equals(c2);
        }
        if (c1 instanceof List && c2 instanceof List) {
            return ((List)c1).equals(c2);
        }
        if (c1 instanceof LinkedHashSet && c2 instanceof LinkedHashSet) {
            int size2;
            int size1 = c1.size();
            if (size1 != (size2 = c2.size())) {
                return false;
            }
            Iterator it1 = c1.iterator();
            Iterator it2 = c2.iterator();
            while (it1.hasNext()) {
                Object o2;
                Object o1 = it1.next();
                if (o1.equals(o2 = it2.next())) continue;
                return false;
            }
            return true;
        }
        if (c1 instanceof Set && c2 instanceof Set) {
            return ((Set)c1).equals(c2);
        }
        return false;
    }

    public static int hashCode(Collection c) {
        int result = 1;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            result = 37 * AnyTypeImpl.hashCode(iter.next());
        }
        return result;
    }

    public static Collection intersection(Collection c1, Collection c2) {
        int size1 = c1.size();
        int size2 = c2.size();
        Collection result = null;
        if (c1 instanceof Set || c2 instanceof Set) {
            if (size1 == 0 || size2 == 0) {
                return Collections.EMPTY_SET;
            }
            result = CollectionTypeImpl.createNewSet();
        } else {
            if (size1 == 0 || size2 == 0) {
                return Bag.EMPTY_BAG;
            }
            result = CollectionTypeImpl.createNewBag();
        }
        if (c1.size() > c2.size()) {
            for (Object o : c2) {
                if (!CollectionTypeImpl.includes(c1, o)) continue;
                result.add(o);
            }
        } else {
            for (Object o : c1) {
                if (!CollectionTypeImpl.includes(c2, o)) continue;
                result.add(o);
            }
        }
        return result;
    }

    public static Collection union(Collection c1, Collection c2) {
        if (c1.isEmpty()) {
            return c2;
        }
        if (c2.isEmpty()) {
            return c1;
        }
        Collection result = null;
        result = c1 instanceof Bag || c2 instanceof Bag ? CollectionTypeImpl.createNewBag(c1) : (c1 instanceof List || c2 instanceof List ? CollectionTypeImpl.createNewSequence(c1) : CollectionTypeImpl.createNewSet(c1));
        result.addAll(c2);
        return result;
    }

    public static Collection flatten(Collection c) {
        if (c.isEmpty()) {
            return c;
        }
        Iterator it = c.iterator();
        Object o = it.next();
        if (!(o instanceof Collection)) {
            return c;
        }
        Collection result = null;
        result = c instanceof Bag ? CollectionTypeImpl.createNewBag() : (c instanceof Set ? CollectionTypeImpl.createNewSet() : CollectionTypeImpl.createNewSequence());
        it = c.iterator();
        while (it.hasNext()) {
            result.addAll((Collection)it.next());
        }
        return result;
    }

    public static Set minus(Set s1, Set s2) {
        Set result = (Set)CollectionTypeImpl.createNewSet(s1);
        result.removeAll(s2);
        return result;
    }

    public static Collection excluding(Collection c, Object o) {
        Collection result = null;
        if (c instanceof Set) {
            result = CollectionTypeImpl.createNewSet(c);
        } else if (c instanceof Bag) {
            result = CollectionTypeImpl.createNewBag(c);
        } else {
            if (c instanceof List) {
                List resultSeq = (List)CollectionTypeImpl.createNewSequence(c);
                while (resultSeq.remove(o)) {
                }
                return resultSeq;
            }
            result = CollectionTypeImpl.createNewOrderedSet(c);
        }
        result.remove(o);
        return result;
    }

    public static Set symmetricDifference(Set s1, Set s2) {
        Set result = (Set)CollectionTypeImpl.createNewSet(s1);
        for (Object o : s2) {
            if (result.contains(o)) {
                result.remove(o);
                continue;
            }
            result.add(o);
        }
        return result;
    }

    public static Collection including(Collection c, Object element) {
        Collection result = null;
        result = c instanceof Set ? CollectionTypeImpl.createNewSet(c) : (c instanceof Bag ? CollectionTypeImpl.createNewBag(c) : CollectionTypeImpl.createNewSequence(c));
        result.add(element);
        return result;
    }

    public static Collection asSet(Collection c) {
        if (c instanceof Set) {
            return c;
        }
        return CollectionTypeImpl.createNewSet(c);
    }

    public static Collection asBag(Collection c) {
        if (c instanceof Bag) {
            return c;
        }
        return CollectionTypeImpl.createNewBag(c);
    }

    public static Collection asSequence(Collection c) {
        if (c instanceof List) {
            return c;
        }
        return CollectionTypeImpl.createNewSequence(c);
    }

    public static Collection asOrderedSet(Collection c) {
        if (c instanceof LinkedHashSet) {
            return c;
        }
        return CollectionTypeImpl.createNewOrderedSet(c);
    }

    public static Set product(Collection c1, Collection c2, EClass resultType) {
        EStructuralFeature first = resultType.getEStructuralFeature(PRODUCT_FIRST);
        EStructuralFeature second = resultType.getEStructuralFeature(PRODUCT_SECOND);
        EFactory factory = resultType.getEPackage().getEFactoryInstance();
        Set result = (Set)CollectionTypeImpl.createNewSet();
        for (Object next1 : c1) {
            for (Object next2 : c2) {
                EObject tuple = factory.create(resultType);
                tuple.eSet(first, next1);
                tuple.eSet(second, next2);
                result.add(tuple);
            }
        }
        return result;
    }

    public static Collection append(Collection c, Object o) {
        Collection result = null;
        if (c instanceof LinkedHashSet) {
            result = CollectionTypeImpl.createNewOrderedSet(c);
            result.remove(o);
        } else {
            result = CollectionTypeImpl.createNewSequence(c);
        }
        result.add(o);
        return result;
    }

    public static Collection prepend(Collection c, Object o) {
        Collection result = null;
        result = c instanceof LinkedHashSet ? CollectionTypeImpl.createNewOrderedSet() : CollectionTypeImpl.createNewSequence();
        result.add(o);
        result.addAll(c);
        return result;
    }

    public static Collection insertAt(Collection c, int oclIndex, Object o) {
        int index = oclIndex - 1;
        Collection result = null;
        result = c instanceof LinkedHashSet ? CollectionTypeImpl.createNewOrderedSet() : CollectionTypeImpl.createNewSequence();
        if (index - 1 < 0 || index > c.size()) {
            return null;
        }
        int curr = 0;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (curr == index) {
                result.add(o);
            }
            result.add(it.next());
            ++curr;
        }
        return result;
    }

    public static Collection subOrderedSet(Collection c, int oclLower, int oclUpper) {
        int lower = oclLower - 1;
        int upper = oclUpper - 1;
        if (lower < 0 || upper >= c.size()) {
            return null;
        }
        Collection result = null;
        result = c instanceof LinkedHashSet ? CollectionTypeImpl.createNewOrderedSet() : CollectionTypeImpl.createNewSequence();
        int curr = 0;
        for (Object o : c) {
            if (curr >= lower && curr <= upper) {
                result.add(o);
            }
            ++curr;
        }
        return result;
    }

    public static Collection subSequence(Collection c, int oclLower, int oclUpper) {
        int lower = oclLower - 1;
        int upper = oclUpper - 1;
        if (lower < 0 || upper >= c.size()) {
            return null;
        }
        Collection result = CollectionTypeImpl.createNewSequence();
        int curr = 0;
        for (Object o : c) {
            if (curr >= lower && curr <= upper) {
                result.add(o);
            }
            ++curr;
        }
        return result;
    }

    public static Object at(Collection c, int i) {
        int curr = 0;
        for (Object o : c) {
            if (curr++ != i - 1) continue;
            return o;
        }
        return null;
    }

    public static Object first(Collection c) {
        if (c.isEmpty()) {
            return null;
        }
        return c.iterator().next();
    }

    public static Object last(Collection c) {
        if (c.isEmpty()) {
            return null;
        }
        Object result2 = null;
        for (Object result2 : c) {
        }
        return result2;
    }

    public static Integer indexOf(Collection c, Object o) {
        int index = 1;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (o.equals(it.next())) {
                return new Integer(index);
            }
            ++index;
        }
        return null;
    }

    public static Collection createNewSet() {
        return collFactory.createCollection(2);
    }

    public static Collection createNewSet(Collection c) {
        return collFactory.createCollection(2, c);
    }

    public static Collection createNewBag() {
        return collFactory.createCollection(3);
    }

    public static Collection createNewBag(Collection c) {
        return collFactory.createCollection(3, c);
    }

    public static Collection createNewOrderedSet() {
        return collFactory.createCollection(5);
    }

    public static Collection createNewOrderedSet(Collection c) {
        return collFactory.createCollection(5, c);
    }

    public static Collection createNewSequence() {
        return collFactory.createCollection(4);
    }

    public static Collection createNewSequence(Collection c) {
        return collFactory.createCollection(4, c);
    }
}

