/**
* <copyright>
*
* Copyright (c) 2005, 2009 IBM Corporation, Zeligsoft Inc., and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 225493, 243976, 259818
*   Zeligsoft - Bug 243976
*
* </copyright>
*
* $Id: OCLParserprs.java,v 1.6 2009/01/13 20:31:30 cdamus Exp $
*/

package org.eclipse.ocl.parser;

/**
 * @noextend This interface is not intended to be extended by clients.
 */
@SuppressWarnings("nls")
public class OCLParserprs implements lpg.lpgjavaruntime.ParseTable, OCLParsersym {

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,1,1,1,1,1,
            1,1,1,1,1,0,0,0,0,0,
            0,1,1,0,1,1,1,1,1,1,
            1,1,1,0,0,0,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,0,
            0,0,0,1,1,1,0,1,0,0,
            1,0,1,0,1,1,1,1,0,0,
            0,0,0,0,0,0,0,0,0,1,
            1,1,1,1,1,1,1,1,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static short baseCheck[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,6,8,0,1,1,3,
            0,1,1,1,1,1,3,3,1,1,
            3,3,3,3,3,3,1,1,3,3,
            3,3,1,1,3,3,3,3,3,3,
            3,3,1,1,1,1,3,3,3,3,
            1,1,3,3,3,3,1,1,2,2,
            1,2,2,4,6,1,1,1,1,3,
            2,2,5,5,1,1,1,1,1,1,
            1,1,1,1,1,1,1,3,0,1,
            1,1,1,1,1,1,3,3,4,1,
            1,1,1,1,0,1,1,3,1,1,
            3,2,3,1,1,1,1,1,4,1,
            1,1,1,1,1,1,1,2,2,2,
            2,1,1,4,6,8,6,8,1,3,
            1,5,3,0,1,1,1,1,1,4,
            4,0,1,1,3,1,1,3,3,1,
            1,5,5,5,1,5,2,2,5,0,
            1,0,1,1,3,4,7,5,5,0,
            1,1,3,1,1,3,1,1,1,1,
            1,1,0,1,2,4,1,0,1,1,
            2,1,1,1,7,4,4,0,1,3,
            1,2,4,4,3,3,3,1,2,4,
            4,4,-88,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -92,0,0,-2,-3,0,0,0,0,-122,
            -13,-4,0,0,-38,0,0,-41,0,0,
            -68,0,0,-96,0,0,-5,-94,0,0,
            -16,-40,0,0,0,0,0,0,0,0,
            0,0,0,-177,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-11,0,0,0,0,0,-157,
            -12,0,-17,-18,0,0,0,0,-97,0,
            0,-14,-19,-20,-21,-39,-22,-26,0,0,
            -178,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-27,0,0,
            -28,0,-29,-37,-42,-53,-54,-55,-56,-57,
            -6,0,0,-58,-59,0,0,-93,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-60,0,-7,
            0,0,-50,0,-121,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-61,0,0,-8,0,0,-51,
            0,-123,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -62,0,0,-9,0,0,-52,0,-165,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-63,0,-66,
            -67,-69,-71,-72,-73,-74,-75,-76,-77,-78,
            -79,-80,-10,0,0,-81,-82,0,0,-171,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-83,-84,
            0,-85,-86,-87,-100,0,-176,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-185,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-124,-125,-128,0,-129,-130,
            -131,-64,0,-90,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-132,-65,0,-91,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-133,-136,0,-174,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-134,-137,0,-205,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-135,-140,
            -141,-142,-143,-144,-145,-147,-148,-149,-150,-151,
            0,-30,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-31,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-32,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-33,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-34,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-36,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-43,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-49,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-70,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-113,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-114,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-120,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-126,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-146,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-163,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-164,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-167,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-168,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-195,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-201,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-203,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-211,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-212,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-109,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -110,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-111,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-112,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-103,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -104,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,-105,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -106,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,-107,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,-108,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-101,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,-102,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-98,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -99,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,-47,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,-48,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,-127,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,-95,0,0,-152,
            -153,0,0,0,0,0,0,0,0,-154,
            -155,-156,-15,0,-1,0,0,-158,-159,-160,
            -119,-161,-162,-172,-173,-138,-179,-23,-180,-196,
            0,-182,0,0,-183,-184,-186,-187,-188,-189,
            -190,-191,-192,-193,-194,-198,-197,0,-25,0,
            0,-44,0,-206,0,0,-207,-208,-24,-45,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            -139,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,-89,0,0,
            0,-35,-46,0,0,0,0,0,0,-166,
            0,0,0,0,-115,0,-116,0,0,-117,
            0,0,0,0,-204,0,0,0,0,-209,
            0,-118,0,-169,-210,-213,-214,0,-175,0,
            0,-181,0,-200,-170,0,0,-202,0,0,
            0,0,0,-199,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0
        };
    };
    public final static short baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            81,9,9,9,9,9,9,9,9,9,
            9,9,9,9,9,9,9,9,9,64,
            64,5,5,5,5,5,5,5,5,5,
            5,5,6,6,6,6,6,6,6,6,
            6,6,6,7,7,10,10,8,14,65,
            82,83,11,104,104,84,85,66,66,68,
            68,55,55,45,45,46,47,46,47,43,
            44,43,43,43,44,44,44,41,42,41,
            42,41,42,39,40,39,40,39,40,39,
            40,39,40,35,35,37,36,37,36,37,
            36,33,34,33,34,33,34,15,31,15,
            15,16,16,16,16,16,17,17,17,17,
            17,18,18,18,18,2,2,2,1,1,
            1,1,1,1,1,1,1,3,3,88,
            88,19,19,19,19,19,19,20,20,21,
            4,4,4,4,4,89,89,90,90,69,
            69,70,70,70,23,23,23,23,23,22,
            26,27,28,29,30,30,24,25,86,86,
            86,86,92,92,93,93,93,94,94,49,
            48,49,49,72,67,67,52,52,52,52,
            54,53,95,95,73,73,91,91,91,91,
            71,71,71,12,13,96,12,74,74,74,
            50,50,56,56,51,51,32,38,87,87,
            75,75,76,76,61,61,61,81,81,81,
            81,81,81,81,98,98,78,97,99,99,
            79,79,57,57,57,60,77,77,80,80,
            58,100,100,62,62,101,101,59,102,102,
            63,63,63,1,125,974,740,506,33,514,
            47,573,46,687,630,118,119,922,101,341,
            111,116,117,141,142,143,144,145,146,164,
            165,166,167,168,102,108,742,96,83,84,
            743,94,745,78,744,70,747,66,916,746,
            64,972,125,1025,237,793,33,43,47,147,
            1162,74,679,2912,2939,1077,125,138,1077,125,
            751,68,157,159,1077,125,1134,1006,757,125,
            2916,975,320,33,43,47,1078,46,687,630,
            211,180,915,917,157,125,974,740,506,33,
            514,47,573,46,687,630,118,119,922,101,
            341,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,742,96,83,
            84,743,94,745,78,744,70,747,66,234,
            746,64,49,1026,74,269,2949,2918,215,181,
            37,25,210,1000,1107,232,2910,112,113,1077,
            125,1135,5,1121,1122,1123,193,1125,230,2932,
            2934,157,125,974,740,506,33,514,47,573,
            46,687,630,118,119,922,101,341,111,116,
            117,141,142,143,144,145,146,164,165,166,
            167,168,102,108,742,96,83,84,743,94,
            745,78,744,70,747,66,234,746,64,251,
            252,253,254,251,252,253,254,2922,714,245,
            347,321,232,540,232,71,567,579,239,324,
            931,1058,125,62,468,1063,2935,2934,399,125,
            974,740,506,33,514,47,573,46,687,630,
            118,119,922,101,341,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,742,96,83,84,743,94,745,78,744,
            70,747,66,224,746,64,424,262,1081,1129,
            1058,125,62,820,1077,399,125,974,740,506,
            33,514,47,573,46,687,630,118,119,922,
            101,341,111,116,117,141,142,143,144,145,
            146,164,165,166,167,168,102,108,742,96,
            83,84,743,94,745,78,744,70,747,66,
            224,746,64,812,1096,433,1129,1058,125,62,
            820,2909,399,125,974,740,506,33,514,47,
            573,46,687,630,118,119,922,101,341,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,742,96,83,84,743,
            94,745,78,744,70,747,66,224,746,64,
            813,1113,434,1129,1058,125,62,820,2913,79,
            125,974,740,506,33,514,47,573,46,687,
            630,118,119,922,101,341,111,116,117,141,
            142,143,144,145,146,164,165,166,167,168,
            102,108,742,96,83,84,743,94,745,78,
            744,70,747,66,916,746,64,814,1126,435,
            1074,888,883,852,70,904,1049,965,315,1148,
            932,1075,148,1058,125,62,1152,1134,158,159,
            399,125,974,740,506,33,514,47,573,46,
            687,630,118,119,922,101,341,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,742,96,83,84,743,94,745,
            78,744,70,747,66,224,746,64,437,1007,
            1153,1129,943,988,1139,403,2926,471,125,974,
            740,506,33,514,47,573,46,687,630,118,
            119,922,101,341,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            742,96,83,84,743,94,745,78,744,70,
            747,66,2930,746,64,191,2929,399,125,974,
            740,506,33,514,47,573,46,687,630,118,
            119,922,101,341,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            742,96,83,84,743,94,745,78,744,70,
            747,66,224,746,64,681,1154,1155,1129,1044,
            882,1059,1027,2936,327,125,974,740,506,33,
            514,47,573,46,687,630,118,119,922,101,
            341,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,742,96,83,
            84,743,94,745,78,744,70,747,66,224,
            746,64,122,1064,876,921,327,125,974,740,
            506,33,514,47,573,46,687,630,118,119,
            922,101,341,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,742,
            96,83,84,743,94,745,78,744,70,747,
            66,224,746,64,121,1109,820,973,327,125,
            974,740,506,33,514,47,573,46,687,630,
            118,119,922,101,341,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,742,96,83,84,743,94,745,78,744,
            70,747,66,224,746,64,2914,1163,820,2927,
            242,125,974,740,506,33,514,47,573,46,
            687,630,118,119,922,101,341,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,742,96,83,84,743,94,745,
            78,744,70,747,66,234,746,64,2915,1166,
            1171,1174,1177,1179,1183,1185,1111,1119,908,921,
            1078,233,327,125,974,740,506,33,514,47,
            573,46,687,630,118,119,922,101,341,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,742,96,83,84,743,
            94,745,78,744,70,747,66,257,746,64,
            327,125,974,740,506,33,514,47,573,46,
            687,630,118,119,922,101,341,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,742,96,83,84,743,94,745,
            78,744,70,747,66,256,746,64,327,125,
            974,740,506,33,514,47,573,46,687,630,
            118,119,922,101,341,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,742,96,83,84,743,94,745,78,744,
            70,747,66,272,746,64,327,125,974,740,
            506,33,514,47,573,46,687,630,118,119,
            922,101,341,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,742,
            96,83,84,743,94,745,78,744,70,747,
            66,271,746,64,327,125,974,740,506,33,
            514,47,573,46,687,630,118,119,922,101,
            341,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,742,96,83,
            84,743,94,745,78,744,70,747,66,270,
            746,64,327,125,974,740,506,33,514,47,
            573,46,687,630,118,119,922,101,341,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,742,96,83,84,743,
            94,745,78,744,70,747,66,263,746,64,
            327,125,974,740,506,33,514,47,573,46,
            687,630,118,119,922,101,341,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,742,96,83,84,743,94,745,
            78,744,70,747,66,192,746,64,327,125,
            974,740,506,33,514,47,573,46,687,630,
            118,119,922,101,341,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,742,96,83,84,743,94,745,78,744,
            70,747,66,810,746,64,327,125,974,740,
            506,33,514,47,573,46,687,630,118,119,
            922,101,341,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,742,
            96,83,84,743,94,745,78,744,70,747,
            66,815,746,64,327,125,974,740,506,33,
            514,47,573,46,687,630,118,119,922,101,
            341,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,742,96,83,
            84,743,94,745,78,744,70,747,66,266,
            746,64,327,125,974,740,506,33,514,47,
            573,46,687,630,118,119,922,101,341,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,742,96,83,84,743,
            94,745,78,744,70,747,66,265,746,64,
            327,125,974,740,506,33,514,47,573,46,
            687,630,118,119,922,101,341,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,742,96,83,84,743,94,745,
            78,744,70,747,66,226,746,64,327,125,
            974,740,506,33,514,47,573,46,687,630,
            118,119,922,101,341,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,742,96,83,84,743,94,745,78,744,
            70,747,66,162,746,64,327,125,974,740,
            506,33,514,47,573,46,687,630,118,119,
            922,101,341,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,742,
            96,83,84,743,94,745,78,744,70,747,
            66,2917,746,64,327,125,974,740,506,33,
            514,47,573,46,687,630,118,119,922,101,
            341,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,742,96,83,
            84,743,94,745,78,744,70,747,66,163,
            746,64,327,125,974,740,506,33,514,47,
            573,46,687,630,118,119,922,101,341,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,742,96,83,84,743,
            94,745,78,744,70,747,66,161,746,64,
            327,125,974,740,506,33,514,47,573,46,
            687,630,118,119,922,101,341,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,742,96,83,84,743,94,745,
            78,744,70,747,66,193,746,64,327,125,
            974,740,506,33,514,47,573,46,687,630,
            118,119,922,101,341,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,742,96,83,84,743,94,745,78,744,
            70,747,66,225,746,64,327,125,974,740,
            506,33,514,47,573,46,687,630,118,119,
            922,101,341,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,742,
            96,83,84,743,94,745,78,744,70,747,
            66,2944,746,64,327,125,974,740,506,33,
            514,47,573,46,687,630,118,119,922,101,
            341,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,742,96,83,
            84,743,94,745,78,744,70,747,66,2948,
            746,64,327,125,974,740,506,33,514,47,
            573,46,687,630,118,119,922,101,341,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,742,96,83,84,743,
            94,745,78,744,70,747,66,3025,746,64,
            327,125,974,740,506,33,514,47,573,46,
            687,630,118,119,922,101,341,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,742,96,83,84,743,94,745,
            78,744,70,747,66,3026,746,64,327,125,
            974,740,506,33,514,47,573,46,687,630,
            118,119,922,101,341,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,742,96,83,84,743,94,745,78,744,
            70,747,66,3027,746,64,327,125,974,740,
            506,33,514,47,573,46,687,630,118,119,
            922,101,341,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,102,108,742,
            96,83,84,743,94,745,78,744,70,1140,
            68,327,125,974,740,506,33,514,47,573,
            46,687,630,118,119,922,101,341,111,116,
            117,141,142,143,144,145,146,164,165,166,
            167,168,102,108,742,96,83,84,743,94,
            745,78,2890,76,327,125,974,740,506,33,
            514,47,573,46,687,630,118,119,922,101,
            341,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,102,108,742,96,83,
            84,743,94,745,78,2891,75,327,125,974,
            740,506,33,514,47,573,46,687,630,118,
            119,922,101,341,111,116,117,141,142,143,
            144,145,146,164,165,166,167,168,102,108,
            742,96,83,84,743,94,745,78,2900,74,
            327,125,974,740,506,33,514,47,573,46,
            687,630,118,119,922,101,341,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,742,96,83,84,743,94,1138,
            82,327,125,974,740,506,33,514,47,573,
            46,687,630,118,119,922,101,341,111,116,
            117,141,142,143,144,145,146,164,165,166,
            167,168,102,108,742,96,83,84,743,94,
            1139,80,327,125,974,740,506,33,514,47,
            573,46,687,630,118,119,922,101,341,111,
            116,117,141,142,143,144,145,146,164,165,
            166,167,168,102,108,742,96,91,92,743,
            94,327,125,974,740,506,33,514,47,573,
            46,687,630,118,119,922,101,341,111,116,
            117,141,142,143,144,145,146,164,165,166,
            167,168,102,108,742,96,89,90,743,94,
            327,125,974,740,506,33,514,47,573,46,
            687,630,118,119,922,101,341,111,116,117,
            141,142,143,144,145,146,164,165,166,167,
            168,102,108,742,96,87,88,743,94,327,
            125,974,740,506,33,514,47,573,46,687,
            630,118,119,922,101,341,111,116,117,141,
            142,143,144,145,146,164,165,166,167,168,
            102,108,742,96,85,86,743,94,543,125,
            974,740,506,33,514,47,573,46,687,630,
            118,119,922,101,341,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,102,
            108,1136,100,543,125,974,740,506,33,514,
            47,573,46,687,630,118,119,922,101,341,
            111,116,117,141,142,143,144,145,146,164,
            165,166,167,168,102,108,1137,98,543,125,
            974,740,506,33,514,47,573,46,687,630,
            118,119,922,105,341,111,116,117,141,142,
            143,144,145,146,164,165,166,167,168,106,
            108,543,125,974,740,506,33,514,47,573,
            46,687,630,118,119,922,103,341,111,116,
            117,141,142,143,144,145,146,164,165,166,
            167,168,104,108,690,125,974,740,506,33,
            514,47,573,46,687,630,118,119,922,110,
            341,111,116,117,141,142,143,144,145,146,
            164,165,166,167,168,690,125,974,740,506,
            33,514,47,573,46,687,630,118,119,922,
            109,341,111,116,117,141,142,143,144,145,
            146,164,165,166,167,168,612,125,974,740,
            506,33,514,47,573,46,687,630,118,119,
            922,109,341,111,116,117,141,142,143,144,
            145,146,164,165,166,167,168,816,125,2916,
            224,231,1132,43,47,2971,46,687,630,211,
            314,1188,1169,905,196,1039,498,501,1189,1190,
            1196,685,1181,1197,1198,1203,976,1187,616,1206,
            1023,196,1120,498,501,1207,1208,1094,154,1101,
            1209,1026,1210,1211,1215,1216,1217,1023,196,973,
            498,501,905,196,1218,498,501,351,1219,235,
            684,49,1026,191,242,438,197,198,178,191,
            205,210,250,252,253,254,217,239,240,1131,
            1133,820,195,197,198,250,252,253,254,179,
            182,183,332,244,432,347,324,55,1158,195,
            197,198,680,685,752,197,198,436,191,204,
            1158,261,237,421,56,905,196,1159,498,501,
            905,196,268,498,501,905,196,504,498,501,
            363,218,1159,757,820,1222,1224,1225,3097,685,
            3097,3097,685,3097,685,820,191,207,685,505,
            749,191,204,3097,820,756,3097,3097,191,209,
            3097,352,3097,3097,3097,191,59,190,197,198,
            206,3097,420,197,198,3097,809,236,197,198,
            191,59,208,2901,124,2902,748,191,2928,919,
            191,60,191,2947,3097,123,191,3020,2908,3097,
            2902,3097,3097,264,219,3097,3097
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,27,28,29,
            30,31,32,33,34,35,0,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,0,68,0,
            0,71,3,0,5,2,0,73,0,1,
            2,3,82,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,0,25,26,27,28,29,30,31,
            32,33,34,35,90,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,75,68,0,78,71,
            83,4,85,0,87,88,0,1,2,3,
            82,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,25,26,27,28,29,30,31,32,33,
            34,35,0,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,0,68,72,3,71,5,0,
            0,0,3,3,0,5,0,84,0,1,
            6,0,1,2,3,89,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,73,25,26,27,28,
            29,30,31,32,33,34,35,0,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,70,68,
            76,77,71,0,0,79,3,3,5,0,
            0,1,91,0,1,6,0,1,2,3,
            89,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            0,25,26,27,28,29,30,31,32,33,
            34,35,0,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,70,68,76,77,71,0,1,
            2,3,0,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,72,25,26,27,28,29,30,31,
            32,33,34,35,72,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,0,68,0,1,71,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,92,25,26,27,28,29,
            30,31,32,33,34,35,0,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,70,68,0,
            1,71,0,1,2,3,0,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,0,25,26,27,
            28,29,30,31,32,33,34,35,0,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,0,
            68,0,1,2,3,0,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,69,25,26,27,28,
            29,30,31,32,33,34,35,69,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,0,0,
            0,2,67,0,0,2,2,0,73,0,
            1,2,3,82,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,25,26,27,28,29,30,
            31,32,33,34,35,0,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,0,79,2,3,
            80,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            67,25,26,27,28,29,30,31,32,33,
            34,35,0,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,0,24,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            25,26,27,28,29,30,31,32,33,34,
            35,0,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,0,0,1,3,4,5,
            6,0,0,0,3,34,35,0,1,70,
            16,17,18,19,20,21,22,23,16,17,
            26,27,28,0,0,24,2,0,34,35,
            36,7,8,9,10,11,12,13,14,15,
            0,18,19,20,21,18,19,20,21,0,
            0,0,1,29,30,31,32,33,18,19,
            20,21,0,1,0,70,72,73,74,75,
            76,77,78,79,80,24,81,83,84,85,
            86,87,88,59,0,91,92,93,94,95,
            96,0,0,2,0,0,1,6,7,8,
            9,10,11,12,13,14,15,0,1,0,
            26,27,28,22,23,0,25,67,24,0,
            29,30,31,32,33,0,0,0,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,0,24,2,0,0,22,23,7,
            8,9,10,11,12,13,14,15,0,67,
            2,0,36,0,6,70,0,75,0,24,
            78,29,30,31,32,33,81,0,0,2,
            0,36,0,0,7,8,9,10,11,12,
            13,14,15,0,0,1,0,0,2,36,
            0,59,25,7,8,9,10,11,12,13,
            14,15,67,0,36,0,70,72,24,36,
            0,25,96,26,27,28,0,81,0,1,
            0,73,0,75,76,77,78,79,0,0,
            0,0,0,80,0,0,16,17,90,36,
            24,69,74,0,16,17,36,74,0,1,
            67,22,23,95,24,24,24,0,24,69,
            3,0,0,0,0,4,4,0,0,2,
            2,0,0,2,69,0,4,74,0,36,
            0,1,72,0,1,67,0,1,0,1,
            0,69,0,1,0,1,0,0,0,0,
            36,4,4,4,69,0,0,0,1,4,
            4,36,0,1,36,0,0,0,0,0,
            0,4,4,4,0,0,0,0,0,4,
            4,0,4,0,0,4,0,4,4,24,
            24,0,1,0,24,0,0,0,0,86,
            0,0,0,0,0,0,0,67,0,0,
            36,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,93,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,94,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            155,1478,510,3104,247,3105,3132,3227,3225,3226,
            3228,3229,3230,3231,3232,3233,508,3108,3109,3110,
            3111,3112,3133,3134,238,3223,3113,3114,3115,738,
            681,624,568,515,3106,2856,258,509,3129,3118,
            3119,3120,3121,3122,3123,3124,3125,3126,3127,3128,
            3131,2794,3102,3103,3101,3100,3098,3099,3149,507,
            741,3270,3267,3269,3271,3272,3274,107,2993,69,
            260,1526,2461,3097,2420,3234,3097,331,3097,1478,
            510,3104,1718,3105,3132,3227,3225,3226,3228,3229,
            3230,3231,3232,3233,508,3108,3109,3110,3111,3112,
            3133,3134,3097,3223,3113,3114,3115,738,681,624,
            568,515,3106,2856,414,509,3129,3118,3119,3120,
            3121,3122,3123,3124,3125,3126,3127,3128,3131,2794,
            3102,3103,3101,3100,3098,3099,3149,507,741,3270,
            3267,3269,3271,3272,3274,753,2993,3097,684,1526,
            2887,3297,348,3097,429,344,230,1478,510,3104,
            1718,3105,3132,3227,3225,3226,3228,3229,3230,3231,
            3232,3233,508,3108,3109,3110,3111,3112,3133,3134,
            3097,3223,3113,3114,3115,738,681,624,568,515,
            3106,2825,249,509,3129,3118,3119,3120,3121,3122,
            3123,3124,3125,3126,3127,3128,3131,2794,3102,3103,
            3101,3100,3098,3099,3149,507,741,3270,3267,3269,
            3271,3272,3274,73,2993,2054,2461,1526,2420,190,
            72,3097,1430,2461,3097,2420,3097,3034,171,10,
            511,3097,1478,510,3104,2933,3105,3132,3227,3225,
            3226,3228,3229,3230,3231,3232,3233,508,3108,3109,
            3110,3111,3112,3133,3134,331,3223,3113,3114,3115,
            738,681,624,568,515,3106,2825,3097,509,3129,
            3118,3119,3120,3121,3122,3123,3124,3125,3126,3127,
            3128,3131,2794,3102,3103,3101,3100,3098,3099,3149,
            507,741,3270,3267,3269,3271,3272,3274,10,2993,
            627,570,1526,71,3097,3096,2461,1574,2420,267,
            3097,2942,3343,176,44,511,3097,1478,510,3104,
            2933,3105,3132,3227,3225,3226,3228,3229,3230,3231,
            3232,3233,508,3108,3109,3110,3111,3112,3133,3134,
            3097,3223,3113,3114,3115,738,681,624,568,515,
            3106,2825,3097,509,3129,3118,3119,3120,3121,3122,
            3123,3124,3125,3126,3127,3128,3131,2794,3102,3103,
            3101,3100,3098,3099,3149,507,741,3270,3267,3269,
            3271,3272,3274,44,2993,627,570,1526,222,1478,
            510,3104,3097,3105,3132,3227,3225,3226,3228,3229,
            3230,3231,3232,3233,508,3108,3109,3110,3111,3112,
            3133,3134,2150,3223,3113,3114,3115,738,681,624,
            568,515,3106,2825,2198,509,3129,3118,3119,3120,
            3121,3122,3123,3124,3125,3126,3127,3128,3131,2794,
            3102,3103,3101,3100,3098,3099,3149,507,741,3270,
            3267,3269,3271,3272,3274,3097,2993,48,43,1526,
            3097,1478,2931,3104,3097,3105,3132,3227,3225,3226,
            3228,3229,3230,3231,3232,3233,508,3108,3109,3110,
            3111,3112,3133,3134,1766,3223,3113,3114,3115,738,
            681,624,568,515,3106,2825,3097,509,3129,3118,
            3119,3120,3121,3122,3123,3124,3125,3126,3127,3128,
            3131,2794,3102,3103,3101,3100,3098,3099,3149,507,
            741,3270,3267,3269,3271,3272,3274,4601,2993,3097,
            2950,1526,3097,1478,510,3104,3097,3105,3132,3227,
            3225,3226,3228,3229,3230,3231,3232,3233,508,3108,
            3109,3110,3111,3112,3133,3134,3097,3223,3113,3114,
            3115,738,681,624,568,515,3106,2825,3097,509,
            3129,3118,3119,3120,3121,3122,3123,3124,3125,3126,
            3127,3128,3131,2794,3102,3103,3101,3100,3098,3099,
            3149,507,741,3270,3267,3269,3271,3272,3274,3097,
            2993,3097,1478,510,3104,248,3105,3132,3227,3225,
            3226,3228,3229,3230,3231,3232,3233,508,3108,3109,
            3110,3111,3112,3133,3134,273,3223,3113,3114,3115,
            738,681,624,568,515,3106,2825,2988,509,3129,
            3118,3119,3120,3121,3122,3123,3124,3125,3126,3127,
            3128,3131,2794,3102,3103,3101,3100,3098,3099,3149,
            507,741,3270,3267,3269,3271,3272,3274,259,3097,
            3097,750,335,202,3097,325,325,3097,331,3097,
            1478,510,3104,1862,3105,3132,3227,3225,3226,3228,
            3229,3230,3231,3232,3233,508,3108,3109,3110,3111,
            3112,3133,3134,199,3223,3113,3114,3115,738,681,
            624,568,515,3106,2825,3097,509,3129,3118,3119,
            3120,3121,3122,3123,3124,3125,3126,3127,3128,3131,
            2794,3102,3103,3101,3100,3098,3099,3149,507,741,
            3270,3267,3269,3271,3272,3274,3097,241,3224,3104,
            3246,3105,3132,3227,3225,3226,3228,3229,3230,3231,
            3232,3233,3107,3108,3109,3110,3111,3112,3133,3134,
            335,3223,3113,3114,3115,3135,3136,3137,3138,3139,
            3106,3116,189,3141,3129,3118,3119,3120,3121,3122,
            3123,3124,3125,3126,3127,3128,3131,3117,3102,3103,
            3101,3100,3098,3099,3149,3097,2903,3224,3104,220,
            3105,3132,3227,3225,3226,3228,3229,3230,3231,3232,
            3233,3107,3108,3109,3110,3111,3112,3133,3134,3097,
            3223,3113,3114,3115,3135,3136,3137,3138,3139,3106,
            3116,93,3141,1130,3118,3119,3120,3121,3122,3123,
            3124,3125,3126,3127,3128,3131,3117,3102,3103,3101,
            3100,3098,3099,3149,45,220,45,3318,3318,3318,
            3318,189,95,3097,1910,2693,2658,3097,518,3318,
            3318,3318,3318,3318,3318,3318,3318,3318,2761,2728,
            3318,3318,3318,77,3097,2903,3234,81,3318,3318,
            3318,3227,3225,3226,3228,3229,3230,3231,3232,3233,
            79,2619,2580,2541,2502,2619,2580,2541,2502,3097,
            127,3097,3007,3247,3248,3249,3250,3251,2619,2580,
            2541,2502,3097,575,3097,4244,3318,3318,3318,3318,
            3318,3318,3318,3318,3318,3005,976,3318,3318,3318,
            3318,3318,3318,503,65,3318,3318,3318,3318,3318,
            3318,3097,3097,3224,3097,220,45,3132,3227,3225,
            3226,3228,3229,3230,3231,3232,3233,3097,330,3097,
            2377,2334,2291,3133,3134,3097,3223,137,1142,3097,
            3135,3136,3137,3138,3139,3097,3097,3097,3141,3129,
            3118,3119,3120,3121,3122,3123,3124,3125,3126,3127,
            3128,3131,194,1190,3234,127,220,351,423,3227,
            3225,3226,3228,3229,3230,3231,3232,3233,258,338,
            325,3097,2911,3097,511,4244,3097,753,63,2903,
            684,3247,3248,3249,3250,3251,1028,61,3097,3224,
            3097,189,42,3097,3227,3225,3226,3228,3229,3230,
            3231,3232,3233,3097,138,3022,3097,67,3224,3000,
            41,503,3223,3227,3225,3226,3228,3229,3230,3231,
            3232,3233,137,3097,1958,40,3318,189,3010,1958,
            3097,3223,1670,2377,2334,2291,3097,924,148,760,
            99,331,39,753,627,570,684,243,97,255,
            3097,3097,3097,3266,3097,38,2761,2728,414,1958,
            1238,154,3024,203,2761,2728,3038,3035,3097,632,
            321,259,259,2246,1286,1334,2992,3097,1382,153,
            1622,3097,3097,160,156,3298,3217,3097,57,920,
            325,139,3097,3234,152,223,3211,3044,58,2911,
            32,50,2102,3097,3029,138,33,51,3097,817,
            140,151,3097,364,3097,441,3097,3097,3097,3097,
            689,2919,2925,3311,150,3097,3097,3097,867,3313,
            3310,1958,218,575,3032,3097,3097,3097,3097,3097,
            235,3212,3281,3326,231,3097,3097,3097,3097,3325,
            3309,3097,3284,3097,3097,3282,3097,3285,3283,2920,
            2937,48,43,3097,3015,3097,3097,3097,3097,1814,
            3097,3097,3097,3097,3097,3097,3097,335,3097,3097,
            1080,3097,3097,3097,3097,3097,3097,3097,3097,3097,
            3097,3097,3097,3097,3097,3097,3097,3097,3097,3097,
            3097,3097,3097,3097,3097,3097,3097,3097,3097,2006,
            3097,3097,3097,3097,3097,3097,3097,3097,3097,3097,
            3097,3097,3097,3097,3097,3097,3097,3097,3097,3097,
            3097,3097,3097,3097,3097,3097,3097,3097,3097,3097,
            3097,3324
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            409,419,69,209,210,257,257,257,257,257,
            143,145,143,418,52,268,268,268,268,268,
            268,268,426,310,391,248,148,387,387,79,
            79,79,79,79,143,79,167,133,166,307,
            133,163,79,52,378,143,81,81,79,381,
            381,381,169,169,171,171,213,271,270,270,
            270,270,270,272,271,393,387,274,278,79,
            280,286,282,291,288,384,384,386,389,379,
            379,454,74,379,387,387,387,1,143,79,
            79,111,314,90,90,133,133,80,80,395,
            80,80,79,79,79,79,79,79,79,79,
            79,79,79,79,52,378,52,378,143,79,
            314,378,314,404,397,79,4,403,403,401,
            406,406,215,379,454,381,171,271,273,171,
            387,171,387,387,387,79,278,278,282,282,
            288,286,286,286,379,454,210,379,379,379,
            421,379,79,79,2,143,79,79,273,273,
            314,387,216,79,143,79,77,77,424,268,
            143,207,268,379,314,406,160,254,379,430,
            379,453,454,379,79,51,457,379,273,143,
            79,143,79,52,78,477,255,379,255,379,
            79,79,379,379
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static byte asr[] = {0,
            80,71,68,60,38,50,6,22,23,39,
            40,41,42,43,44,45,46,47,48,49,
            25,66,37,62,16,63,61,64,65,58,
            56,57,55,54,52,53,5,34,17,18,
            19,20,21,26,27,28,1,35,51,82,
            3,8,9,7,10,11,12,13,14,15,
            59,29,30,31,32,33,2,0,4,72,
            84,79,24,36,96,0,4,89,71,68,
            60,66,62,63,61,64,65,59,1,58,
            56,57,55,54,52,53,3,5,34,16,
            17,18,19,20,21,26,27,28,35,51,
            37,39,40,41,42,43,44,45,46,47,
            48,49,38,50,6,22,23,29,30,31,
            32,33,25,8,9,7,10,11,12,13,
            14,15,2,0,79,90,0,3,4,80,
            36,76,77,96,6,22,23,79,67,72,
            84,0,79,75,78,73,91,0,69,0,
            34,35,16,17,18,19,3,20,21,5,
            4,80,74,83,72,36,84,85,86,87,
            88,75,76,77,78,92,93,94,26,27,
            28,95,96,6,1,70,73,91,79,23,
            22,0,81,70,67,34,35,16,17,18,
            19,20,21,5,74,83,85,86,87,88,
            75,76,77,73,91,78,92,93,94,26,
            27,28,95,6,22,23,1,4,80,84,
            96,79,3,36,72,0,25,2,8,9,
            7,10,11,12,13,14,15,24,0,69,
            1,81,70,87,88,83,85,16,17,34,
            35,18,19,20,21,3,5,26,27,28,
            4,80,74,72,36,84,86,75,78,92,
            93,94,96,22,23,95,73,91,79,76,
            77,6,0,71,60,38,50,6,22,23,
            29,30,31,32,33,39,40,41,42,43,
            44,45,46,47,48,49,8,9,7,10,
            11,12,13,14,15,25,66,37,62,16,
            63,61,64,65,59,58,56,57,55,54,
            52,53,3,5,34,17,18,19,20,21,
            26,27,28,1,35,51,68,2,4,0,
            1,70,0,3,0,24,1,0,1,24,
            75,78,67,0,92,0,80,36,86,0,
            24,3,36,80,0,74,36,0,22,23,
            90,75,78,76,77,6,2,73,79,0,
            4,67,0,93,0,91,73,67,0,72,
            67,34,35,16,17,18,19,3,20,21,
            5,1,81,83,85,70,87,88,26,27,
            28,95,24,4,36,0,76,77,6,8,
            9,7,10,11,12,13,14,15,59,29,
            30,31,32,33,2,0,94,0
        };
    };
    public final static byte asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static byte nasb[] = {0,
            81,31,31,31,31,21,21,21,21,21,
            30,15,1,17,29,31,31,31,31,31,
            31,31,85,89,87,31,31,31,31,26,
            26,26,26,26,95,26,31,44,17,13,
            44,19,26,29,91,91,26,26,26,23,
            23,23,31,31,31,31,31,31,31,31,
            31,31,31,23,23,31,31,4,31,26,
            31,31,31,31,31,31,31,31,31,31,
            31,31,31,31,31,31,31,26,93,26,
            26,10,26,7,74,44,44,67,67,31,
            60,60,46,46,53,53,53,53,32,39,
            39,39,26,26,29,102,29,102,100,26,
            26,30,26,31,31,26,26,31,31,31,
            31,31,31,31,31,23,23,23,23,31,
            31,31,31,31,31,26,31,31,31,31,
            31,31,31,31,31,31,83,31,31,31,
            31,31,26,26,26,99,26,26,23,23,
            26,31,31,26,100,25,26,26,31,31,
            100,31,31,31,26,31,31,31,31,31,
            31,31,31,31,26,29,29,31,23,100,
            26,100,26,29,26,31,31,31,31,31,
            26,26,31,31
        };
    };
    public final static byte nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            3,85,0,86,87,0,11,65,13,2,
            8,0,63,0,78,0,57,0,62,0,
            55,0,50,0,49,2,6,11,4,3,
            0,3,2,6,4,11,44,0,6,11,
            3,4,42,2,0,3,2,6,4,11,
            40,0,6,2,11,3,4,36,0,6,
            2,11,3,4,34,0,3,2,6,4,
            11,31,0,5,82,2,11,65,92,0,
            79,98,77,0,79,0,100,0,102,0,
            73,0,91,0,48,84,101,0,72,49,
            0,68,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            11,98,7,12,10,55,86,87,88,89,
            90,92,93,94,95,3,4,5,6,8,
            9,56,57,20,34,46,47,48,61,62,
            63,64,65,1,2,19,58,66,67,68,
            69,70,71,72,73,74,75,76,77,85,
            49,78,79,80,81,82,83,84,91,30,
            31,32,33,53,54,96,21,51,13,25,
            42,18,38,16,35,36,37,41,97,14,
            15,99,17,22,23,24,26,27,28,39,
            40,43,44,45,50,52,59,60,100
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            0,104,113,136,101,102,0,105,0,103,
            110,0,134,106,129,131,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            130,0,127,128,124,125,126,0,122,123,
            120,121,118,119,116,117,0,142,115,0,
            135,143,0,0,0,0,154,0,0,0,
            147,149,150,0,107,0,0,114,138,0,
            140,144,145,0,0,146,151,152,153,0,
            0,108,109,111,112,132,133,0,0,137,
            139,141,0,0,0,0,0,148,0,155,
            156,157,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            83,117,13,111,141,168,91,125,1,8,
            53,58,63,22,68,72,147,151,157,174,
            46,76,161,46,101,131,101,131,165,40,
            31,178,178,186,186,194,194,194,194,208,
            208,216,216,216
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            6,6,20,6,6,6,97,97,6,6,
            6,6,6,27,6,6,6,155,155,6,
            50,80,50,50,97,97,105,135,6,43,
            34,180,183,188,191,196,199,202,205,210,
            213,218,221,224
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            94,93,38,94,93,16,94,93,87,87,
            13,12,71,38,53,54,93,22,21,16,
            74,49,18,18,94,93,94,93,17,32,
            38,34,34,36,36,40,40,40,40,42,
            42,44,44,44
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static byte scopeLa[] = {
            4,4,94,4,4,4,72,72,4,4,
            4,4,4,93,4,4,4,80,80,4,
            74,3,74,74,72,72,84,36,4,96,
            92,17,16,35,34,21,20,19,18,5,
            3,28,27,26
        };
    };
    public final static byte scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static byte scopeStateSet[] = {
            2,2,15,2,2,8,2,2,4,4,
            7,6,1,15,63,63,2,8,8,8,
            1,71,8,8,2,2,2,2,8,11,
            15,13,13,15,15,19,19,19,19,21,
            21,24,24,24
        };
    };
    public final static byte scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            174,1,101,88,0,12,0,174,1,101,
            87,0,144,93,144,92,144,71,0,45,
            0,144,92,144,71,0,44,116,45,0,
            144,71,0,43,116,44,116,45,0,172,
            68,0,52,116,0,150,81,101,0,16,
            0,0,155,1,149,107,0,155,1,149,
            109,0,155,1,149,164,0,194,1,59,
            0,151,1,103,0,151,24,2,0,7,
            116,0,144,72,148,84,148,1,181,0,
            148,84,148,1,181,0,18,116,12,0,
            148,1,181,0,22,115,18,116,12,0,
            144,72,148,1,181,0,144,72,148,36,
            148,1,182,0,148,36,148,1,182,0,
            148,1,182,0,19,115,18,116,12,0,
            144,72,148,1,182,0,144,1,182,0,
            190,69,59,0,14,0,188,69,103,0,
            150,81,113,0,144,1,0,155,1,101,
            67,102,0,155,1,60,0,132,0,4,
            130,0,3,130,0,136,0,2,128,0,
            1,128,0,138,0,9,125,0,8,125,
            0,6,125,0,5,125,0,140,0,10,
            123,0,7,123,0,142,0,48,121,0,
            47,121,0,46,121,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            348,2887,0,341,0,2887,348,2856,2825,2794,
            2761,2728,2693,2658,2619,2580,2541,2502,2461,2420,
            2377,2334,2291,2198,2150,1080,2102,2054,2006,867,
            441,364,817,1028,760,1958,1910,689,1862,1814,
            1766,1718,632,575,1670,1622,1574,2246,518,976,
            924,273,1526,1478,1430,1382,1334,1286,1238,1190,
            1142,0,3015,2937,2920,3010,3005,2942,2903,0,
            3038,3034,3032,817,3029,3000,2911,3022,3007,2988,
            2993,2950,2905,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,180,2,176,179,6,77,76,78,75,
            90,197,73,178,24,22,23,154,154,154,
            154,154,102,184,102,151,102,103,59,24,
            24,24,24,24,24,24,198,67,178,201,
            67,199,3,1,1,68,51,35,1,107,
            110,109,103,59,16,37,2,105,33,32,
            31,30,29,113,101,102,60,115,132,71,
            136,140,138,145,142,183,147,2,101,151,
            194,172,172,144,149,149,149,69,69,81,
            81,67,1,85,83,88,87,17,16,144,
            35,34,5,3,21,20,19,18,95,28,
            27,26,3,3,24,1,24,1,36,96,
            1,1,1,188,144,82,35,189,190,2,
            150,150,101,155,150,164,107,101,107,38,
            181,104,182,101,101,92,132,132,138,138,
            142,140,140,140,165,167,151,165,155,195,
            102,155,86,82,36,36,3,36,74,74,
            1,149,149,81,1,1,1,1,144,4,
            36,176,4,155,1,150,148,148,144,2,
            174,89,175,174,93,24,24,155,74,84,
            72,36,72,24,36,144,148,144,148,144,
            72,72,144,144
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "",
            "+",
            "-",
            "*",
            "/",
            ">",
            "<",
            "=",
            ">=",
            "<=",
            "<>",
            "(",
            ")",
            "{",
            "}",
            "[",
            "]",
            "->",
            "|",
            ",",
            ":",
            "::",
            ";",
            ".",
            "..",
            "@pre",
            "^",
            "^^",
            "?",
            "$empty",
            "NUMERIC_OPERATION",
            "STRING_LITERAL",
            "INTEGER_LITERAL",
            "REAL_LITERAL",
            "self",
            "inv",
            "pre",
            "post",
            "context",
            "package",
            "endpackage",
            "def",
            "if",
            "then",
            "else",
            "endif",
            "and",
            "or",
            "xor",
            "not",
            "implies",
            "let",
            "in",
            "true",
            "false",
            "body",
            "derive",
            "init",
            "null",
            "attr",
            "oper",
            "Set",
            "Bag",
            "Sequence",
            "Collection",
            "OrderedSet",
            "iterate",
            "forAll",
            "exists",
            "isUnique",
            "any",
            "one",
            "collect",
            "select",
            "reject",
            "collectNested",
            "sortedBy",
            "closure",
            "oclIsKindOf",
            "oclIsTypeOf",
            "oclAsType",
            "oclIsNew",
            "oclIsUndefined",
            "oclIsInvalid",
            "oclIsInState",
            "allInstances",
            "String",
            "Integer",
            "UnlimitedNatural",
            "Real",
            "Boolean",
            "Tuple",
            "OclAny",
            "OclVoid",
            "Invalid",
            "OclMessage",
            "OclInvalid",
            "EOF_TOKEN",
            "IDENTIFIER",
            "INTEGER_RANGE_START",
            "ERROR_TOKEN",
            "iteratorIdentifier",
            "keywordAsIdentifier1",
            "binaryName",
            "simpleNameCS",
            "keywordAsName",
            "keywordAsName1",
            "unaryName",
            "iterateName",
            "iteratorName",
            "oclIsInStateName",
            "operationCS1",
            "operationCS2",
            "pathNameCS",
            "parametersCS",
            "variableCS",
            "oclExpressionCS",
            "impliesExpCS",
            "andOrXorExpCS",
            "andOrXorWithLet",
            "equalityExpCS",
            "equalityWithLet",
            "relationalExpCS",
            "relationalWithLet",
            "ifExpCSPrec",
            "additiveWithLet",
            "additiveExpCS",
            "multiplicativeExpCS",
            "multiplicativeWithLet",
            "unaryExpCS",
            "unaryWithLet",
            "dotArrowExpCS",
            "callExpCS",
            "messageExpCS",
            "keywordOperationCallExpCS",
            "argumentsCS",
            "collectionTypeIdentifierCS",
            "collectionLiteralPartsCS",
            "collectionLiteralPartCS",
            "variableListCS2",
            "featureCallExpCS",
            "loopExpCS",
            "typedVariableCS",
            "typeCS",
            "variableCS2",
            "variableListCS",
            "oclMessageArgumentsCS",
            "oclMessageArgCS",
            "packageDeclarationCSm",
            "invOrDefCS",
            "prePostOrBodyDeclCS",
            "initOrDerValueCS",
            "packageDeclarationCS",
            "contextDeclCSm",
            "contextDeclCS",
            "invOrDefCSm",
            "defExpressionCS",
            "prePostOrBodyDeclCSm"
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final static int
           ERROR_SYMBOL      = 99,
           SCOPE_UBOUND      = 43,
           SCOPE_SIZE        = 44,
           MAX_NAME_LENGTH   = 26;

    public final int getErrorSymbol() { return ERROR_SYMBOL; }
    public final int getScopeUbound() { return SCOPE_UBOUND; }
    public final int getScopeSize() { return SCOPE_SIZE; }
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int
           NUM_STATES        = 214,
           NT_OFFSET         = 99,
           LA_STATE_OFFSET   = 3369,
           MAX_LA            = 2,
           NUM_RULES         = 272,
           NUM_NONTERMINALS  = 104,
           NUM_SYMBOLS       = 203,
           SEGMENT_SIZE      = 8192,
           START_STATE       = 2905,
           IDENTIFIER_SYMBOL = 2,
           EOFT_SYMBOL       = 79,
           EOLT_SYMBOL       = 79,
           ACCEPT_ACTION     = 3096,
           ERROR_ACTION      = 3097;

    public final static boolean BACKTRACK = false;

    public final int getNumStates() { return NUM_STATES; }
    public final int getNtOffset() { return NT_OFFSET; }
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }
    public final int getMaxLa() { return MAX_LA; }
    public final int getNumRules() { return NUM_RULES; }
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }
    public final int getNumSymbols() { return NUM_SYMBOLS; }
    public final int getSegmentSize() { return SEGMENT_SIZE; }
    public final int getStartState() { return START_STATE; }
    public final int getStartSymbol() { return lhs[0]; }
    public final int getIdentifierSymbol() { return IDENTIFIER_SYMBOL; }
    public final int getEoftSymbol() { return EOFT_SYMBOL; }
    public final int getEoltSymbol() { return EOLT_SYMBOL; }
    public final int getAcceptAction() { return ACCEPT_ACTION; }
    public final int getErrorAction() { return ERROR_ACTION; }
    public final boolean isValidForParser() { return isValidForParser; }
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
