/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.activity.draw2d;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.uml2.diagram.activity.edit.parts.ActivityPartitionEditPart;
import org.eclipse.uml2.diagram.activity.edit.parts.ActivityPartition_ActivityPartitionEditPart;

public class PartitionLayout
extends XYLayout {
    public static int HORIZONTAL = 0;
    public static int VERTICAL = 1;
    private int partitionOrientation;
    private Map<?, ?> visualPartMap;

    public PartitionLayout() {
        this(HORIZONTAL);
    }

    public PartitionLayout(int orientation) {
        this.partitionOrientation = orientation;
    }

    public int getPartitionOrientation() {
        return this.partitionOrientation;
    }

    public void setViewer(EditPartViewer viewer) {
        this.visualPartMap = viewer.getVisualPartMap();
    }

    public void layout(IFigure parent) {
        Iterator children = parent.getChildren().iterator();
        Dimension clientAreaSize = parent.getClientArea().getSize();
        Point offset = this.getOrigin(parent);
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            Rectangle bounds = (Rectangle)this.getConstraint(f);
            if (bounds == null) continue;
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension preferredSize = f.getPreferredSize(bounds.width, bounds.height);
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = preferredSize.height;
                }
            }
            if (this.isPartition(f)) {
                if (this.getPartitionOrientation() == HORIZONTAL) {
                    bounds.x = 0;
                    bounds.width = clientAreaSize.width;
                } else {
                    bounds.y = 0;
                    bounds.height = clientAreaSize.height;
                }
            }
            bounds = bounds.getTranslated(offset);
            f.setBounds(bounds);
        }
    }

    private boolean isPartition(IFigure figure) {
        if (this.visualPartMap == null) {
            return false;
        }
        EditPart editPart = (EditPart)this.visualPartMap.get(figure);
        if (editPart == null) {
            return false;
        }
        return editPart instanceof ActivityPartitionEditPart || editPart instanceof ActivityPartition_ActivityPartitionEditPart;
    }
}

